/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.arjunacore;

import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAOnePhaseResource
implements OnePhaseResource {
    private XAResource xaResource;
    private RecoverableXAConnection recoverableXAConnection;
    private Xid xid;

    public XAOnePhaseResource() {
    }

    public XAOnePhaseResource(XAResource xaResource, Xid xid, Object[] params) {
        Object param;
        this.xaResource = xaResource;
        this.xid = xid;
        if (params != null && params.length >= 0 && (param = params[0]) instanceof RecoverableXAConnection) {
            this.recoverableXAConnection = (RecoverableXAConnection)param;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int commit() {
        boolean doForget = false;
        try {
            this.xaResource.commit(this.xid, true);
            int n = 7;
            return n;
        }
        catch (XAException xae) {
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug(1024L, 4L, 1L, "XAOnePhaseResource.commit(" + this.xid + ") " + xae.getMessage());
            }
            switch (xae.errorCode) {
                case 5: 
                case 8: {
                    int n = 6;
                    return n;
                }
                case 7: {
                    doForget = true;
                    return 10;
                }
                case 6: {
                    doForget = true;
                    int n = 10;
                    return n;
                }
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    int n = 10;
                    return n;
                }
                case -4: {
                    int n = 6;
                    return n;
                }
                case -7: 
                case -5: {
                    int n = 6;
                    return n;
                }
                case -6: 
                case 4: {
                    int n = 10;
                    return n;
                }
                default: {
                    int n = 8;
                    return n;
                }
            }
        }
        catch (Throwable ex) {
            if (!jtaLogger.logger.isDebugEnabled()) return 10;
            jtaLogger.logger.debug(1024L, 4L, 1L, "XAOnePhaseResource.commit(" + this.xid + ") " + ex.getMessage());
            return 10;
        }
        finally {
            block46: {
                try {
                    if (doForget) {
                        this.xaResource.forget(this.xid);
                    }
                }
                catch (Throwable ex) {
                    if (!jtaLogger.logger.isDebugEnabled()) break block46;
                    jtaLogger.logger.debug(1024L, 4L, 1L, "XAOnePhaseResource.commit(" + this.xid + ") called forget and got " + ex.getMessage());
                }
            }
        }
    }

    @Override
    public int rollback() {
        try {
            this.xaResource.rollback(this.xid);
            return 7;
        }
        catch (XAException xae) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.rollbackexception", new Object[]{this.xid, xae.getMessage()}, xae);
            }
            return 8;
        }
    }

    @Override
    public void pack(OutputObjectState os) throws IOException {
        XidImple.pack(os, this.xid);
        if (this.recoverableXAConnection != null) {
            os.packInt(0);
            os.packString(this.recoverableXAConnection.getClass().getName());
            this.recoverableXAConnection.packInto(os);
        } else {
            byte[] data;
            os.packInt(1);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.xaResource);
                oos.flush();
                oos.close();
                data = baos.toByteArray();
            }
            catch (IOException ioe) {
                String message = jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.pack", new Object[]{ioe});
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.pack", new Object[]{ioe});
                }
                IOException ioException = new IOException(message);
                ioException.initCause(ioe);
                throw ioException;
            }
            os.packBytes(data);
        }
    }

    @Override
    public void unpack(InputObjectState is) throws IOException {
        XidImple.unpack(is);
        int recoveryType = is.unpackInt();
        switch (recoveryType) {
            case 0: {
                Class<?> recoverableXAConnectionClass;
                String recoverableXAConnectionClassName = is.unpackString();
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    recoverableXAConnectionClass = contextClassLoader.loadClass(recoverableXAConnectionClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    throw XAOnePhaseResource.generateUnpackError(cnfe);
                }
                try {
                    this.recoverableXAConnection = (RecoverableXAConnection)recoverableXAConnectionClass.newInstance();
                }
                catch (InstantiationException ie) {
                    throw XAOnePhaseResource.generateUnpackError(ie);
                }
                catch (IllegalAccessException iae) {
                    throw XAOnePhaseResource.generateUnpackError(iae);
                }
                this.recoverableXAConnection.unpackFrom(is);
                try {
                    this.xaResource = this.recoverableXAConnection.getResource();
                    break;
                }
                catch (SQLException sqle) {
                    throw XAOnePhaseResource.generateUnpackError(sqle);
                }
            }
            case 1: {
                byte[] data = is.unpackBytes();
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    this.xaResource = (XAResource)ois.readObject();
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    throw XAOnePhaseResource.generateUnpackError(cnfe);
                }
                catch (IOException ioe) {
                    throw XAOnePhaseResource.generateUnpackError(ioe);
                }
                catch (ClassCastException cce) {
                    throw XAOnePhaseResource.generateUnpackError(cce);
                }
            }
            default: {
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpackType", new Object[]{new Integer(recoveryType)});
                }
                String message = jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpackType", new Object[]{new Integer(recoveryType)});
                throw new IOException(message);
            }
        }
    }

    private static IOException generateUnpackError(Exception ex) {
        if (jtaLogger.loggerI18N.isWarnEnabled()) {
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpack", new Object[]{ex}, ex);
        }
        String message = jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpack", new Object[]{ex});
        return new IOException(message);
    }
}

