/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;

public class AtomicAction
extends TwoPhaseCoordinator {
    public static final int NO_TIMEOUT = -1;
    private int _timeout = -1;

    public AtomicAction() {
    }

    public AtomicAction(Uid objUid) {
        super(objUid);
    }

    @Override
    public void finalize() {
        ThreadActionData.purgeAction(this);
        super.finalize();
    }

    public int begin() {
        return this.begin(-1);
    }

    public int begin(int timeout) {
        int status = super.start();
        if (status == 0) {
            ThreadActionData.pushAction(this);
            this._timeout = timeout;
            if (this._timeout == 0) {
                this._timeout = TxControl.getDefaultTimeout();
            }
            if (this._timeout > 0) {
                TransactionReaper.transactionReaper().insert(this, this._timeout);
            }
        }
        return status;
    }

    public int commit() {
        return this.commit(true);
    }

    public int commit(boolean report_heuristics) {
        int status = super.end(report_heuristics);
        ThreadActionData.popAction();
        TransactionReaper.transactionReaper().remove(this);
        return status;
    }

    public int abort() {
        int status = super.cancel();
        ThreadActionData.popAction();
        TransactionReaper.transactionReaper().remove(this);
        return status;
    }

    @Override
    public int end(boolean report_heuristics) {
        int outcome = super.end(report_heuristics);
        TransactionReaper.transactionReaper().remove(this);
        return outcome;
    }

    @Override
    public int cancel() {
        int outcome = super.cancel();
        TransactionReaper.transactionReaper().remove(this);
        return outcome;
    }

    public final int getTimeout() {
        return this._timeout;
    }

    @Override
    public String type() {
        return "/StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction";
    }

    public boolean addThread() {
        return this.addThread(Thread.currentThread());
    }

    public boolean addThread(Thread t) {
        if (t != null) {
            ThreadActionData.pushAction(this);
            return true;
        }
        return false;
    }

    public boolean removeThread() {
        return this.removeThread(Thread.currentThread());
    }

    public boolean removeThread(Thread t) {
        if (t != null) {
            ThreadActionData.purgeAction(this);
            return true;
        }
        return false;
    }

    public static final AtomicAction suspend() {
        BasicAction curr = ThreadActionData.currentAction();
        if (curr != null) {
            if (curr instanceof AtomicAction) {
                ThreadActionData.purgeActions();
            } else {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.atomicaction_1", new Object[]{curr.toString()});
                }
                curr = null;
            }
        }
        return (AtomicAction)curr;
    }

    public static final boolean resume(AtomicAction act) {
        if (act == null) {
            AtomicAction.suspend();
        } else {
            ThreadActionData.restoreActions(act);
        }
        return true;
    }

    protected AtomicAction(int at) {
        super(at);
    }

    @Override
    protected boolean checkForCurrent() {
        return true;
    }
}

