/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.SingleFunction;
import org.apache.solr.search.function.ValueSource;

public abstract class SimpleFloatFunction
extends SingleFunction {
    public SimpleFloatFunction(ValueSource source) {
        super(source);
    }

    protected abstract float func(int var1, DocValues var2);

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return SimpleFloatFunction.this.func(doc, vals);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return SimpleFloatFunction.this.name() + '(' + vals.toString(doc) + ')';
            }
        };
    }
}

