/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;

class TermOffsetsTokenStream {
    TokenStream bufferedTokenStream = null;
    OffsetAttribute bufferedOffsetAtt;
    AttributeSource.State bufferedToken;
    int bufferedStartOffset;
    int bufferedEndOffset;
    int startOffset;
    int endOffset;

    public TermOffsetsTokenStream(TokenStream tstream) {
        this.bufferedTokenStream = tstream;
        this.bufferedOffsetAtt = (OffsetAttribute)this.bufferedTokenStream.addAttribute(OffsetAttribute.class);
        this.startOffset = 0;
        this.bufferedToken = null;
    }

    public TokenStream getMultiValuedTokenStream(int length) {
        this.endOffset = this.startOffset + length;
        return new MultiValuedStream(length);
    }

    final class MultiValuedStream
    extends TokenStream {
        private final int length;
        OffsetAttribute offsetAtt;

        MultiValuedStream(int length) {
            super(TermOffsetsTokenStream.this.bufferedTokenStream.cloneAttributes());
            this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            this.length = length;
        }

        public boolean incrementToken() throws IOException {
            while (true) {
                if (TermOffsetsTokenStream.this.bufferedToken == null) {
                    if (!TermOffsetsTokenStream.this.bufferedTokenStream.incrementToken()) {
                        return false;
                    }
                    TermOffsetsTokenStream.this.bufferedToken = TermOffsetsTokenStream.this.bufferedTokenStream.captureState();
                    TermOffsetsTokenStream.this.bufferedStartOffset = TermOffsetsTokenStream.this.bufferedOffsetAtt.startOffset();
                    TermOffsetsTokenStream.this.bufferedEndOffset = TermOffsetsTokenStream.this.bufferedOffsetAtt.endOffset();
                }
                if (TermOffsetsTokenStream.this.startOffset <= TermOffsetsTokenStream.this.bufferedStartOffset && TermOffsetsTokenStream.this.bufferedEndOffset <= TermOffsetsTokenStream.this.endOffset) {
                    this.restoreState(TermOffsetsTokenStream.this.bufferedToken);
                    TermOffsetsTokenStream.this.bufferedToken = null;
                    this.offsetAtt.setOffset(this.offsetAtt.startOffset() - TermOffsetsTokenStream.this.startOffset, this.offsetAtt.endOffset() - TermOffsetsTokenStream.this.startOffset);
                    return true;
                }
                if (TermOffsetsTokenStream.this.bufferedEndOffset > TermOffsetsTokenStream.this.endOffset) {
                    TermOffsetsTokenStream.this.startOffset += this.length + 1;
                    return false;
                }
                TermOffsetsTokenStream.this.bufferedToken = null;
            }
        }
    }
}

