/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuiton.util.Version;

public class VersionUtil {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+(?:\\.(?:\\d+))*)(?:-(\\w+?)-(\\d+?)){0,1}$");
    public static final VersionComparator DEFAULT_VERSION_COMPARATOR = new VersionComparator();
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public static Version valueOf(int ... numbers) {
        Version version = VersionUtil.valueOf(null, null, numbers);
        return version;
    }

    public static Version valueOf(String classifier, Integer classifierNumber, int ... numbers) {
        Version v = new Version(classifier, classifierNumber, numbers);
        return v;
    }

    public static Version valueOf(String version) {
        Version v = new Version(version);
        return v;
    }

    public static Version addClassifier(Version version, String classifier, Integer classifierNumber) throws NullPointerException, IllegalArgumentException {
        if (classifier == null) {
            throw new NullPointerException("classifier can not be null");
        }
        if (classifierNumber == null) {
            throw new NullPointerException("classifierNumber can not be null");
        }
        if (version.hasClassifier()) {
            throw new IllegalArgumentException("version " + version + "contains already a classifier ");
        }
        Version result = VersionUtil.valueOf(classifier, classifierNumber, version.getNumbers());
        return result;
    }

    public static Version removeClassifier(Version version) throws IllegalArgumentException {
        if (!version.hasClassifier()) {
            throw new IllegalArgumentException("version " + version + "does no contain a classifier ");
        }
        Version result = VersionUtil.valueOf(version.getNumbers());
        return result;
    }

    public static Version inc(Version v) {
        int nbComponents = v.getNbComponents();
        int[] newNumbers = Arrays.copyOf(v.numbers, nbComponents);
        String newClassifier = v.classifier;
        Integer newClassifierNumber = v.classifierNumber;
        if (v.hasClassifier()) {
            Integer n = newClassifierNumber;
            Integer n2 = newClassifierNumber = Integer.valueOf(newClassifierNumber + 1);
        } else {
            newNumbers[nbComponents - 1] = newNumbers[nbComponents - 1] + 1;
        }
        Version result = VersionUtil.valueOf(newClassifier, newClassifierNumber, newNumbers);
        return result;
    }

    public static String removeSnapshot(String version) throws NullPointerException {
        if (version == null) {
            throw new NullPointerException("version parameter can not be null");
        }
        int index = version.indexOf(SNAPSHOT_SUFFIX);
        if (index > -1) {
            version = version.substring(0, index);
        }
        return version;
    }

    public static List<Version> filterVersions(Set<Version> versions, Version min, Version max, boolean includeMin, boolean includeMax) {
        ArrayList<Version> toApply = new ArrayList<Version>();
        for (Version v : versions) {
            int t;
            if (min != null && ((t = v.compareTo(min)) < 0 || t == 0 && !includeMin) || max != null && ((t = v.compareTo(max)) > 0 || t == 0 && !includeMax)) continue;
            toApply.add(v);
        }
        return toApply;
    }

    public static boolean equals(String version0, String version1) {
        Version v0 = VersionUtil.valueOf(version0);
        Version v1 = VersionUtil.valueOf(version1);
        boolean result = v0.equals(v1);
        return result;
    }

    public static boolean smallerThan(String version0, String version1) {
        Version v0 = VersionUtil.valueOf(version0);
        Version v1 = VersionUtil.valueOf(version1);
        boolean result = v0.before(v1);
        return result;
    }

    public static boolean greaterThan(String version0, String version1) {
        Version v0 = VersionUtil.valueOf(version0);
        Version v1 = VersionUtil.valueOf(version1);
        boolean result = v0.after(v1);
        return result;
    }

    public static void main(String ... args) {
        ArrayList<Version> list = new ArrayList<Version>();
        ArrayList<Version> snapshots = new ArrayList<Version>();
        for (String a : args) {
            if (a.endsWith(SNAPSHOT_SUFFIX)) {
                snapshots.add(VersionUtil.valueOf(a.substring(0, a.length() - SNAPSHOT_SUFFIX.length())));
                continue;
            }
            Version v = VersionUtil.valueOf(a);
            list.add(v);
        }
        Collections.sort(list);
        ArrayList<String> asString = new ArrayList<String>();
        for (Version v : list) {
            asString.add(v.toString());
        }
        for (Version snap : snapshots) {
            int index;
            String v = snap.toString();
            if (list.contains(snap)) {
                index = asString.indexOf(v);
                asString.add(index, v + SNAPSHOT_SUFFIX);
                continue;
            }
            list.add(snap);
            Collections.sort(list);
            index = list.indexOf(snap);
            if (index == 0) {
                asString.add(0, v + SNAPSHOT_SUFFIX);
            } else {
                Version v2 = (Version)list.get(index - 1);
                index = asString.indexOf(v2.toString());
                asString.add(index + 1, v + SNAPSHOT_SUFFIX);
            }
            list.remove(snap);
        }
        StringBuilder buffer = new StringBuilder();
        for (String s : asString) {
            buffer.append(s).append("\n");
        }
        System.out.println(buffer.toString());
    }

    public static class VersionComparator
    implements Comparator<Version> {
        @Override
        public int compare(Version o1, Version o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int result = this.compareNumbers(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareClassifier(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareClassifierNumber(o1, o2);
            return result;
        }

        public int compareNumbers(Version o1, Version o2) {
            int nbComponents1 = o1.numbers.length;
            int nbComponents2 = o2.numbers.length;
            int minlen = Math.min(nbComponents1, nbComponents2);
            for (int i = 0; i < minlen; ++i) {
                int t1 = o1.numbers[i];
                int t2 = o2.numbers[i];
                if (t1 == t2) continue;
                return t1 - t2;
            }
            return nbComponents1 - nbComponents2;
        }

        public int compareClassifier(Version o1, Version o2) {
            if (o1.hasClassifier() && o2.hasClassifier()) {
                return o1.classifier.compareTo(o2.classifier);
            }
            if (!o1.hasClassifier()) {
                return 1;
            }
            if (!o2.hasClassifier()) {
                return -1;
            }
            return 0;
        }

        public int compareClassifierNumber(Version o1, Version o2) {
            return o1.classifierNumber - o2.classifierNumber;
        }
    }
}

