/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils;

import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import gnu.cajo.utils.ItemServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;

public final class Multicast
implements Runnable {
    private Object callback;
    private Thread thread;
    public final InetAddress host;
    public final String address;
    public final int port;
    public InetAddress iaddr;
    public RemoteInvoke item;

    public Multicast() throws UnknownHostException {
        this(null, "224.0.23.162", 1198);
    }

    public Multicast(String string, int n) throws UnknownHostException {
        this(null, string, n);
    }

    public Multicast(String string, String string2, int n) throws UnknownHostException {
        if (string == null) {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        this.host = InetAddress.getByName(string);
        this.address = string2;
        this.port = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce(Object object, int n) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(this.address);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!(object instanceof Remote)) {
            object = new Remote(object);
        }
        try {
            Remote.invoke(object, "startThread", null);
            Remote.invoke(object, "setProxy", new MarshalledObject<Object>(object));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Remote)object).zedmob(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        MulticastSocket multicastSocket = new MulticastSocket();
        try {
            multicastSocket.setInterface(this.host);
            multicastSocket.setTimeToLive(n);
            multicastSocket.send(new DatagramPacket(byArray, byArray.length, inetAddress, this.port));
        }
        finally {
            multicastSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce(Object object, int n, Object object2) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(this.address);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!(object instanceof Remote)) {
            object = new Remote(object);
        }
        try {
            Remote.invoke(object2, "setItem", object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Remote.invoke(object, "startThread", null);
            Remote.invoke(object, "setProxy", new MarshalledObject<Object>(object2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Remote)object).zedmob(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        MulticastSocket multicastSocket = new MulticastSocket();
        try {
            multicastSocket.setInterface(this.host);
            multicastSocket.setTimeToLive(n);
            multicastSocket.send(new DatagramPacket(byArray, byArray.length, inetAddress, this.port));
        }
        finally {
            multicastSocket.close();
        }
    }

    public void listen(Object object) {
        if (this.thread != null) {
            throw new IllegalArgumentException("Already listening");
        }
        this.callback = object;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            MulticastSocket multicastSocket = new MulticastSocket(this.port);
            multicastSocket.setInterface(this.host);
            multicastSocket.joinGroup(InetAddress.getByName(this.address));
            DatagramPacket datagramPacket = new DatagramPacket(new byte[65280], 65280);
            while (!this.thread.isInterrupted()) {
                try {
                    multicastSocket.receive(datagramPacket);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
                    try {
                        this.item = (RemoteInvoke)Remote.zedmob(byteArrayInputStream);
                        this.iaddr = datagramPacket.getAddress();
                        Object object = Remote.invoke(this.callback, "multicast", this);
                        this.item = null;
                        if (object == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        byteArrayInputStream.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            multicastSocket.close();
            multicastSocket = null;
            this.thread = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            stringArray = new String[]{"///main"};
        }
        String string = stringArray.length > 1 ? stringArray[1] : null;
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
        String string2 = stringArray.length > 3 ? stringArray[3] : null;
        int n2 = stringArray.length > 4 ? Integer.parseInt(stringArray[4]) : 0;
        Remote.config(string2, n2, string, n);
        ItemServer.acceptProxies();
        Remote remote = new Remote(Remote.getItem(stringArray[0]));
        if (stringArray.length > 5) {
            Remote.invoke(remote, "setProxy", Remote.getItem(stringArray[5]));
        }
        Multicast multicast = new Multicast();
        multicast.announce(ItemServer.bind(remote, "main"), 16);
        multicast.listen(remote);
    }
}

