/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class AgentAbstract extends BusinessEntityImpl implements Agent {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionAgent;

    private static final long serialVersionUID = 3775765145861841717L;

    @Override
    public String getRefNumber() {
String value = AgentHelper.getRefNumber(getWikitty());
return value;
}

    @Override
    public void setRefNumber(String refNumber) {
String oldValue = getRefNumber();
AgentHelper.setRefNumber(getWikitty(), refNumber);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_REFNUMBER, oldValue, getRefNumber());
}

    @Override
    public String getState() {
String value = AgentHelper.getState(getWikitty());
return value;
}

    @Override
    public void setState(String state) {
String oldValue = getState();
AgentHelper.setState(getWikitty(), state);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_STATE, oldValue, getState());
}

    @Override
    public Date getStateDate() {
Date value = AgentHelper.getStateDate(getWikitty());
return value;
}

    @Override
    public void setStateDate(Date stateDate) {
Date oldValue = getStateDate();
AgentHelper.setStateDate(getWikitty(), stateDate);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_STATEDATE, oldValue, getStateDate());
}

    @Override
    public Boolean getAgent() {
Boolean value = AgentHelper.getAgent(getWikitty());
return value;
}

    @Override
    public void setAgent(Boolean agent) {
Boolean oldValue = getAgent();
AgentHelper.setAgent(getWikitty(), agent);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_AGENT, oldValue, getAgent());
}

    @Override
    public String getJobType() {
String value = AgentHelper.getJobType(getWikitty());
return value;
}

    @Override
    public void setJobType(String jobType) {
String oldValue = getJobType();
AgentHelper.setJobType(getWikitty(), jobType);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_JOBTYPE, oldValue, getJobType());
}

    @Override
    public String getAddress() {
String value = AgentHelper.getAddress(getWikitty());
return value;
}

    @Override
    public void setAddress(String address) {
String oldValue = getAddress();
AgentHelper.setAddress(getWikitty(), address);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_ADDRESS, oldValue, getAddress());
}

    @Override
    public String getJobTypeReference() {
String value = AgentHelper.getJobTypeReference(getWikitty());
return value;
}

    @Override
    public void setJobTypeReference(String jobTypeReference) {
String oldValue = getJobTypeReference();
AgentHelper.setJobTypeReference(getWikitty(), jobTypeReference);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_JOBTYPEREFERENCE, oldValue, getJobTypeReference());
}

    @Override
    public String getPepi() {
String value = AgentHelper.getPepi(getWikitty());
return value;
}

    @Override
    public void setPepi(String pepi) {
String oldValue = getPepi();
AgentHelper.setPepi(getWikitty(), pepi);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_PEPI, oldValue, getPepi());
}

    @Override
    public String getCati() {
String value = AgentHelper.getCati(getWikitty());
return value;
}

    @Override
    public void setCati(String cati) {
String oldValue = getCati();
AgentHelper.setCati(getWikitty(), cati);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_CATI, oldValue, getCati());
}

    @Override
    public String getDepartment() {
String value = AgentHelper.getDepartment(getWikitty());
return value;
}

    @Override
    public void setDepartment(String department) {
String oldValue = getDepartment();
AgentHelper.setDepartment(getWikitty(), department);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_DEPARTMENT, oldValue, getDepartment());
}

    @Override
    public Set<String> getUnit() {
Set<String> result = AgentHelper.getUnit(getWikitty());
return result;
}

    @Override
    public void setUnit(Set<String> unit) {
Set<String> oldValue = getUnit();
AgentHelper.setUnit(getWikitty(), unit);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, oldValue, getUnit());
}

    @Override
    public void addAllUnit(Collection<String> unit) {
Set<String> oldValue = getUnit();
AgentHelper.addAllUnit(getWikitty(), unit);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, oldValue, getUnit());
}

    @Override
    public void addUnit(String... element) {
Set<String> oldValue = getUnit();
AgentHelper.addUnit(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, oldValue, getUnit());
}

    @Override
    public void removeUnit(String... element) {
Set<String> oldValue = getUnit();
AgentHelper.removeUnit(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, oldValue, getUnit());
}

    @Override
    public void clearUnit() {
AgentHelper.clearUnit(getWikitty());
getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, null, getUnit());
}

    @Override
    public String getLogin() {
String value = WikittyUserHelper.getLogin(getWikitty());
return value;
}

    @Override
    public void setLogin(String login) {
String oldValue = getLogin();
WikittyUserHelper.setLogin(getWikitty(), login);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    @Override
    public String getPassword() {
String value = WikittyUserHelper.getPassword(getWikitty());
return value;
}

    @Override
    public void setPassword(String password) {
String oldValue = getPassword();
WikittyUserHelper.setPassword(getWikitty(), password);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    @Override
    public String getLastName() {
String value = UserHelper.getLastName(getWikitty());
return value;
}

    @Override
    public void setLastName(String lastName) {
String oldValue = getLastName();
UserHelper.setLastName(getWikitty(), lastName);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_LASTNAME, oldValue, getLastName());
}

    @Override
    public String getFirstName() {
String value = UserHelper.getFirstName(getWikitty());
return value;
}

    @Override
    public void setFirstName(String firstName) {
String oldValue = getFirstName();
UserHelper.setFirstName(getWikitty(), firstName);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_FIRSTNAME, oldValue, getFirstName());
}

    @Override
    public String getEmail() {
String value = UserHelper.getEmail(getWikitty());
return value;
}

    @Override
    public void setEmail(String email) {
String oldValue = getEmail();
UserHelper.setEmail(getWikitty(), email);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_EMAIL, oldValue, getEmail());
}

    @Override
    public String getComment() {
String value = UserHelper.getComment(getWikitty());
return value;
}

    @Override
    public void setComment(String comment) {
String oldValue = getComment();
UserHelper.setComment(getWikitty(), comment);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_COMMENT, oldValue, getComment());
}

    public AgentAbstract() {
        super();
}

    public AgentAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public AgentAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionAgent = new WikittyExtension(EXT_AGENT,
                "5.0", // version
                WikittyUtil.tagValuesToMap(" version=\"5.0\""), // tag/values
                User.EXT_USER,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String refNumber unique=\"true\"", 
                                             "String state unique=\"true\"", 
                                             "Date stateDate unique=\"true\"", 
                                             "Boolean agent unique=\"true\"", 
                                             "String jobType unique=\"true\"", 
                                             "String address unique=\"true\"", 
                                             "String jobTypeReference unique=\"true\"", 
                                             "String pepi unique=\"true\"", 
                                             "Wikitty cati unique=\"true\"", 
                                             "Wikitty department unique=\"true\"", 
                                             "Wikitty unit[1-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(UserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionAgent);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return AgentHelper.toString(getWikitty());
}

} //AgentAbstract
