/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Menu.java 164 2011-05-13 13:12:11Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/constants/Menu.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.constants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import fr.inra.refcomp.client.RefComp;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 10 nov. 2010
 */
public class Menu extends Composite {

    private static final StorageServiceAsync service = GWT.create(StorageService.class);

    @UiTemplate("Menu.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Menu> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    public Menu() {
        initWidget(binder.createAndBindUi(this));

        service.getAdminEmail(new RefcompCallBack<String>() {
            @Override
            public void onSuccess(String s) {
                contact.setHref("mailto:" + s + "?subject=[Refcomp]Contact");
            }
        });

        refresh();
    }

    @UiField
    static Anchor home;

    @UiField
    static Anchor contact;

    @UiField
    static Anchor login;

    @UiField
    static Anchor logout;

    @UiField
    static Anchor search;

    @UiField
    static Anchor mySkills;

    @UiField
    static Anchor myAccount;

    @UiField
    static Anchor mySheet;

    @UiField
    static Anchor adminSkills;

    @UiField
    static Anchor adminFrequencies;

    @UiField
    static Anchor adminCati;

    @UiField
    static Anchor adminDepartments;

    @UiField
    static Anchor adminUnits;

    @UiField
    static Anchor adminUsers;

    @UiField
    static Anchor printSkills;

    @UiField
    static Anchor adminImportExport;

    @UiField
    static HTMLPanel menuadmin;

    @UiHandler("home")
    static void doClickHome(ClickEvent event) {
        clearMenuStyle();
        home.addStyleName("current");
        History.newItem("home");
    }

    @UiHandler("login")
    public static void doClickLogin(ClickEvent event) {
        clearMenuStyle();
        login.addStyleName("current");
        History.newItem("login");
    }

    @UiHandler("logout")
    public static void doClickLogout(ClickEvent event) {
        doClickHome(event);
        service.logout(new AsyncCallback<Void>() {
            @Override
            public void onFailure(Throwable caught) {
                RefComp.logOut();
            }

            @Override
            public void onSuccess(Void result) {
                RefComp.logOut();
            }
        });
    }

    @UiHandler("search")
    public static void search(ClickEvent event) {
        clearMenuStyle();
        search.addStyleName("current");
        History.newItem("search");
    }

    @UiHandler("mySkills")
    void doClickMySkills(ClickEvent event) {
        clearMenuStyle();
        mySkills.addStyleName("current");
        History.newItem("mySkills");
    }

    @UiHandler("myAccount")
    void doClickMyAccount(ClickEvent event) {
        clearMenuStyle();
        myAccount.addStyleName("current");
        History.newItem("myAccount");
    }

    @UiHandler("mySheet")
    void doClickMySheet(ClickEvent event) {
        clearMenuStyle();
        mySheet.addStyleName("current");
        History.newItem("mySheet");
    }

    @UiHandler("adminFrequencies")
    void doClickAdminFrequencies(ClickEvent event) {
        clearMenuStyle();
        adminFrequencies.addStyleName("current");
        History.newItem("adminFrequencies");
    }

    @UiHandler("adminSkills")
    void doClickAdminSkills(ClickEvent event) {
        clearMenuStyle();
        adminSkills.addStyleName("current");
        History.newItem("adminSkills");
    }

    @UiHandler("adminCati")
    void doClickAdminCati(ClickEvent event) {
        clearMenuStyle();
        adminCati.addStyleName("current");
        History.newItem("adminCati");
    }

    @UiHandler("adminDepartments")
    void doClickAdminDepartments(ClickEvent event) {
        clearMenuStyle();
        adminDepartments.addStyleName("current");
        History.newItem("adminDepartments");
    }

    @UiHandler("adminUnits")
    void doClickAdminUnits(ClickEvent event) {
        clearMenuStyle();
        adminUnits.addStyleName("current");
        History.newItem("adminUnits");
    }

    @UiHandler("adminUsers")
    void doClickAdminUsers(ClickEvent event) {
        clearMenuStyle();
        adminUsers.addStyleName("current");
        History.newItem("adminUsers");
    }

    @UiHandler("printSkills")
    void doClickPrintSkills(ClickEvent event) {
        clearMenuStyle();
        printSkills.addStyleName("current");
        History.newItem("printSkills");
    }

    @UiHandler("adminImportExport")
    void doClickAdminImportExport(ClickEvent event) {
        clearMenuStyle();
        adminImportExport.addStyleName("current");
        History.newItem("import");
    }

    public static void logIn(){
        hide(login);
        show(logout);

        refresh();
    }

    public static void logOut() {
        hide(logout);
        show(login);
        
        refresh();

    }

    protected static void refresh() {
        service.isLoggedIn(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable caught) {
                cleanMenu();
            }

            @Override
            public void onSuccess(Boolean result) {
                cleanMenu();
                if (result) {
                    userMenu();
                    service.isAgent(new AsyncCallback<Boolean>() {
                        @Override
                        public void onFailure(Throwable caught) {
                            cleanMenu();
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                            if (result){
                                agentMenu();
                            }
                        }
                    });

                    service.isAdmin(new AsyncCallback<Boolean>() {
                        @Override
                        public void onFailure(Throwable caught) {
                            cleanMenu();
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                            if (result) {
                                adminMenu();
                            }
                        }
                    });
                }
            }
        });
    }

    protected static void cleanMenu() {
        show(login);
        hide(logout);

        hide(mySkills);
        hide(myAccount);
        hide(mySheet);
        hide(search);
        hide(printSkills);

        hide(adminSkills);
        hide(adminFrequencies);
        hide(adminCati);
        hide(adminDepartments);
        hide(adminUnits);
        hide(adminUsers);
        hide(adminImportExport);
        menuadmin.setVisible(false);
    }

    protected static void adminMenu() {
        menuadmin.setVisible(true);
        show(menuadmin);
        show(adminSkills);
        show(adminFrequencies);
        show(adminCati);
        show(adminDepartments);
        show(adminUnits);
        show(adminUsers);
        show(adminImportExport);
    }

    protected static void agentMenu() {
        userMenu();

        show(mySkills);
        show(mySheet);
    }

    protected static void userMenu() {
        //hide login menu item
        hide(login);
        show(logout);

        show(search);
        show(myAccount);
        show(printSkills);
    }

    public static void clearMenuStyle() {
        adminSkills.removeStyleName("current");
        adminFrequencies.removeStyleName("current");
        adminCati.removeStyleName("current");
        adminDepartments.removeStyleName("current");
        adminImportExport.removeStyleName("current");
        printSkills.removeStyleName("current");
        adminUnits.removeStyleName("current");
        adminUsers.removeStyleName("current");
        myAccount.removeStyleName("current");
        mySheet.removeStyleName("current");
        mySkills.removeStyleName("current");
        login.removeStyleName("current");
        search.removeStyleName("current");
        home.removeStyleName("current");
    }

    public static void adminSkillsCurrent(){
        adminSkills.addStyleName("current");
    }

    public static void adminFrequenciesCurrent(){
        adminFrequencies.addStyleName("current");
    }

    public static void adminCatiCurrent(){
        adminCati.addStyleName("current");
    }

    public static void adminDepartmentsCurrent(){
        adminDepartments.addStyleName("current");
    }

    public static void adminImportExportCurrent(){
        adminImportExport.addStyleName("current");
    }

    public static void adminPrintSkillsCurrent(){
        printSkills.addStyleName("current");
    }

    public static void adminUnitsCurrent(){
        adminUnits.addStyleName("current");
    }

    public static void adminUsersCurrent(){
        adminUsers.addStyleName("current");
    }

    public static void myAccountCurrent(){
        myAccount.addStyleName("current");
    }

    public static void mySkillsCurrent(){
        mySkills.addStyleName("current");
    }

    public static void mySheetCurrent(){
        mySheet.addStyleName("current");
    }

    public static void loginCurrent(){
        login.addStyleName("current");
    }

    public static void homeCurrent(){
        home.addStyleName("current");
    }

    public static void searchCurrent(){
        search.addStyleName("current");
    }

    public static void hide(Widget widget) {
        Element parentElement = widget.getElement().getParentElement();
        parentElement.setClassName("hide");
    }

    public static void show(Widget widget) {
        Element parentElement = widget.getElement().getParentElement();
        parentElement.removeClassName("hide");

    }

}
