/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.constants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import org.nuiton.web.gwt.misc.BlindedPopup;

/**
 * Pop-up to display error messages
 */
public class ErrorPanel  extends Composite {
    @UiTemplate("ErrorPanel.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, ErrorPanel> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    Label message;

    @UiHandler("cancelButton")
    public void cancel(ClickEvent event) {
        ((BlindedPopup) this.getParent()).hide();
    }

    public ErrorPanel(String error) {
        initWidget(binder.createAndBindUi(this));

        this.message.setText(error);
    }
}
