/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AgentSearchResults.java 80 2011-01-28 09:28:55Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/user/AgentSearchResults.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.agent.SkillsTableScreen;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.table.DefaultTableModel;
import fr.inra.refcomp.client.table.FlexTableWithModel;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Unit;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 12/01/11
 */
public class AgentSearchResults extends Composite {

    public static final int NAME_COL = 0;
    public static int DEPARTMENT_COL = 1;
    public static int UNIT_COL = 2;
    public static int CATI_COL = 3;
    public static int COMMENT_COL = 4;

    @UiTemplate("SearchResults.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AgentSearchResults> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    FlexTableWithModel resultsTable;

    @UiField
    InlineLabel searchField;

    @UiField
    Label noResult;

    protected DefaultTableModel model;

    public AgentSearchResults() {
        initWidget(binder.createAndBindUi(this));

        resultsTable.setModel(model);
    }

    public AgentSearchResults(String searchField, EntitiesList results) {
        initWidget(binder.createAndBindUi(this));

        Object[][] data = new Object[][]{};

        RefcompMessages messages = GWT.create(RefcompMessages.class);
        String[] columns = {
                messages.agentName(),
                messages.department(),
                messages.unit(),
                messages.cati(),
                messages.comment()};

        model = new DefaultTableModel(data, columns);

        resultsTable.setModel(model);

        this.searchField.setText(searchField);

        List<BusinessEntity> agents = results.getEntities();

        if (agents.size() > 0) {
            for (int i = 0; i < columns.length; i++) {
                resultsTable.setText(0, i, columns[i]);
            }

            for (BusinessEntity entity : agents) {
                Agent agent = (Agent)entity;
                addRow(agent, results);
            }
        } else {
            resultsTable.setVisible(false);
            noResult.setVisible(true);
        }

    }

    protected void addRow(final Agent agent, EntitiesList dependencies) {
        final int row = model.getRowCount();

        // If the agent is null, it means it is an old
        // damaged data. Do not display it.
        if (agent == null) {
            return;
        }

        //Name with link to the agent skills list
        Anchor nameLink = new Anchor(agent.getFirstName() + " " +
                agent.getLastName());
        nameLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                RootPanel content = RootPanel.get("content");
                content.clear();
                content.add(new SkillsTableScreen(agent.getWikittyId()));
            }
        });
        model.setValueAt(nameLink, row, NAME_COL);

        //Department
        Department department = (Department) dependencies.getDependency(
                agent.getDepartment());
        if (department != null) {
            String text = department.getName();
            String fullName = department.getFullName();
            if (fullName != null && !fullName.isEmpty()) {
                text += " - " + fullName;
            }
            model.setValueAt(text, row, DEPARTMENT_COL);
        }

        //Units
        List<String> units = new ArrayList<String>(agent.getUnit());
        String displayedUnits = "";
        for (String id:units) {
            Unit unit = (Unit) dependencies.getDependency(id);
            String text = unit.getName();
            String fullName = unit.getFullName();
            if (fullName != null && !fullName.isEmpty()) {
                text += " - " + fullName;
            }
            displayedUnits += text +"\n";
        }
        model.setValueAt(displayedUnits, row, UNIT_COL);

        //Cati
        Cati cati = (Cati) dependencies.getDependency(agent.getCati());
        if (cati != null) {
            String text = cati.getName();
            String fullName = cati.getFullName();
            if (fullName != null && !fullName.isEmpty()) {
                text += " - " + fullName;
            }
            model.setValueAt(text, row, CATI_COL);
        }

        //comment
        model.setValueAt(agent.getComment(), row, COMMENT_COL);

    }

}
