/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: FileUpload.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/server/FileUpload.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.server;

import fr.inra.refcomp.services.RefcompSession;
import fr.inra.refcomp.services.ServiceFactory;
import fr.inra.refcomp.services.StorageService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/**
 * Servlet used to upload files for import. Only files submitted through
 * multipart request are processed.
 *
 * User: couteau
 * Date: 17/01/11
 */
public class FileUpload extends HttpServlet {

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        ServletFileUpload upload = new ServletFileUpload();

        InputStream in = null;

        try{
            FileItemIterator iter = upload.getItemIterator(request);

            while (iter.hasNext()) {
                FileItemStream item = iter.next();

                if (item.isFormField()) {
                    //do nothing, process only files
                } else {
                    in = item.openStream();
                    Reader reader = new InputStreamReader(in);

                    //Get the refcompSession object in the user session
                    HttpSession session = request.getSession();
                    // If the session does not contain the session object,
                    // create a new RefcompSession
                    if (session.getAttribute("session") == null) {
                        session.setAttribute("session", new RefcompSession());
                    }
                    RefcompSession refcompSession =
                            (RefcompSession) session.getAttribute("session");

                    StorageService service =
                            ServiceFactory.getStorageService(refcompSession);

                    service.importCSV(reader);
                }
            }
        }
        catch(Exception eee){
            System.out.println("Error : " + eee);
        } finally {
            //Close stream
            if (in != null){
                in.close();
            }
        }

    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        //Get the refcompSession object in the user session
        HttpSession session = request.getSession();
        // If the session does not contain the session object,
        // create a new RefcompSession
        if (session.getAttribute("session") == null) {
            session.setAttribute("session", new RefcompSession());
        }
        RefcompSession refcompSession =
                (RefcompSession) session.getAttribute("session");

        //Prepare the response
        response.setContentType("text/csv;charset=UTF-8");
        PrintWriter out = response.getWriter();

        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {

            String paramName = (String) en.nextElement();
            if (paramName.equals("type")) {
                 String type = request.getParameter(paramName);
                StorageService service =
                        ServiceFactory.getStorageService(refcompSession);
                if ("users".equals(type)) {
                    response.setHeader("Content-disposition",
                            "attachment; filename=users.csv;");
                    service.exportUserBase(out);

                }
                if ("entities".equals(type)) {
                    response.setHeader("Content-disposition",
                            "attachment; filename=entities.csv;");
                    service.exportEntitiesReferentiel(out);
                }
                if ("skills".equals(type)) {
                    response.setHeader("Content-disposition",
                            "attachment; filename=skills.csv;");
                    service.exportSkillsReferentiel(out);
                }
            }

        }

    }

}
