/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.SimpleCursorAdapter;
import android.view.View;
import android.widget.TextView;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Date;
import java.util.Map;

public class WloItemListViewBinder
implements SimpleCursorAdapter.ViewBinder {
    private static final String TAG = "WloItemListViewBinder";
    protected Map<Integer, DataType> dataTypes = Maps.newHashMap();
    protected String dateFormat;
    protected String dateTimeFormat;
    protected Context context;

    public WloItemListViewBinder(Context context) {
        this(context, null);
    }

    public WloItemListViewBinder(Context context, Map<Integer, DataType> dataTypes) {
        this.context = context;
        this.dateFormat = UIUtils.getDateFormat(context);
        this.dateTimeFormat = this.dateFormat + " " + context.getString(2131427376);
        if (dataTypes != null) {
            this.dataTypes = dataTypes;
        }
    }

    public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
        DataType dataType = this.dataTypes.get(columnIndex);
        TextView textView = (TextView)view;
        if (dataType != null) {
            if (cursor.getType(columnIndex) != 0) {
                if (DataType.DATE.equals((Object)dataType) || DataType.DATETIME.equals((Object)dataType)) {
                    long time = cursor.getLong(columnIndex);
                    Date date = new Date(time);
                    String format = DataType.DATE.equals((Object)dataType) ? this.dateFormat : this.dateTimeFormat;
                    String formattedDate = String.format(format, date);
                    textView.setText((CharSequence)formattedDate);
                    return true;
                }
                Context context = view.getContext();
                String id2 = cursor.getString(columnIndex);
                BaseModel ref = null;
                switch (dataType) {
                    case LOCATION: {
                        ref = DataCache.getLocationById(context, id2);
                        break;
                    }
                    case METIER: {
                        ref = DataCache.getMetierById(context, id2);
                        break;
                    }
                    case COMMERCIAL_SPECIES: {
                        ref = DataCache.getCommercialSpeciesById(context, id2);
                        break;
                    }
                    case MENSURATION: {
                        ref = DataCache.getMensurationById(context, id2);
                        break;
                    }
                    case STATE: {
                        ref = DataCache.getStateById(context, id2);
                        break;
                    }
                    case PRESENTATION: {
                        ref = DataCache.getPresentationById(context, id2);
                        break;
                    }
                    case SCIENTIFIC_SPECIES: {
                        ref = DataCache.getScientificSpeciesById(context, id2);
                    }
                }
                textView.setText((CharSequence)(ref != null ? ref.toString(context) : ""));
                return true;
            }
            if (DataType.SCIENTIFIC_SPECIES.equals((Object)dataType) || DataType.METIER.equals((Object)dataType)) {
                textView.setText((CharSequence)this.context.getString(2131427377));
                return true;
            }
        }
        return false;
    }

    public static enum DataType {
        DATE,
        DATETIME,
        LOCATION,
        METIER,
        MENSURATION,
        STATE,
        PRESENTATION,
        COMMERCIAL_SPECIES,
        SCIENTIFIC_SPECIES;

    }
}

