/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.preference.PreferenceManager;
import com.google.common.base.Preconditions;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.preferences.ListItemPreference;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class UIUtils {
    private static final String TAG = "UIUtils";
    public static final SimpleDateFormat UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");

    public static DialogInterface.OnClickListener getCancelClickListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        };
    }

    public static String getStringOrDefault(String s, int defaultId, Context context) {
        if (s != null) {
            return s;
        }
        return context.getString(defaultId);
    }

    public static String getStringOrUndefined(BaseModel model, Context context) {
        String s = model != null ? model.toString(context) : null;
        return UIUtils.getStringOrDefault(s, 2131427377, context);
    }

    public static String getStringOrUndefined(String s, Context context) {
        return UIUtils.getStringOrDefault(s, 2131427377, context);
    }

    public static String getDateOrUndefined(Calendar cal, Context context) {
        if (cal == null) {
            return context.getString(2131427377);
        }
        String dateFormat = UIUtils.getDateFormat(context);
        return String.format(dateFormat, cal);
    }

    public static String getDateFormat(Context context) {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String defaultFormat = context.getResources().getStringArray(ListItemPreference.DATE_FORMAT.getValuesArrayId())[0];
        String dateFormat = sharedPref.getString(ListItemPreference.DATE_FORMAT.getKey(), defaultFormat);
        return dateFormat;
    }

    public static Calendar getCalendarFromCursor(Cursor cursor, int columnIndex) {
        Calendar cal;
        if (cursor.getType(columnIndex) == 0) {
            cal = null;
        } else {
            long time = cursor.getLong(columnIndex);
            cal = Calendar.getInstance();
            cal.setTimeInMillis(time);
        }
        return cal;
    }

    public static String getSizeFormat(Mensuration.Precision precision) {
        String sizeFormat = precision == Mensuration.Precision.MM5 ? "%.1f" : "%.0f";
        return sizeFormat;
    }

    public static String getFormattedSize(int size, Mensuration.Precision precision) {
        Preconditions.checkNotNull((Object)((Object)precision));
        int precisionValue = precision.getValue();
        int roundedSize = size / precisionValue * precisionValue;
        String format = UIUtils.getSizeFormat(precision);
        int divider = precision.getUnitDivider();
        double dSize = (double)roundedSize / (double)divider;
        String result = String.format(Locale.US, format, dSize);
        return result;
    }
}

