/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.storage;

import android.content.Context;
import android.database.Cursor;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ContextModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.CommercialSpecies;
import fr.ifremer.wlo.models.referentials.Location;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.models.referentials.Metier;
import fr.ifremer.wlo.models.referentials.Presentation;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import fr.ifremer.wlo.models.referentials.State;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.nuiton.csv.ValueGetter;
import org.nuiton.csv.ext.AbstractExportModel;

public class CsvExporter
extends AbstractExportModel<MeasurementModel> {
    private static final String TAG = "CsvExporter";
    protected Map<String, QualitativeValueModel> qualitativeValuesById;

    public CsvExporter(char separator, Context context) {
        super(separator);
        WloSqlOpenHelper soh = new WloSqlOpenHelper(context);
        Cursor qualitativeValuesCursor = soh.getAllQualitativeValues();
        List<QualitativeValueModel> qualitativeValues = WloSqlOpenHelper.transformCursorIntoCollection(qualitativeValuesCursor, new Function<Cursor, QualitativeValueModel>(){

            public QualitativeValueModel apply(Cursor input) {
                return new QualitativeValueModel(input);
            }
        });
        this.qualitativeValuesById = Maps.uniqueIndex(qualitativeValues, BaseModel.GET_ID_FUNCTION);
        this.newColumnForExport("contexte_nom", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ContextModel contextModel = object.getParent(ContextModel.class);
                return contextModel.getName();
            }
        });
        this.newColumnForExport("contexte_commentaire", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ContextModel contextModel = object.getParent(ContextModel.class);
                return contextModel.getComment();
            }
        });
        this.newColumnForExport("lieu_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                return locationModel.getLocation().getCode();
            }
        });
        this.newColumnForExport("lieu_libelle", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                return locationModel.getLocation().getLabel();
            }
        });
        this.newColumnForExport("lieu_type", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                return locationModel.getLocation().getTypeLabel();
            }
        });
        this.newColumnForExport("lieu_date_debut", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                Calendar startDate = locationModel.getStartDate();
                return CsvExporter.this.formatDate(startDate);
            }
        });
        this.newColumnForExport("lieu_date_fin", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                Calendar endDate = locationModel.getEndDate();
                return CsvExporter.this.formatDate(endDate);
            }
        });
        this.newColumnForExport("lieu_observateur", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                return locationModel.getOperator();
            }
        });
        this.newColumnForExport("lieu_commentaire", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                LocationModel locationModel = object.getParent(LocationModel.class);
                return locationModel.getComment();
            }
        });
        this.newColumnForExport("navire_immatriculation", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                return vesselModel.getRegistrationNumber();
            }
        });
        this.newColumnForExport("navire_nom", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                return vesselModel.getName();
            }
        });
        this.newColumnForExport("navire_date_debarquement", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                Calendar landingDate = vesselModel.getLandingDate();
                return CsvExporter.this.formatDate(landingDate);
            }
        });
        this.newColumnForExport("navire_lieu_debarquement_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                Location landingLocation = vesselModel.getLandingLocation();
                return landingLocation != null ? landingLocation.getCode() : null;
            }
        });
        this.newColumnForExport("navire_lieu_debarquement_libelle", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                Location landingLocation = vesselModel.getLandingLocation();
                return landingLocation != null ? landingLocation.getLabel() : null;
            }
        });
        this.newColumnForExport("navire_lieu_debarquement_type", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                Location landingLocation = vesselModel.getLandingLocation();
                return landingLocation != null ? landingLocation.getTypeLabel() : null;
            }
        });
        this.newColumnForExport("navire_commentaire", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                VesselModel vesselModel = object.getParent(VesselModel.class);
                return vesselModel.getComment();
            }
        });
        this.newColumnForExport("metier_engin_id", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                MetierModel metierModel = object.getParent(MetierModel.class);
                Metier gearSpecies = metierModel.getGearSpecies();
                return gearSpecies != null ? gearSpecies.getMetierId() : null;
            }
        });
        this.newColumnForExport("metier_engin_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                MetierModel metierModel = object.getParent(MetierModel.class);
                Metier gearSpecies = metierModel.getGearSpecies();
                return gearSpecies != null ? gearSpecies.getCode() : null;
            }
        });
        this.newColumnForExport("metier_engin_libelle", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                MetierModel metierModel = object.getParent(MetierModel.class);
                Metier gearSpecies = metierModel.getGearSpecies();
                return gearSpecies != null ? gearSpecies.getLabel() : null;
            }
        });
        this.newColumnForExport("metier_secteur_peche", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                MetierModel metierModel = object.getParent(MetierModel.class);
                return metierModel.getZone();
            }
        });
        this.newColumnForExport("metier_plan", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                MetierModel metierModel = object.getParent(MetierModel.class);
                return metierModel.getSampleRowCode();
            }
        });
        this.newColumnForExport("metier_commentaire", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                MetierModel metierModel = object.getParent(MetierModel.class);
                return metierModel.getComment();
            }
        });
        this.newColumnForExport("espece_commerciale_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                CommercialSpecies species = commercialSpeciesModel.getFaoCode();
                return species != null ? species.getCode() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_label", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                CommercialSpecies species = commercialSpeciesModel.getFaoCode();
                return species != null ? species.getFrenchLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_methode_mensuration_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                Mensuration measurementMethod = commercialSpeciesModel.getMeasurementMethod();
                return measurementMethod != null ? measurementMethod.getCode() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_methode_mensuration_libelle", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                Mensuration measurementMethod = commercialSpeciesModel.getMeasurementMethod();
                return measurementMethod != null ? measurementMethod.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_precision", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                return commercialSpeciesModel.getPrecision().getLabel();
            }
        });
        this.newColumnForExport("espece_commerciale_melange_especes", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                return String.valueOf(commercialSpeciesModel.isSpeciesMix());
            }
        });
        this.newColumnForExport("espece_commerciale_categorie_tri", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                return commercialSpeciesModel.getSortCategory();
            }
        });
        this.newColumnForExport("espece_commerciale_etat_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                State state = commercialSpeciesModel.getState();
                return state != null ? state.getCode() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_etat_libelle", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                State state = commercialSpeciesModel.getState();
                return state != null ? state.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_presentation_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                Presentation presentation = commercialSpeciesModel.getPresentation();
                return presentation != null ? presentation.getCode() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_presentation_libelle", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                Presentation presentation = commercialSpeciesModel.getPresentation();
                return presentation != null ? presentation.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_categorie1", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                CategoryModel category = commercialSpeciesModel.getCategory1();
                return category != null ? category.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_categorie2", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                CategoryModel category = commercialSpeciesModel.getCategory2();
                return category != null ? category.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_categorie3", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                CategoryModel category = commercialSpeciesModel.getCategory3();
                return category != null ? category.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_poids_total", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                Integer totalUnloadedWeight = commercialSpeciesModel.getTotalUnloadedWeight();
                return totalUnloadedWeight != null ? totalUnloadedWeight.toString() : null;
            }
        });
        this.newColumnForExport("espece_commerciale_commentaire", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                CommercialSpeciesModel commercialSpeciesModel = object.getParent(CommercialSpeciesModel.class);
                return commercialSpeciesModel.getComment();
            }
        });
        this.newColumnForExport("espece_scientifique_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ScientificSpeciesModel speciesModel = (ScientificSpeciesModel)object.getParent();
                ScientificSpecies species = speciesModel.getName();
                return species != null ? species.getCode() : null;
            }
        });
        this.newColumnForExport("espece_scientifique_name", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ScientificSpeciesModel speciesModel = (ScientificSpeciesModel)object.getParent();
                ScientificSpecies species = speciesModel.getName();
                return species != null ? species.getLabel() : null;
            }
        });
        this.newColumnForExport("espece_scientifique_comment", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ScientificSpeciesModel speciesModel = (ScientificSpeciesModel)object.getParent();
                return speciesModel.getComment();
            }
        });
        this.newColumnForExport("espece_scientifique_sorted_weight", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ScientificSpeciesModel speciesModel = (ScientificSpeciesModel)object.getParent();
                Integer sortedWeight = speciesModel.getSortedWeight();
                return sortedWeight != null ? sortedWeight.toString() : null;
            }
        });
        this.newColumnForExport("espece_scientifique_sample_weight", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                ScientificSpeciesModel speciesModel = (ScientificSpeciesModel)object.getParent();
                Integer sampleWeight = speciesModel.getSampleWeight();
                return sampleWeight != null ? sampleWeight.toString() : null;
            }
        });
        this.newColumnForExport("observation_categorie1_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.getCategoryValue(object.getCategory1());
            }
        });
        this.newColumnForExport("observation_categorie1_label", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.getCategoryLabel(object.getCategory1());
            }
        });
        this.newColumnForExport("observation_categorie2_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.getCategoryValue(object.getCategory2());
            }
        });
        this.newColumnForExport("observation_categorie2_label", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.getCategoryLabel(object.getCategory2());
            }
        });
        this.newColumnForExport("observation_categorie3_code", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.getCategoryValue(object.getCategory3());
            }
        });
        this.newColumnForExport("observation_categorie3_label", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.getCategoryLabel(object.getCategory3());
            }
        });
        this.newColumnForExport("observation_categories_poids", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                Triple key;
                ScientificSpeciesModel speciesModel = (ScientificSpeciesModel)object.getParent();
                Map<Triple<String, String, String>, Integer> categoryWeights = speciesModel.getCategoryWeights();
                Integer weight = categoryWeights.get(key = Triple.of((Object)object.getCategory1(), (Object)object.getCategory2(), (Object)object.getCategory3()));
                return weight != null ? weight.toString() : null;
            }
        });
        this.newColumnForExport("observation_date", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return CsvExporter.this.formatDate(object.getDate());
            }
        });
        this.newColumnForExport("observation_taille", (ValueGetter)new ValueGetter<MeasurementModel, String>(){

            public String get(MeasurementModel object) throws Exception {
                return object.getSize().toString();
            }
        });
    }

    protected String getCategoryValue(String measurementCategory) {
        QualitativeValueModel value = this.qualitativeValuesById.get(measurementCategory);
        if (value == null) {
            return measurementCategory;
        }
        return value.getValue();
    }

    protected String getCategoryLabel(String measurementCategory) {
        QualitativeValueModel value = this.qualitativeValuesById.get(measurementCategory);
        if (value == null) {
            return measurementCategory;
        }
        return value.getLabel();
    }

    protected String formatDate(Calendar calendar) {
        return calendar != null ? UIUtils.UTC_DATE_FORMAT.format(calendar.getTime()) : null;
    }
}

