/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.preferences;

import android.content.Context;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public enum ListItemPreference {
    WEIGHT_UNIT("preferences_weight_unit", 2131558401, 2131558400),
    DATE_FORMAT("preferences_date_format", 2131558403, 2131558402),
    USE_PLACE("preferences_use_place", 2131558405, 2131558404);

    private static final String TAG = "ListItemPreference";
    private String key;
    private int entriesArrayId;
    private int valuesArrayId;

    private ListItemPreference(String key, int entriesArrayId, int valuesArrayId) {
        this.key = key;
        this.entriesArrayId = entriesArrayId;
        this.valuesArrayId = valuesArrayId;
    }

    public String getKey() {
        return this.key;
    }

    public int getEntriesArrayId() {
        return this.entriesArrayId;
    }

    public int getValuesArrayId() {
        return this.valuesArrayId;
    }

    public String getEntryForValue(Context context, String value) {
        ArrayList values = Lists.newArrayList((Object[])context.getResources().getStringArray(this.valuesArrayId));
        String[] entries = context.getResources().getStringArray(this.entriesArrayId);
        int index = values.indexOf(value);
        if (index < 0) {
            return null;
        }
        return entries[index];
    }

    public static ListItemPreference getListItemPreference(String key) {
        for (ListItemPreference pref : ListItemPreference.values()) {
            if (!pref.getKey().equals(key)) continue;
            return pref;
        }
        return null;
    }
}

