/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.BaseTextWatcher;
import fr.ifremer.wlo.utils.ImportExportUtil;
import fr.ifremer.wlo.utils.UIUtils;
import fr.ifremer.wlo.utils.filechooser.FileDialog;
import java.util.ArrayList;
import java.util.Collection;

public class CategoryCreationAcivity
extends WloBaseActivity {
    private static final String TAG = "CategoryCreationAcivity";
    protected static final int REQUEST_IMPORT_QUALITATIVE_VALUES = 0;
    protected CategoryModel model = new CategoryModel();

    @Override
    protected Integer getContentView() {
        return 2130903064;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EditText labelEditor = (EditText)this.findViewById(2131099710);
        labelEditor.addTextChangedListener((TextWatcher)new BaseTextWatcher(){

            @Override
            public void afterTextChanged(Editable s) {
                CategoryCreationAcivity.this.model.setLabel(String.valueOf(s));
            }
        });
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return null;
    }

    public void validate(View source) {
        WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)this);
        soh.saveData(this.model);
        if (this.model.getQualitativeValues() != null) {
            soh.saveData(this.model.getQualitativeValues());
        }
        DataCache.addCategory(this.model);
        this.setResult(-1);
        this.finish();
    }

    public void importQualitativeValues(View source) {
        Intent intent = new Intent((Context)this, FileDialog.class);
        intent.putExtra("START_PATH", "/sdcard");
        intent.putExtra("CAN_SELECT_DIR", false);
        intent.putExtra("SELECTION_MODE", 1);
        intent.putExtra("FORMAT_FILTER", new String[]{"csv"});
        this.startActivityForResult(intent, 0);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1) {
            String path = data.getStringExtra("RESULT_PATH");
            try {
                Collection<QualitativeValueModel> qualitativeValueModels = ImportExportUtil.importQualitativeValues(this.model, path);
                this.model.setQualitativeValues(new ArrayList<QualitativeValueModel>(qualitativeValueModels));
                TextView textView = (TextView)this.findViewById(2131099712);
                textView.setText((CharSequence)this.getString(2131427452, new Object[]{qualitativeValueModels.size()}));
                textView.setVisibility(0);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"error during import", (Throwable)e);
                new AlertDialog.Builder((Context)this).setMessage(2131427532).setNeutralButton(17039370, UIUtils.getCancelClickListener()).create().show();
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }
}

