/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models.referentials;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.referentials.HasCode;
import fr.ifremer.wlo.utils.UIUtils;

public class Location
extends BaseModel
implements HasCode {
    private static final String TAG = "Locations";
    public static final String TABLE_NAME = "ref_location";
    public static final String COLUMN_TYPE_LABEL = "typeLabel";
    public static final String COLUMN_CODE = "code";
    public static final String COLUMN_LABEL = "label";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "typeLabel", "code", "label"};
    protected String typeLabel;
    protected String code;
    protected String label;

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public Location() {
    }

    public Location(Cursor cursor) {
        super(cursor);
        this.typeLabel = cursor.getString(1);
        this.code = cursor.getString(2);
        this.label = cursor.getString(3);
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.code + " - " + this.label + " (" + this.typeLabel + ")";
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.code, context) + " - " + UIUtils.getStringOrUndefined(this.label, context) + " (" + UIUtils.getStringOrUndefined(this.typeLabel, context) + ")";
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_TYPE_LABEL, this.typeLabel);
        this.putValue(value, COLUMN_CODE, this.code);
        this.putValue(value, COLUMN_LABEL, this.label);
        return value;
    }
}

