/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.google.common.collect.Sets;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.referentials.Location;
import fr.ifremer.wlo.models.referentials.Vessel;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class VesselModel
extends HierarchicalModel<LocationModel> {
    private static final String TAG = "Vessel";
    public static final String TABLE_NAME = "vessels";
    public static final String COLUMN_REGISTRATION_NUMBER = "registrationNumber";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_LANDING_DATE = "landingDate";
    public static final String COLUMN_LANDING_LOCATION = "landingLocation";
    public static final String COLUMN_COMMENT = "comment";
    public static final String COLUMN_LOCATION_ID = "location_id";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "registrationNumber", "name", "landingDate", "landingLocation", "comment", "location_id"};
    protected String registrationNumber;
    protected String name;
    protected Calendar landingDate;
    protected Location landingLocation;
    protected String comment;

    public VesselModel() {
    }

    public VesselModel(Context context, Cursor cursor) {
        super(cursor);
        this.registrationNumber = cursor.getString(1);
        this.name = cursor.getString(2);
        this.landingDate = UIUtils.getCalendarFromCursor(cursor, 3);
        String landingLocationId = cursor.getString(4);
        this.landingLocation = DataCache.getLocationById(context, landingLocationId);
        this.comment = cursor.getString(5);
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        String oldValue = this.registrationNumber;
        this.registrationNumber = registrationNumber;
        this.firePropertyChange(COLUMN_REGISTRATION_NUMBER, oldValue, registrationNumber);
    }

    public void setRegistrationNumber(Vessel vessel) {
        if (vessel != null) {
            this.setRegistrationNumber(vessel.getCode());
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                this.setName(vessel.getName());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(COLUMN_NAME, oldValue, name);
    }

    public Calendar getLandingDate() {
        return this.landingDate;
    }

    public void setLandingDate(Calendar landingDate) {
        Calendar oldValue = this.landingDate;
        this.landingDate = landingDate;
        this.firePropertyChange(COLUMN_LANDING_DATE, oldValue, landingDate);
    }

    public Location getLandingLocation() {
        return this.landingLocation;
    }

    public void setLandingLocation(Location landingLocation) {
        Location oldValue = this.landingLocation;
        this.landingLocation = landingLocation;
        this.firePropertyChange(COLUMN_LANDING_LOCATION, oldValue, landingLocation);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(COLUMN_COMMENT, oldValue, comment);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.registrationNumber, context) + " - " + UIUtils.getStringOrUndefined(this.name, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_REGISTRATION_NUMBER, this.registrationNumber);
        this.putValue(value, COLUMN_NAME, this.name);
        this.putValue(value, COLUMN_LANDING_DATE, this.landingDate != null ? Long.valueOf(this.landingDate.getTimeInMillis()) : null);
        this.putValue(value, COLUMN_LANDING_LOCATION, this.landingLocation != null ? this.landingLocation.getId() : null);
        this.putValue(value, COLUMN_COMMENT, this.comment);
        this.putValue(value, COLUMN_LOCATION_ID, this.getParentId());
        return value;
    }

    @Override
    public Set<Set<String>> getOneRequiredFields() {
        Set<Set<String>> result = super.getOneRequiredFields();
        HashSet oneRequired = Sets.newHashSet((Object[])new String[]{COLUMN_REGISTRATION_NUMBER, COLUMN_NAME});
        result.add(oneRequired);
        return result;
    }
}

