/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.provider.BaseColumns;
import android.util.Log;
import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseModel
implements Serializable,
BaseColumns {
    private static final String TAG = "BaseModel";
    public static final Function<BaseModel, String> GET_ID_FUNCTION = new Function<BaseModel, String>(){

        public String apply(BaseModel input) {
            return input.getId();
        }
    };
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected String id;
    protected boolean modified;

    public BaseModel() {
    }

    public BaseModel(Cursor cursor) {
        this.id = cursor.getString(0);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        String oldValue = this.id;
        this.id = id2;
        this.firePropertyChange("_id", oldValue, id2);
    }

    public boolean isNew() {
        return StringUtils.isBlank((CharSequence)this.id);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public abstract String getTableName();

    public String toString(Context context) {
        return this.toString();
    }

    public ContentValues convertIntoContentValues() {
        ContentValues value = new ContentValues();
        value.put("_id", this.id);
        return value;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(property, listener);
    }

    public void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (ObjectUtils.notEqual((Object)oldValue, (Object)newValue)) {
            this.changeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    public Set<String> getRequiredFields() {
        return Sets.newHashSet();
    }

    public Set<Set<String>> getOneRequiredFields() {
        return Sets.newHashSet();
    }

    public Multimap<ErrorType, String> checkValidity() {
        HashMultimap result = HashMultimap.create();
        for (String string2 : this.getRequiredFields()) {
            try {
                if (this.getClass().getDeclaredField(string2).get(this) != null) continue;
                result.put((Object)ErrorType.REQUIRED, (Object)string2);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error while accessing the field " + string2), (Throwable)e);
            }
        }
        for (Set set : this.getOneRequiredFields()) {
            boolean notNull = false;
            for (String oneRequiredField : set) {
                try {
                    if (this.getClass().getDeclaredField(oneRequiredField).get(this) == null) continue;
                    notNull = true;
                    break;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Error while accessing the field " + oneRequiredField), (Throwable)e);
                }
            }
            if (notNull) continue;
            result.putAll((Object)ErrorType.ONE_REQUIRED, (Iterable)set);
        }
        return result;
    }

    protected void putValue(ContentValues values, String column, String value) {
        if (value == null) {
            values.putNull(column);
        } else {
            values.put(column, value);
        }
    }

    protected void putValue(ContentValues values, String column, Long value) {
        if (value == null) {
            values.putNull(column);
        } else {
            values.put(column, value);
        }
    }

    protected void putValue(ContentValues values, String column, Integer value) {
        if (value == null) {
            values.putNull(column);
        } else {
            values.put(column, value);
        }
    }

    protected void putValue(ContentValues values, String column, Float value) {
        if (value == null) {
            values.putNull(column);
        } else {
            values.put(column, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseModel baseModel = (BaseModel)o;
        if (this.id != null) {
            return this.id.equals(baseModel.id);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public static enum ErrorType {
        REQUIRED,
        ONE_REQUIRED;

    }
}

