/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.measurement;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.media.ToneGenerator;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Vibrator;
import android.speech.tts.TextToSpeech;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v4.widget.DrawerLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TabHost;
import android.widget.TextView;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.CommercialSpeciesActivity;
import fr.ifremer.wlo.CommercialSpeciesFormActivity;
import fr.ifremer.wlo.MainActivity;
import fr.ifremer.wlo.MetierFormActivity;
import fr.ifremer.wlo.MetiersActivity;
import fr.ifremer.wlo.ScientificSpeciesActivity;
import fr.ifremer.wlo.ScientificSpeciesFormActivity;
import fr.ifremer.wlo.VesselFormActivity;
import fr.ifremer.wlo.VesselsActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.measurement.MeasurementsDisplayerFragment;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.CategoryWeightModel;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MeasurementsModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.CalcifiedPartTaking;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.BaseTextWatcher;
import fr.ifremer.wlo.utils.BigFinFeedReaderRecord;
import fr.ifremer.wlo.utils.UIUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;

public class MeasurementActivity
extends WloBaseActivity
implements AdapterView.OnItemSelectedListener,
TextToSpeech.OnInitListener {
    private static final String TAG = "MeasurementActivity";
    public static final String INTENT_EXTRA_MEASUREMENTS = "measurements";
    public static final String INTENT_EXTRA_SCIENTIFIC_SPECIES = "scientificSpecies";
    protected static final String GRAPH_TAB = "graph";
    protected static final String TABLE_TAB = "table";
    protected static final String LOGS_TAB = "logs";
    protected static final int CHECK_TTS_REQUEST_CODE = 42;
    protected WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)this);
    protected TabHost tabs;
    protected EditText sizeText;
    protected ActionBarDrawerToggle mDrawerToggle;
    protected TextView observedNumberText;
    protected Button validateButton;
    protected MeasurementModel measurement;
    protected MeasurementsModel measurements;
    protected ScientificSpeciesModel scientificSpecies;
    protected CommercialSpeciesModel commercialSpecies;
    protected MetierModel metier;
    protected VesselModel vessel;
    protected LocationModel location;
    protected ListView mDrawerList;
    protected TextToSpeech textToSpeech;
    protected boolean useTextToSpeech = false;

    @Override
    protected Integer getContentView() {
        return 2130903077;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return ScientificSpeciesActivity.class;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.measurements = (MeasurementsModel)this.getIntent().getSerializableExtra(INTENT_EXTRA_MEASUREMENTS);
        if (this.measurements != null) {
            this.scientificSpecies = this.measurements.getScientificSpecies();
        } else {
            this.scientificSpecies = (ScientificSpeciesModel)this.getIntent().getSerializableExtra(INTENT_EXTRA_SCIENTIFIC_SPECIES);
            this.measurements = new MeasurementsModel();
            this.measurements.setScientificSpecies(this.scientificSpecies);
            Cursor cursor = this.soh.getAllMeasurements(this.scientificSpecies.getId());
            List<MeasurementModel> measurementList = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, MeasurementModel>(){

                public MeasurementModel apply(Cursor cursor) {
                    return new MeasurementModel(cursor);
                }
            });
            for (MeasurementModel measurement : measurementList) {
                this.measurements.addMeasurement(measurement);
            }
        }
        this.fetchCalcifiedPartTakings();
        this.measurements.addMeasurementsListener(new MeasurementsModel.MeasurementsListener(){

            @Override
            public void onMeasurementAdded(MeasurementsModel source, MeasurementModel measurement) {
                int size = source.getMeasurements().size();
                MeasurementActivity.this.observedNumberText.setText((CharSequence)String.valueOf(size));
            }

            @Override
            public void onMeasurementRemoved(MeasurementsModel source, MeasurementModel measurement) {
                MeasurementActivity.this.soh.deleteMeasurement(measurement);
                int size = source.getMeasurements().size();
                MeasurementActivity.this.observedNumberText.setText((CharSequence)String.valueOf(size));
            }
        });
        this.commercialSpecies = (CommercialSpeciesModel)this.scientificSpecies.getParent();
        this.measurements.setPrecision(this.commercialSpecies.getPrecision());
        this.metier = (MetierModel)this.commercialSpecies.getParent();
        this.vessel = (VesselModel)this.metier.getParent();
        this.location = (LocationModel)this.vessel.getParent();
        this.tabs = (TabHost)this.findViewById(0x1020012);
        this.tabs.setup();
        this.setupTab(2131099773, GRAPH_TAB, 2131427364);
        this.setupTab(2131099774, TABLE_TAB, 2131427365);
        this.setupTab(2131099775, LOGS_TAB, 2131427366);
        this.validateButton = (Button)this.findViewById(2131099771);
        this.initSizeText();
        this.observedNumberText = (TextView)this.findViewById(2131099776);
        this.observedNumberText.setText((CharSequence)String.valueOf(this.measurements.getMeasurements().size()));
        this.initCategories();
        this.initFishMeasurement(10 * this.measurements.getPrecision().getUnitDivider(), null, null, null);
        this.initDrawer();
        this.initActionBar();
        this.mMessenger = new Messenger(new Handler(){

            public void handleMessage(Message msg) {
                if (!MeasurementActivity.this.isFinishing()) {
                    switch (msg.what) {
                        case 2: {
                            BigFinFeedReaderRecord record = (BigFinFeedReaderRecord)msg.obj;
                            if (record == null || record.getLength() == null) break;
                            int size = (int)Math.floor(record.getLength().floatValue());
                            MeasurementActivity.this.measurement.setSize(size);
                            MeasurementModel savedMeasurement = MeasurementActivity.this.addMeasurement();
                            if (MeasurementActivity.this.useTextToSpeech) {
                                String formattedSize = UIUtils.getFormattedSize(savedMeasurement.getSize(), MeasurementActivity.this.measurements.getPrecision());
                                MeasurementActivity.this.textToSpeech.speak(formattedSize, 1, null);
                            } else {
                                ToneGenerator tg = new ToneGenerator(5, 100);
                                tg.startTone(24);
                            }
                            Vibrator v = (Vibrator)MeasurementActivity.this.getSystemService("vibrator");
                            v.vibrate(300L);
                        }
                    }
                }
            }
        });
        Intent checkIntent = new Intent();
        checkIntent.setAction("android.speech.tts.engine.CHECK_TTS_DATA");
        this.startActivityForResult(checkIntent, 42);
    }

    protected void initActionBar() {
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setHomeButtonEnabled(true);
        actionBar.setTitle((CharSequence)(this.commercialSpecies.toString((Context)this) + " / " + this.scientificSpecies.toString((Context)this) + " / " + this.commercialSpecies.getMeasurementMethod().toString((Context)this) + " / " + (Object)((Object)this.commercialSpecies.getPrecision())));
        actionBar.setSubtitle((CharSequence)(this.vessel.toString((Context)this) + " / " + this.metier.toString((Context)this)));
    }

    protected void initDrawer() {
        DrawerLayout mDrawerLayout = (DrawerLayout)this.findViewById(2131099759);
        this.mDrawerList = (ListView)this.findViewById(2131099777);
        this.setDrawerListAdapter();
        this.mDrawerList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView parent, View view, int position, long id2) {
                MeasurementActivity.this.selectItem(position);
            }
        });
        this.mDrawerList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                MeasurementActivity.this.editItem(position);
                return true;
            }
        });
        this.mDrawerToggle = new ActionBarDrawerToggle((Activity)this, mDrawerLayout, 2130837597, 2131427361, 2131427362);
        mDrawerLayout.setDrawerListener((DrawerLayout.DrawerListener)this.mDrawerToggle);
    }

    protected void initSizeText() {
        this.sizeText = (EditText)this.findViewById(2131099770);
        int inputType = 2;
        if (this.measurements.getPrecision().isDecimal()) {
            inputType |= 0x2000;
        }
        this.sizeText.setRawInputType(inputType);
        this.sizeText.addTextChangedListener((TextWatcher)new BaseTextWatcher(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                MeasurementActivity.this.sizeText.setSelection(start + count);
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (s.toString().isEmpty()) {
                    MeasurementActivity.this.measurement.setSize(null);
                } else {
                    Mensuration.Precision precision = MeasurementActivity.this.measurements.getPrecision();
                    int multiplier = precision.getUnitDivider();
                    try {
                        NumberFormat format = NumberFormat.getInstance(Locale.US);
                        Number number = format.parse(s.toString());
                        double d = number.doubleValue();
                        int size = (int)(d * (double)multiplier);
                        MeasurementActivity.this.measurement.setSize(size);
                    }
                    catch (ParseException e) {
                        Log.e((String)MeasurementActivity.TAG, (String)("ParseException " + e.getMessage()));
                        MeasurementActivity.this.measurement.setSize(null);
                    }
                }
            }
        });
    }

    protected void initCategories() {
        CategoryModel category1 = this.commercialSpecies.getCategory1();
        TextView category1Label = (TextView)this.findViewById(2131099761);
        LinearLayout category1Editors = (LinearLayout)this.findViewById(2131099762);
        Spinner category1Spinner = (Spinner)this.findViewById(2131099720);
        EditText category1Text = (EditText)this.findViewById(2131099763);
        this.initCategoryInput(category1, category1Label, category1Editors, category1Spinner, category1Text);
        CategoryModel category2 = this.commercialSpecies.getCategory2();
        TextView category2Label = (TextView)this.findViewById(2131099764);
        LinearLayout category2Editors = (LinearLayout)this.findViewById(2131099765);
        Spinner category2Spinner = (Spinner)this.findViewById(2131099721);
        EditText category2Text = (EditText)this.findViewById(2131099766);
        this.initCategoryInput(category2, category2Label, category2Editors, category2Spinner, category2Text);
        CategoryModel category3 = this.commercialSpecies.getCategory3();
        TextView category3Label = (TextView)this.findViewById(2131099767);
        LinearLayout category3Editors = (LinearLayout)this.findViewById(2131099768);
        Spinner category3Spinner = (Spinner)this.findViewById(2131099722);
        EditText category3Text = (EditText)this.findViewById(2131099769);
        this.initCategoryInput(category3, category3Label, category3Editors, category3Spinner, category3Text);
    }

    protected void initCategoryInput(CategoryModel category, TextView categoryLabel, LinearLayout categoryEditorPanel, Spinner categorySpinner, final EditText categoryText) {
        if (category == null) {
            categoryLabel.setVisibility(4);
            categoryEditorPanel.setVisibility(4);
        } else {
            categoryLabel.setText((CharSequence)category.getLabel());
            ArrayList values = Lists.newArrayList(category.getQualitativeValues());
            if (values.isEmpty()) {
                categorySpinner.setVisibility(8);
                categoryText.addTextChangedListener((TextWatcher)new BaseTextWatcher(){

                    @Override
                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                        categoryText.setSelection(start + count);
                    }

                    @Override
                    public void afterTextChanged(Editable s) {
                        switch (categoryText.getId()) {
                            case 2131099763: {
                                MeasurementActivity.this.measurement.setCategory1(String.valueOf(s));
                                break;
                            }
                            case 2131099766: {
                                MeasurementActivity.this.measurement.setCategory2(String.valueOf(s));
                                break;
                            }
                            case 2131099769: {
                                MeasurementActivity.this.measurement.setCategory3(String.valueOf(s));
                            }
                        }
                    }
                });
            } else {
                categoryText.setVisibility(8);
                categorySpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
                this.measurements.addCategoryValues(values);
                ArrayAdapter adapter = new ArrayAdapter((Context)this, 0x1090009, (List)values);
                categorySpinner.setAdapter((SpinnerAdapter)adapter);
            }
        }
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.mDrawerToggle.syncState();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 42 && resultCode == 1) {
            this.textToSpeech = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
            if (this.textToSpeech.isLanguageAvailable(Locale.FRANCE) == 1) {
                this.textToSpeech.setLanguage(Locale.FRANCE);
            }
        } else if (resultCode == -1) {
            switch (requestCode) {
                case 1: {
                    this.vessel = (VesselModel)data.getSerializableExtra("model");
                    break;
                }
                case 2: {
                    this.metier = (MetierModel)data.getSerializableExtra("model");
                    break;
                }
                case 3: {
                    this.commercialSpecies = (CommercialSpeciesModel)data.getSerializableExtra("model");
                    this.measurements.setPrecision(this.commercialSpecies.getPrecision());
                    this.initCategories();
                    break;
                }
                case 4: {
                    this.scientificSpecies = (ScientificSpeciesModel)data.getSerializableExtra("model");
                    this.fetchCalcifiedPartTakings();
                }
            }
            this.setDrawerListAdapter();
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDrawerToggle.onConfigurationChanged(newConfig);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.mDrawerToggle.onOptionsItemSelected(item)) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.soh.close();
        this.textToSpeech.shutdown();
    }

    public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
        BaseModel selected = (BaseModel)adapterView.getItemAtPosition(i);
        String id2 = selected != null ? selected.getId() : null;
        switch (adapterView.getId()) {
            case 2131099720: {
                this.measurement.setCategory1(id2);
                break;
            }
            case 2131099721: {
                this.measurement.setCategory2(id2);
                break;
            }
            case 2131099722: {
                this.measurement.setCategory3(id2);
            }
        }
    }

    public void onNothingSelected(AdapterView<?> adapterView) {
        switch (adapterView.getId()) {
            case 2131099720: {
                this.measurement.setCategory1(null);
                break;
            }
            case 2131099721: {
                this.measurement.setCategory2(null);
                break;
            }
            case 2131099722: {
                this.measurement.setCategory3(null);
            }
        }
    }

    public void onInit(int status) {
        this.useTextToSpeech = status == 0;
    }

    public void incSize(View source) {
        this.measurement.incSize(this.measurements.getPrecision().getValue());
    }

    public void decSize(View source) {
        this.measurement.decSize(this.measurements.getPrecision().getValue());
    }

    public void addMeasurement(View source) {
        this.addMeasurement();
    }

    protected MeasurementModel addMeasurement() {
        this.measurement.setDate(Calendar.getInstance());
        this.measurement.roundSize(this.measurements.getPrecision());
        Integer size = this.measurement.getSize();
        String cat1 = this.measurement.getCategory1();
        String cat2 = this.measurement.getCategory2();
        String cat3 = this.measurement.getCategory3();
        Cursor categoryWeightModelCursor = this.soh.getCategoryWeight(this.scientificSpecies.getId(), cat1, cat2, cat3);
        if (categoryWeightModelCursor.getCount() == 0) {
            CategoryWeightModel categoryWeightModel = new CategoryWeightModel();
            categoryWeightModel.setCategory1(cat1);
            categoryWeightModel.setCategory2(cat2);
            categoryWeightModel.setCategory3(cat3);
            categoryWeightModel.setParent(this.scientificSpecies);
            this.soh.saveData(categoryWeightModel);
        }
        this.soh.saveData(this.measurement);
        boolean take = this.measurements.addMeasurement(this.measurement);
        if (take) {
            if (this.useTextToSpeech) {
                this.textToSpeech.speak(this.getString(2131427380), 0, null);
            } else {
                ToneGenerator tg = new ToneGenerator(5, 100);
                tg.startTone(27);
            }
            Vibrator v = (Vibrator)this.getSystemService("vibrator");
            v.vibrate(300L);
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setMessage(2131427379).setPositiveButton(17039370, UIUtils.getCancelClickListener()).create().show();
        }
        MeasurementModel result = this.measurement;
        this.initFishMeasurement(size, cat1, cat2, cat3);
        return result;
    }

    protected void initFishMeasurement(Integer size, String cat1, String cat2, String cat3) {
        this.measurement = new MeasurementModel();
        this.measurement.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getPropertyName();
                Object newValue = event.getNewValue();
                switch (propertyName) {
                    case "size": {
                        String text = null;
                        if (newValue != null) {
                            text = UIUtils.getFormattedSize((Integer)newValue, MeasurementActivity.this.measurements.getPrecision());
                            MeasurementActivity.this.validateButton.setEnabled(true);
                        } else {
                            MeasurementActivity.this.validateButton.setEnabled(false);
                        }
                        MeasurementActivity.this.sizeText.setText((CharSequence)text);
                        break;
                    }
                    case "category1": {
                        CategoryModel category = MeasurementActivity.this.commercialSpecies.getCategory1();
                        Spinner spinner = (Spinner)MeasurementActivity.this.findViewById(2131099720);
                        MeasurementActivity.this.setCategorySpinnerSelection(newValue, category, spinner);
                        EditText editText = (EditText)MeasurementActivity.this.findViewById(2131099763);
                        editText.setText((CharSequence)String.valueOf(newValue));
                        break;
                    }
                    case "category2": {
                        CategoryModel category = MeasurementActivity.this.commercialSpecies.getCategory2();
                        Spinner spinner = (Spinner)MeasurementActivity.this.findViewById(2131099721);
                        MeasurementActivity.this.setCategorySpinnerSelection(newValue, category, spinner);
                        EditText editText = (EditText)MeasurementActivity.this.findViewById(2131099766);
                        editText.setText((CharSequence)String.valueOf(newValue));
                        break;
                    }
                    case "category3": {
                        CategoryModel category = MeasurementActivity.this.commercialSpecies.getCategory3();
                        Spinner spinner = (Spinner)MeasurementActivity.this.findViewById(2131099722);
                        MeasurementActivity.this.setCategorySpinnerSelection(newValue, category, spinner);
                        EditText editText = (EditText)MeasurementActivity.this.findViewById(2131099769);
                        editText.setText((CharSequence)String.valueOf(newValue));
                    }
                }
            }
        });
        this.measurement.setSize(size);
        this.measurement.setCategory1(cat1);
        this.measurement.setCategory2(cat2);
        this.measurement.setCategory3(cat3);
        this.measurement.setParent(this.scientificSpecies);
    }

    protected void setCategorySpinnerSelection(Object newValue, CategoryModel category, Spinner spinner) {
        List<QualitativeValueModel> qualitativeValues = category.getQualitativeValues();
        if (category != null && CollectionUtils.isNotEmpty(qualitativeValues)) {
            ArrayAdapter adapter = (ArrayAdapter)spinner.getAdapter();
            QualitativeValueModel value = null;
            if (newValue != null) {
                value = this.measurements.getCategoryValuesById(newValue.toString());
            }
            int position = adapter.getPosition(value);
            spinner.setSelection(position);
        }
    }

    protected void setupTab(int contentId, String tag, int label) {
        View tabview = LayoutInflater.from((Context)this).inflate(2130903088, null);
        TextView tv = (TextView)tabview.findViewById(2131099795);
        tv.setText(label);
        TabHost.TabSpec content = this.tabs.newTabSpec(tag).setIndicator(tabview).setContent(contentId);
        this.tabs.addTab(content);
        MeasurementsDisplayerFragment fragment = (MeasurementsDisplayerFragment)this.getFragmentManager().findFragmentById(contentId);
        fragment.setMeasurements(this.measurements);
    }

    protected void setDrawerListAdapter() {
        this.mDrawerList.setAdapter((ListAdapter)new ArrayAdapter((Context)this, 17367043, (Object[])new String[]{this.getString(2131427363), this.vessel.toString((Context)this), this.metier.toString((Context)this), this.commercialSpecies.toString((Context)this), this.scientificSpecies.toString((Context)this)}));
    }

    protected void fetchCalcifiedPartTakings() {
        if (this.scientificSpecies.isTakingActivation()) {
            WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)this);
            Cursor cursor = soh.getAllCalcifiedPartTakings(this.scientificSpecies.getName().getId());
            List<CalcifiedPartTaking> calcifiedPartTakings = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, CalcifiedPartTaking>(){

                public CalcifiedPartTaking apply(Cursor input) {
                    return new CalcifiedPartTaking(input);
                }
            });
            soh.close();
            this.measurements.setCalcifiedPartTakings(calcifiedPartTakings);
        }
    }

    protected void editItem(int position) {
        HierarchicalModel modelToEdit;
        Class clazz;
        switch (position) {
            case 0: {
                clazz = MainActivity.class;
                modelToEdit = null;
                break;
            }
            case 1: {
                clazz = VesselFormActivity.class;
                modelToEdit = this.vessel;
                break;
            }
            case 2: {
                clazz = MetierFormActivity.class;
                modelToEdit = this.metier;
                break;
            }
            case 3: {
                clazz = CommercialSpeciesFormActivity.class;
                modelToEdit = this.commercialSpecies;
                break;
            }
            case 4: {
                clazz = ScientificSpeciesFormActivity.class;
                modelToEdit = this.scientificSpecies;
                break;
            }
            default: {
                clazz = null;
                modelToEdit = null;
            }
        }
        if (clazz != null) {
            Intent intent = new Intent((Context)this, clazz);
            intent.putExtra("model", (Serializable)modelToEdit);
            this.startActivityForResult(intent, position);
        }
    }

    protected void selectItem(int position) {
        Class activityClass;
        HierarchicalModel parentModel = null;
        switch (position) {
            case 0: {
                activityClass = MainActivity.class;
                break;
            }
            case 1: {
                activityClass = VesselsActivity.class;
                parentModel = this.location;
                break;
            }
            case 2: {
                activityClass = MetiersActivity.class;
                parentModel = this.vessel;
                break;
            }
            case 3: {
                activityClass = CommercialSpeciesActivity.class;
                parentModel = this.metier;
                break;
            }
            case 4: {
                activityClass = ScientificSpeciesActivity.class;
                parentModel = this.commercialSpecies;
                break;
            }
            default: {
                activityClass = null;
            }
        }
        if (activityClass != null) {
            Intent intent = new Intent((Context)this, activityClass);
            intent.putExtra("parentModel", (Serializable)parentModel);
            this.startActivity(intent);
        }
    }
}

