/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.graphics.Typeface;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.ScientificSpeciesActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.CategoryWeightModel;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.preferences.ListItemPreference;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.BaseTextWatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WeightsActivity
extends WloBaseActivity {
    private static final String TAG = "WeightsActivity";
    public static final String INTENT_COMMERCIAL_SPECIES = "commercialSpecies";
    protected LinearLayout container;
    protected CommercialSpeciesModel commercialSpeciesModel;
    protected List<ScientificSpeciesModel> scientficSpeciesModels;
    protected List<CategoryWeightModel> categoryWeightModels = new ArrayList<CategoryWeightModel>();
    protected Map<String, QualitativeValueModel> valuesById = new HashMap<String, QualitativeValueModel>();
    protected int weightUnit;
    protected String weightUnitLabel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        CategoryModel category3;
        CategoryModel category2;
        super.onCreate(savedInstanceState);
        this.container = (LinearLayout)this.findViewById(2131099802);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String weightUnitString = sharedPref.getString(ListItemPreference.WEIGHT_UNIT.getKey(), "1");
        this.weightUnit = Integer.parseInt(weightUnitString);
        switch (this.weightUnit) {
            case 1000: {
                this.weightUnitLabel = "kg";
                break;
            }
            default: {
                this.weightUnitLabel = "g";
            }
        }
        this.commercialSpeciesModel = (CommercialSpeciesModel)this.getIntent().getSerializableExtra(INTENT_COMMERCIAL_SPECIES);
        ArrayList<String> categoryLabels = new ArrayList<String>();
        CategoryModel category1 = this.commercialSpeciesModel.getCategory1();
        if (category1 != null) {
            this.valuesById.putAll((Map<String, QualitativeValueModel>)Maps.uniqueIndex(category1.getQualitativeValues(), BaseModel.GET_ID_FUNCTION));
            categoryLabels.add(category1.getLabel());
        }
        if ((category2 = this.commercialSpeciesModel.getCategory2()) != null) {
            this.valuesById.putAll((Map<String, QualitativeValueModel>)Maps.uniqueIndex(category2.getQualitativeValues(), BaseModel.GET_ID_FUNCTION));
            categoryLabels.add(category2.getLabel());
        }
        if ((category3 = this.commercialSpeciesModel.getCategory3()) != null) {
            this.valuesById.putAll((Map<String, QualitativeValueModel>)Maps.uniqueIndex(category3.getQualitativeValues(), BaseModel.GET_ID_FUNCTION));
            categoryLabels.add(category3.getLabel());
        }
        this.getSupportActionBar().setSubtitle((CharSequence)this.commercialSpeciesModel.toString((Context)this));
        this.createWeightLabel(this.getString(2131427506));
        this.createEditText(this.commercialSpeciesModel.getTotalUnloadedWeight(), new Function<Integer, Void>(){

            public Void apply(Integer input) {
                WeightsActivity.this.commercialSpeciesModel.setTotalUnloadedWeight(input);
                return null;
            }
        });
        WloSqlOpenHelper woh = new WloSqlOpenHelper((Context)this);
        Cursor allScientificSpeciesCursor = woh.getAllScientificSpecies(this.commercialSpeciesModel.getId());
        this.scientficSpeciesModels = WloSqlOpenHelper.transformCursorIntoCollection(allScientificSpeciesCursor, new Function<Cursor, ScientificSpeciesModel>(){

            public ScientificSpeciesModel apply(Cursor input) {
                ScientificSpeciesModel scientificSpeciesModel = new ScientificSpeciesModel((Context)WeightsActivity.this, input);
                scientificSpeciesModel.setParent(WeightsActivity.this.commercialSpeciesModel);
                return scientificSpeciesModel;
            }
        });
        for (final ScientificSpeciesModel scientificSpecies : this.scientficSpeciesModels) {
            this.getLayoutInflater().inflate(2130903089, (ViewGroup)this.container);
            TextView labelView = new TextView((Context)this);
            labelView.setTypeface(Typeface.defaultFromStyle((int)1));
            labelView.setTextAppearance((Context)this, 16973890);
            labelView.setText((CharSequence)scientificSpecies.toString((Context)this));
            this.container.addView((View)labelView);
            this.createWeightLabel(this.getString(2131427507));
            this.createEditText(scientificSpecies.getSortedWeight(), new Function<Integer, Void>(){

                public Void apply(Integer input) {
                    scientificSpecies.setSortedWeight(input);
                    return null;
                }
            });
            this.createWeightLabel(this.getString(2131427508));
            this.createEditText(scientificSpecies.getSampleWeight(), new Function<Integer, Void>(){

                public Void apply(Integer input) {
                    scientificSpecies.setSampleWeight(input);
                    return null;
                }
            });
            if (categoryLabels.isEmpty()) continue;
            TextView weightByCategoryView = new TextView((Context)this);
            weightByCategoryView.setTypeface(Typeface.defaultFromStyle((int)1));
            weightByCategoryView.setTextAppearance((Context)this, 16973892);
            String weightByCategoryViewText = this.getString(2131427509) + " (" + StringUtils.join(categoryLabels, (String)" / ") + ")";
            weightByCategoryView.setText((CharSequence)weightByCategoryViewText);
            this.container.addView((View)weightByCategoryView);
            Cursor categoryWeighs = woh.getAllCategoryWeigths(scientificSpecies.getId());
            List<CategoryWeightModel> categoryWeightModels = WloSqlOpenHelper.transformCursorIntoCollection(categoryWeighs, new Function<Cursor, CategoryWeightModel>(){

                public CategoryWeightModel apply(Cursor input) {
                    CategoryWeightModel result = new CategoryWeightModel(input);
                    result.setParent(scientificSpecies);
                    return result;
                }
            });
            this.categoryWeightModels.addAll(categoryWeightModels);
            for (final CategoryWeightModel categoryWeightModel : categoryWeightModels) {
                String categoryWeightModelCategory3;
                String categoryWeightModelCategory2;
                ArrayList<String> labels = new ArrayList<String>();
                String categoryWeightModelCategory1 = categoryWeightModel.getCategory1();
                if (categoryWeightModelCategory1 != null) {
                    QualitativeValueModel category1Value = this.valuesById.get(categoryWeightModelCategory1);
                    String category1ValueLabel = category1Value != null ? category1Value.toString() : categoryWeightModelCategory1;
                    labels.add(category1ValueLabel);
                }
                if ((categoryWeightModelCategory2 = categoryWeightModel.getCategory2()) != null) {
                    QualitativeValueModel category2Value = this.valuesById.get(categoryWeightModelCategory2);
                    String category2ValueLabel = category2Value != null ? category2Value.toString() : categoryWeightModelCategory2;
                    labels.add(category2ValueLabel);
                }
                if ((categoryWeightModelCategory3 = categoryWeightModel.getCategory3()) != null) {
                    QualitativeValueModel category3Value = this.valuesById.get(categoryWeightModelCategory3);
                    String category3ValueLabel = category3Value != null ? category3Value.toString() : categoryWeightModelCategory3;
                    labels.add(category3ValueLabel);
                }
                String label = StringUtils.join(labels, (String)" / ");
                this.createWeightLabel(label);
                this.createEditText(categoryWeightModel.getWeight(), new Function<Integer, Void>(){

                    public Void apply(Integer input) {
                        categoryWeightModel.setWeight(input);
                        return null;
                    }
                });
            }
        }
        woh.close();
    }

    @Override
    protected Integer getContentView() {
        return 2130903092;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return ScientificSpeciesActivity.class;
    }

    @Override
    public Intent getSupportParentActivityIntent() {
        Intent intent = super.getSupportParentActivityIntent();
        intent.putExtra("parentModel", (Serializable)this.commercialSpeciesModel);
        return intent;
    }

    public void validate(View view) {
        this.saveModel();
        Intent intent = new Intent();
        intent.putExtra(INTENT_COMMERCIAL_SPECIES, (Serializable)this.commercialSpeciesModel);
        this.setResult(-1, intent);
        this.finish();
    }

    protected TextView createWeightLabel(String label) {
        TextView textView = new TextView((Context)this);
        textView.setText((CharSequence)(label + " (" + this.weightUnitLabel + ")"));
        this.container.addView((View)textView);
        return textView;
    }

    protected TextWatcher getTextWatcher(final EditText editText, final Function<Integer, Void> setWeightFunction) {
        return new BaseTextWatcher(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                Integer newValue = null;
                if (StringUtils.isNotEmpty((CharSequence)s)) {
                    newValue = WeightsActivity.this.weightUnit > 1 ? Integer.valueOf((int)(Float.parseFloat(s.toString()) * (float)WeightsActivity.this.weightUnit)) : Integer.valueOf(Integer.parseInt(s.toString()));
                }
                setWeightFunction.apply(newValue);
                editText.setSelection(start + count);
            }
        };
    }

    protected EditText createEditText(Integer value, Function<Integer, Void> setWeightFunction) {
        EditText editText = new EditText((Context)this);
        int inputType = 2;
        String textValue = null;
        if (this.weightUnit > 1) {
            inputType |= 0x2000;
        }
        if (value != null) {
            if (this.weightUnit > 1 && value != null) {
                float floatValue = (float)value.intValue() / (float)this.weightUnit;
                textValue = String.format(Locale.US, "%.3f", Float.valueOf(floatValue));
            } else {
                textValue = String.valueOf(value);
            }
        }
        editText.setInputType(inputType);
        editText.setText(textValue);
        editText.addTextChangedListener(this.getTextWatcher(editText, setWeightFunction));
        this.container.addView((View)editText);
        return editText;
    }

    protected void saveModel() {
        WloSqlOpenHelper woh = new WloSqlOpenHelper((Context)this);
        woh.saveData(this.categoryWeightModels);
        woh.saveData(this.scientficSpeciesModels);
        woh.saveData(this.commercialSpeciesModel);
        woh.close();
    }
}

