/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.google.common.base.Function;
import fr.ifremer.wlo.ContextsActivity;
import fr.ifremer.wlo.DeviceListActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ContextModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.preferences.SettingsActivity;
import fr.ifremer.wlo.storage.CsvExporter;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.JsonExporter;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.ImportExportUtil;
import fr.ifremer.wlo.utils.UpdateCheckTask;
import fr.ifremer.wlo.utils.filechooser.FileDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;

public class MainActivity
extends WloBaseActivity {
    private static final String TAG = "MainActivity";
    protected static final int REQUEST_ENABLE_BT = 1;
    protected static final int REQUEST_SELECT_EXPORT_FOLDER = 2;
    protected BluetoothAdapter mBluetoothAdapter = null;
    protected LinearLayout mainPanel;
    protected LinearLayout logoPanel;
    protected LinearLayout buttonPanel;
    protected Button connectButton;
    protected Button disconnectButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        new InitializationTask().execute(new Void[0]);
        new UpdateCheckTask((Context)this).execute(new String[0]);
        this.mainPanel = (LinearLayout)this.findViewById(2131099754);
        this.logoPanel = (LinearLayout)this.findViewById(2131099755);
        this.buttonPanel = (LinearLayout)this.findViewById(2131099756);
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            this.findViewById(2131099757).setEnabled(false);
        }
        this.connectButton = (Button)this.findViewById(2131099757);
        this.disconnectButton = (Button)this.findViewById(2131099758);
        Configuration config = this.getResources().getConfiguration();
        this.setOrientation(config.orientation);
        this.mMessenger = new Messenger(new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        switch (msg.arg1) {
                            case 3: {
                                MainActivity.this.bigfinConnected();
                                break;
                            }
                            case 0: 
                            case 1: {
                                MainActivity.this.bigfinDisconnected();
                            }
                        }
                        break;
                    }
                    case 5: 
                    case 6: {
                        MainActivity.this.bigfinDisconnected();
                        break;
                    }
                    case 7: {
                        if (msg.arg1 == 3) {
                            MainActivity.this.bigfinConnected();
                            break;
                        }
                        MainActivity.this.bigfinDisconnected();
                    }
                }
            }
        });
        this.bigfinDisconnected();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.getBigFinConnectionState();
    }

    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        super.onServiceConnected(name, service);
        this.getBigFinConnectionState();
    }

    protected void getBigFinConnectionState() {
        if (this.mServiceMessenger != null) {
            try {
                Message msg = Message.obtain(null, (int)7);
                msg.replyTo = this.mMessenger;
                this.mServiceMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error while sending data to the service");
            }
        }
    }

    protected void bigfinConnected() {
        this.disconnectButton.setVisibility(0);
        this.connectButton.setVisibility(8);
    }

    protected void bigfinDisconnected() {
        this.connectButton.setVisibility(0);
        this.disconnectButton.setVisibility(8);
    }

    @Override
    protected Integer getContentView() {
        return 2130903076;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setOrientation(newConfig.orientation);
    }

    public void openContexts(View source) {
        this.startActivity(new Intent((Context)this, ContextsActivity.class));
    }

    public void connectIchtyometer(View source) {
        if (!this.mBluetoothAdapter.isEnabled()) {
            Intent enableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.startActivityForResult(enableIntent, 1);
        } else {
            this.selectDevice();
        }
    }

    public void disconnectIchtyometer(View source) {
        Message message = Message.obtain(null, (int)5);
        try {
            this.mServiceMessenger.send(message);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error while sending data to the service");
        }
    }

    public void openSettings(View source) {
        this.startActivity(new Intent((Context)this, SettingsActivity.class));
    }

    public void export(View source) {
        Intent intent = new Intent((Context)this, FileDialog.class);
        intent.putExtra("START_PATH", "/sdcard");
        intent.putExtra("CAN_SELECT_DIR", true);
        intent.putExtra("SELECTION_MODE", 1);
        intent.putExtra("FORMAT_FILTER", new String[]{"csv"});
        this.startActivityForResult(intent, 2);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                if (resultCode == -1) {
                    this.selectDevice();
                    break;
                }
                Toast.makeText((Context)this, (int)2131427357, (int)0).show();
                break;
            }
            case 2: {
                if (resultCode != -1) break;
                try {
                    File selectedFile = new File(data.getStringExtra("RESULT_PATH"));
                    if (selectedFile.isFile()) {
                        selectedFile = selectedFile.getParentFile();
                    }
                    String date = String.format("-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", new Date());
                    File csvFile = new File(selectedFile, "export" + date + ".csv");
                    CsvExporter exporter = new CsvExporter(';', (Context)this);
                    List<MeasurementModel> measurementModelList = this.getMeasurementModels();
                    Export.exportToFile((ExportModel)exporter, measurementModelList, (File)csvFile);
                    String jsonData = JsonExporter.exportData((Context)this);
                    File jsonFile = new File(selectedFile, "export" + date + ".json");
                    FileUtils.write((File)jsonFile, (CharSequence)jsonData);
                    Toast.makeText((Context)this, (CharSequence)("Export effectu\u00e9 dans les fichiers " + csvFile.getAbsolutePath() + " et " + jsonFile.getAbsolutePath()), (int)1).show();
                    break;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"error while exporting to CSV", (Throwable)e);
                    Toast.makeText((Context)this, (CharSequence)"Erreur lors de l'export", (int)0).show();
                }
            }
        }
    }

    protected List<MeasurementModel> getMeasurementModels() {
        ArrayList<MeasurementModel> measurementModelList = new ArrayList<MeasurementModel>();
        WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)this);
        Cursor cursor = soh.getAllContexts();
        List<ContextModel> contexts = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, ContextModel>(){

            public ContextModel apply(Cursor input) {
                return new ContextModel(input);
            }
        });
        for (final ContextModel contextModel : contexts) {
            cursor = soh.getAllLocations(contextModel.getId());
            List<LocationModel> locationModels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, LocationModel>(){

                public LocationModel apply(Cursor input) {
                    LocationModel locationModel = new LocationModel((Context)MainActivity.this, input);
                    locationModel.setParent(contextModel);
                    return locationModel;
                }
            });
            for (final LocationModel locationModel : locationModels) {
                cursor = soh.getAllVessels(locationModel.getId());
                List<VesselModel> vesselModels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, VesselModel>(){

                    public VesselModel apply(Cursor input) {
                        VesselModel vesselModel = new VesselModel((Context)MainActivity.this, input);
                        vesselModel.setParent(locationModel);
                        return vesselModel;
                    }
                });
                for (final VesselModel vesselModel : vesselModels) {
                    cursor = soh.getAllMetiers(vesselModel.getId());
                    List<MetierModel> metierModels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, MetierModel>(){

                        public MetierModel apply(Cursor input) {
                            MetierModel metierModel = new MetierModel((Context)MainActivity.this, input);
                            metierModel.setParent(vesselModel);
                            return metierModel;
                        }
                    });
                    for (final MetierModel metierModel : metierModels) {
                        cursor = soh.getAllCommercialSpecies(metierModel.getId());
                        List<CommercialSpeciesModel> commercialSpeciesModels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, CommercialSpeciesModel>(){

                            public CommercialSpeciesModel apply(Cursor input) {
                                CommercialSpeciesModel commercialSpeciesModel = new CommercialSpeciesModel((Context)MainActivity.this, input);
                                commercialSpeciesModel.setParent(metierModel);
                                return commercialSpeciesModel;
                            }
                        });
                        for (final CommercialSpeciesModel commercialSpeciesModel : commercialSpeciesModels) {
                            cursor = soh.getAllScientificSpecies(commercialSpeciesModel.getId());
                            List<ScientificSpeciesModel> scientificSpeciesModels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, ScientificSpeciesModel>(){

                                public ScientificSpeciesModel apply(Cursor input) {
                                    ScientificSpeciesModel scientificSpeciesModel = new ScientificSpeciesModel((Context)MainActivity.this, input);
                                    scientificSpeciesModel.setParent(commercialSpeciesModel);
                                    return scientificSpeciesModel;
                                }
                            });
                            for (final ScientificSpeciesModel scientificSpeciesModel : scientificSpeciesModels) {
                                HashMap<Triple<String, String, String>, Integer> categoryWeights = new HashMap<Triple<String, String, String>, Integer>();
                                cursor = soh.getAllCategoryWeigths(scientificSpeciesModel.getId());
                                boolean cont = cursor.moveToFirst();
                                while (cont) {
                                    String category1 = cursor.getString(1);
                                    String category2 = cursor.getString(2);
                                    String category3 = cursor.getString(3);
                                    Integer weight = null;
                                    if (!cursor.isNull(4)) {
                                        weight = cursor.getInt(4);
                                    }
                                    Triple key = Triple.of((Object)category1, (Object)category2, (Object)category3);
                                    categoryWeights.put((Triple<String, String, String>)key, weight);
                                    cont = cursor.moveToNext();
                                }
                                scientificSpeciesModel.setCategoryWeights(categoryWeights);
                                cursor = soh.getAllMeasurements(scientificSpeciesModel.getId());
                                List<MeasurementModel> measurementModels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, MeasurementModel>(){

                                    public MeasurementModel apply(Cursor input) {
                                        MeasurementModel measurementModel = new MeasurementModel(input);
                                        measurementModel.setParent(scientificSpeciesModel);
                                        return measurementModel;
                                    }
                                });
                                measurementModelList.addAll(measurementModels);
                            }
                        }
                    }
                }
            }
        }
        return measurementModelList;
    }

    protected void setOrientation(int orientation) {
        LinearLayout.LayoutParams buttonParams;
        LinearLayout.LayoutParams logoParams;
        if (orientation == 2) {
            logoParams = new LinearLayout.LayoutParams(-2, -1);
            logoParams.weight = 1.0f;
            buttonParams = new LinearLayout.LayoutParams(-2, -1);
            buttonParams.weight = 1.0f;
        } else {
            logoParams = new LinearLayout.LayoutParams(-1, -2);
            logoParams.weight = 1.0f;
            buttonParams = new LinearLayout.LayoutParams(-1, -2);
            buttonParams.weight = 0.0f;
        }
        this.logoPanel.setLayoutParams((ViewGroup.LayoutParams)logoParams);
        this.buttonPanel.setLayoutParams((ViewGroup.LayoutParams)buttonParams);
        this.mainPanel.setOrientation(orientation);
    }

    protected void selectDevice() {
        Intent serverIntent = new Intent((Context)this, DeviceListActivity.class);
        this.startActivity(serverIntent);
    }

    protected class InitializationTask
    extends AsyncTask<Void, Integer, Void> {
        protected ProgressDialog dialog;

        protected InitializationTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog = new ProgressDialog((Context)MainActivity.this);
            this.dialog.setIndeterminate(false);
            this.dialog.setCancelable(false);
            this.dialog.setProgressStyle(1);
            this.dialog.setMax(9);
            this.dialog.setMessage((CharSequence)MainActivity.this.getString(2131427386));
            this.dialog.show();
        }

        protected Void doInBackground(Void ... params) {
            MainActivity context = MainActivity.this;
            try {
                int i = 1;
                if (DataCache.getAllCommercialSpecies((Context)context).isEmpty()) {
                    ImportExportUtil.importCommercialSpecies((Context)context, MainActivity.this.getAssets().open("ref_import_commercial_species.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllLocations((Context)context).isEmpty()) {
                    ImportExportUtil.importLocations((Context)context, MainActivity.this.getAssets().open("ref_import_locations.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllMensurations((Context)context).isEmpty()) {
                    ImportExportUtil.importMensurations((Context)context, MainActivity.this.getAssets().open("ref_import_mensurations.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllMetiers((Context)context).isEmpty()) {
                    ImportExportUtil.importMetiers((Context)context, MainActivity.this.getAssets().open("ref_import_metiers.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllPresentations((Context)context).isEmpty()) {
                    ImportExportUtil.importPresentations((Context)context, MainActivity.this.getAssets().open("ref_import_presentations.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllScientificSpecies((Context)context).isEmpty()) {
                    ImportExportUtil.importScientificSpecies((Context)context, MainActivity.this.getAssets().open("ref_import_scientific_species.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllStates((Context)context).isEmpty()) {
                    ImportExportUtil.importStates((Context)context, MainActivity.this.getAssets().open("ref_import_states.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllVessels((Context)context).isEmpty()) {
                    ImportExportUtil.importVessels((Context)context, MainActivity.this.getAssets().open("ref_import_vessels.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllCategories((Context)context).isEmpty()) {
                    WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)context);
                    CategoryModel ageCategory = new CategoryModel();
                    ageCategory.setLabel(MainActivity.this.getString(2131427369));
                    soh.saveData(ageCategory);
                    CategoryModel genderCategory = new CategoryModel();
                    genderCategory.setLabel(MainActivity.this.getString(2131427367));
                    soh.saveData(genderCategory);
                    CategoryModel maturityCategory = new CategoryModel();
                    maturityCategory.setLabel(MainActivity.this.getString(2131427368));
                    soh.saveData(maturityCategory);
                    soh.saveData(ImportExportUtil.importQualitativeValues(ageCategory, MainActivity.this.getAssets().open("ref_import_ages.csv")));
                    soh.saveData(ImportExportUtil.importQualitativeValues(genderCategory, MainActivity.this.getAssets().open("ref_import_genders.csv")));
                    soh.saveData(ImportExportUtil.importQualitativeValues(maturityCategory, MainActivity.this.getAssets().open("ref_import_maturities.csv")));
                    soh.close();
                }
                this.publishProgress(new Integer[]{i++});
            }
            catch (IOException | RuntimeException e) {
                Log.e((String)MainActivity.TAG, (String)"error on initial import", (Throwable)e);
            }
            return null;
        }

        protected void onProgressUpdate(Integer ... progress) {
            this.dialog.setProgress(progress[0].intValue());
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            this.dialog.dismiss();
        }
    }
}

