/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.wlo.CommercialSpeciesActivity;
import fr.ifremer.wlo.ScientificSpeciesActivity;
import fr.ifremer.wlo.ScientificSpeciesFormActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.WloBaseListActivity;
import fr.ifremer.wlo.WloModelEditionActivity;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.referentials.CommercialSpecies;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.preferences.MultiSelectItemPreference;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.WloAutoCompleteTextViewWithFavorites;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class CommercialSpeciesFormActivity
extends WloModelEditionActivity<CommercialSpeciesModel> {
    private static final String TAG = "CommercialSpeciesFormActivity";

    @Override
    protected Integer getContentView() {
        return 2130903065;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return CommercialSpeciesActivity.class;
    }

    @Override
    protected Class<? extends WloModelEditionActivity> getNextEditionActivity() {
        return ScientificSpeciesFormActivity.class;
    }

    @Override
    protected Class<? extends WloBaseListActivity> getNextListActivity() {
        return ScientificSpeciesActivity.class;
    }

    @Override
    protected CommercialSpeciesModel createNewModel() {
        return new CommercialSpeciesModel();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        boolean speciesMixEnabled;
        super.onCreate(savedInstanceState);
        ArrayList commercialSpecies = Lists.newArrayList(DataCache.getAllCommercialSpecies((Context)this));
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        final Set favoriteIds = sharedPref.getStringSet(MultiSelectItemPreference.COMMERCIAL_SPECIES_FAVORITES.getKey(), (Set)Sets.newHashSet());
        Collection favorites = Collections2.filter((Collection)commercialSpecies, (Predicate)new Predicate<CommercialSpecies>(){

            public boolean apply(CommercialSpecies input) {
                return favoriteIds.contains(input.getId());
            }
        });
        WloAutoCompleteTextViewWithFavorites actvwf = (WloAutoCompleteTextViewWithFavorites)this.findViewById(2131099713);
        this.initAutoCompleteTextView(actvwf.getAutoCompleteTextView(), "faoCode", commercialSpecies, favorites);
        actvwf.useFavorites(!favorites.isEmpty());
        if (((CommercialSpeciesModel)this.model).getMeasurementMethod() == null) {
            Mensuration defaultMensuration = DataCache.getDefaultMensuration((Context)this);
            ((CommercialSpeciesModel)this.model).setMeasurementMethod(defaultMensuration);
        }
        ArrayList mensurations = Lists.newArrayList(DataCache.getAllMensurations((Context)this));
        this.initAutoCompleteTextView(2131099714, "measurementMethod", mensurations);
        Spinner precisionSpinner = (Spinner)this.findViewById(2131099715);
        ArrayAdapter precisions = new ArrayAdapter((Context)this, 17367043, (Object[])Mensuration.Precision.values());
        precisionSpinner.setAdapter((SpinnerAdapter)precisions);
        precisionSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                ((CommercialSpeciesModel)CommercialSpeciesFormActivity.this.model).setPrecision((Mensuration.Precision)((Object)adapterView.getItemAtPosition(i)));
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
                ((CommercialSpeciesModel)CommercialSpeciesFormActivity.this.model).setPrecision(null);
            }
        });
        precisionSpinner.setSelection(((CommercialSpeciesModel)this.model).getPrecision().ordinal());
        boolean precisionEnabled = ((CommercialSpeciesModel)this.model).isNew();
        if (!precisionEnabled) {
            WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)this);
            Cursor cursor = soh.getAllMeasurementsForCommercialSpecies(((CommercialSpeciesModel)this.model).getId());
            int measurementNb = cursor.getCount();
            precisionEnabled = measurementNb == 0;
        }
        precisionSpinner.setEnabled(precisionEnabled);
        Set<String> sortCategories = DataCache.getAllSortCategories((Context)this);
        sortCategories.remove("");
        this.initEditText(2131099717, "sortCategory");
        this.initAutoCompleteTextView(2131099717, "sortCategory", sortCategories);
        ArrayList states = Lists.newArrayList(DataCache.getAllStates((Context)this));
        this.initAutoCompleteTextView(2131099718, "state", states);
        ArrayList presentations = Lists.newArrayList(DataCache.getAllPresentations((Context)this));
        this.initAutoCompleteTextView(2131099719, "presentation", presentations);
        CheckBox speciesMixEditor = (CheckBox)this.findViewById(2131099716);
        speciesMixEditor.setChecked(((CommercialSpeciesModel)this.model).isSpeciesMix());
        speciesMixEditor.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                ((CommercialSpeciesModel)CommercialSpeciesFormActivity.this.model).setSpeciesMix(b);
            }
        });
        boolean bl = speciesMixEnabled = ((CommercialSpeciesModel)this.model).isNew() || !((CommercialSpeciesModel)this.model).isSpeciesMix();
        if (!speciesMixEnabled) {
            WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)this);
            Cursor cursor = soh.getAllScientificSpecies(((CommercialSpeciesModel)this.model).getId());
            int scientificSpeciesNb = cursor.getCount();
            speciesMixEnabled = scientificSpeciesNb < 2;
        }
        speciesMixEditor.setEnabled(speciesMixEnabled);
        this.initEditText(2131099723, "comment");
        this.initCategorySpinner((Spinner)this.findViewById(2131099720), ((CommercialSpeciesModel)this.model).getCategory1(), new Function<CategoryModel, Void>(){

            public Void apply(CategoryModel input) {
                ((CommercialSpeciesModel)CommercialSpeciesFormActivity.this.model).setCategory1(input);
                return null;
            }
        });
        this.initCategorySpinner((Spinner)this.findViewById(2131099721), ((CommercialSpeciesModel)this.model).getCategory2(), new Function<CategoryModel, Void>(){

            public Void apply(CategoryModel input) {
                ((CommercialSpeciesModel)CommercialSpeciesFormActivity.this.model).setCategory2(input);
                return null;
            }
        });
        this.initCategorySpinner((Spinner)this.findViewById(2131099722), ((CommercialSpeciesModel)this.model).getCategory3(), new Function<CategoryModel, Void>(){

            public Void apply(CategoryModel input) {
                ((CommercialSpeciesModel)CommercialSpeciesFormActivity.this.model).setCategory3(input);
                return null;
            }
        });
    }

    protected void initCategorySpinner(Spinner spinner, CategoryModel category, final Function<CategoryModel, Void> setCategoryFunction) {
        ArrayList<CategoryModel> categories = new ArrayList<CategoryModel>(DataCache.getAllCategories((Context)this));
        categories.add(0, (CategoryModel)((Object)""));
        ArrayAdapter adapter = new ArrayAdapter((Context)this, 0x1090009, categories);
        spinner.setAdapter((SpinnerAdapter)adapter);
        spinner.setSelection(adapter.getPosition((Object)category));
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CategoryModel category;
                if (position == 0) {
                    category = null;
                } else {
                    category = (CategoryModel)parent.getItemAtPosition(position);
                    category = DataCache.getCategoryById((Context)CommercialSpeciesFormActivity.this, category.getId());
                }
                setCategoryFunction.apply((Object)category);
            }

            public void onNothingSelected(AdapterView<?> parent) {
                setCategoryFunction.apply(null);
            }
        });
    }

    @Override
    protected void saveModel() {
        super.saveModel();
        DataCache.invalidateSortCategories();
    }
}

