/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.imports.CalcifiedPartTakingRowModel;
import fr.ifremer.wlo.imports.CommercialSpeciesRowModel;
import fr.ifremer.wlo.imports.LocationRowModel;
import fr.ifremer.wlo.imports.MensurationRowModel;
import fr.ifremer.wlo.imports.MetierRowModel;
import fr.ifremer.wlo.imports.PresentationRowModel;
import fr.ifremer.wlo.imports.QualitativeValueRowModel;
import fr.ifremer.wlo.imports.ScientificSpeciesRowModel;
import fr.ifremer.wlo.imports.StateRowModel;
import fr.ifremer.wlo.imports.VesselRowModel;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.CalcifiedPartTaking;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Range;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;

public class ImportExportUtil {
    private static final String TAG = "ImportExportUtil";
    public static final char CSV_SEPARATOR = ';';

    public static int importCommercialSpecies(Context context, String path) {
        try {
            return ImportExportUtil.importCommercialSpecies(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importCommercialSpecies(Context context, InputStream inputStream) {
        CommercialSpeciesRowModel commercialSpeciesRowModel = new CommercialSpeciesRowModel(';');
        int result = ImportExportUtil.importData(context, commercialSpeciesRowModel, inputStream);
        DataCache.invalidateCommercialSpecies();
        return result;
    }

    public static int exportCommercialSpecies(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        CommercialSpeciesRowModel commercialSpeciesRowModel = new CommercialSpeciesRowModel(';');
        int result = ImportExportUtil.exportData(context, commercialSpeciesRowModel, DataCache.getAllCommercialSpecies(context), path, 2131427426);
        return result;
    }

    public static int importLocations(Context context, String path) {
        try {
            return ImportExportUtil.importLocations(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importLocations(Context context, InputStream inputStream) {
        LocationRowModel locationRowModel = new LocationRowModel(';');
        int result = ImportExportUtil.importData(context, locationRowModel, inputStream);
        DataCache.invalidateLocations();
        return result;
    }

    public static int exportLocations(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        LocationRowModel locationRowModel = new LocationRowModel(';');
        int result = ImportExportUtil.exportData(context, locationRowModel, DataCache.getAllLocations(context), path, 2131427427);
        return result;
    }

    public static int importMensurations(Context context, String path) {
        try {
            return ImportExportUtil.importMensurations(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importMensurations(Context context, InputStream inputStream) {
        MensurationRowModel mensurationRowModel = new MensurationRowModel(';');
        int result = ImportExportUtil.importData(context, mensurationRowModel, inputStream);
        DataCache.invalidateMensurations();
        return result;
    }

    public static int exportMensurations(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        MensurationRowModel mensurationRowModel = new MensurationRowModel(';');
        int result = ImportExportUtil.exportData(context, mensurationRowModel, DataCache.getAllMensurations(context), path, 2131427428);
        return result;
    }

    public static int importMetiers(Context context, String path) {
        try {
            return ImportExportUtil.importMetiers(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importMetiers(Context context, InputStream inputStream) {
        MetierRowModel metierRowModel = new MetierRowModel(';');
        int result = ImportExportUtil.importData(context, metierRowModel, inputStream);
        DataCache.invalidateMetiers();
        return result;
    }

    public static int exportMetiers(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        MetierRowModel metierRowModel = new MetierRowModel(';');
        int result = ImportExportUtil.exportData(context, metierRowModel, DataCache.getAllMetiers(context), path, 2131427429);
        return result;
    }

    public static int importPresentations(Context context, String path) {
        try {
            return ImportExportUtil.importPresentations(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importPresentations(Context context, InputStream inputStream) {
        PresentationRowModel presentationRowModel = new PresentationRowModel(';');
        int result = ImportExportUtil.importData(context, presentationRowModel, inputStream);
        DataCache.invalidatePresentations();
        return result;
    }

    public static int exportPresentations(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        PresentationRowModel presentationRowModel = new PresentationRowModel(';');
        int result = ImportExportUtil.exportData(context, presentationRowModel, DataCache.getAllPresentations(context), path, 2131427430);
        return result;
    }

    public static int importScientificSpecies(Context context, String path) {
        try {
            return ImportExportUtil.importScientificSpecies(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importScientificSpecies(Context context, InputStream inputStream) {
        ScientificSpeciesRowModel scientificSpeciesRowModel = new ScientificSpeciesRowModel(';');
        int result = ImportExportUtil.importData(context, scientificSpeciesRowModel, inputStream);
        DataCache.invalidateScientificSpecies();
        return result;
    }

    public static int exportScientificSpecies(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        ScientificSpeciesRowModel scientificSpeciesRowModel = new ScientificSpeciesRowModel(';');
        int result = ImportExportUtil.exportData(context, scientificSpeciesRowModel, DataCache.getAllScientificSpecies(context), path, 2131427431);
        return result;
    }

    public static int importStates(Context context, String path) {
        try {
            return ImportExportUtil.importStates(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importStates(Context context, InputStream inputStream) {
        StateRowModel stateRowModel = new StateRowModel(';');
        int result = ImportExportUtil.importData(context, stateRowModel, inputStream);
        DataCache.invalidateStates();
        return result;
    }

    public static int exportStates(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        StateRowModel stateRowModel = new StateRowModel(';');
        int result = ImportExportUtil.exportData(context, stateRowModel, DataCache.getAllStates(context), path, 2131427432);
        return result;
    }

    public static int importVessels(Context context, String path) {
        try {
            return ImportExportUtil.importVessels(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importVessels(Context context, InputStream inputStream) {
        VesselRowModel vesselRowModel = new VesselRowModel(';');
        int result = ImportExportUtil.importData(context, vesselRowModel, inputStream);
        DataCache.invalidateVessels();
        return result;
    }

    public static int exportVessels(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        VesselRowModel vesselRowModel = new VesselRowModel(';');
        int result = ImportExportUtil.exportData(context, vesselRowModel, DataCache.getAllVessels(context), path, 2131427433);
        return result;
    }

    public static int importCalcifiedPartTakings(Context context, String path) throws Exception {
        try {
            return ImportExportUtil.importCalcifiedPartTakings(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int importCalcifiedPartTakings(Context context, InputStream inputStream) {
        CalcifiedPartTakingRowModel calcifiedPartTakingRowModel = new CalcifiedPartTakingRowModel(';', DataCache.getAllScientificSpecies(context));
        Collection<CalcifiedPartTaking> data = ImportExportUtil.importData(calcifiedPartTakingRowModel, inputStream);
        HashMultimap ranges = HashMultimap.create();
        HashMap<String, Integer> sizeSteps = new HashMap<String, Integer>();
        for (CalcifiedPartTaking taking : data) {
            void var12_15;
            Integer n;
            Integer startSize;
            if (taking.getParent() == null) {
                throw new NullPointerException(context.getString(2131427444));
            }
            String parentId = taking.getParentId();
            Integer speciesSizeStep = (Integer)sizeSteps.get(parentId);
            Integer sizeStep = taking.getSizeStep();
            if (speciesSizeStep != null && sizeStep != null && !speciesSizeStep.equals(sizeStep)) {
                throw new RuntimeException(context.getString(2131427447));
            }
            if (sizeStep != null) {
                sizeSteps.put(parentId, sizeStep);
            }
            if ((startSize = taking.getStartSize()) == null) {
                startSize = 0;
            }
            if ((n = taking.getEndSize()) == null) {
                Integer n2 = Integer.MAX_VALUE;
            }
            Range currentRange = Range.between((Comparable)startSize, (Comparable)var12_15);
            for (Range range : ranges.get((Object)parentId)) {
                if (!range.isOverlappedBy(currentRange)) continue;
                throw new RuntimeException(context.getString(2131427445));
            }
            ranges.put((Object)parentId, (Object)currentRange);
        }
        if (sizeSteps.containsValue(null)) {
            throw new RuntimeException(context.getString(2131427448));
        }
        TreeSet<Range<Integer>> rangesForSpecies = new TreeSet<Range<Integer>>(new Comparator<Range<Integer>>(){

            @Override
            public int compare(Range<Integer> lhs, Range<Integer> rhs) {
                return ObjectUtils.compare((Comparable)((Comparable)lhs.getMinimum()), (Comparable)((Comparable)rhs.getMinimum()));
            }
        });
        for (String speciesId : ranges.keySet()) {
            int sizeStep = (Integer)sizeSteps.get(speciesId);
            rangesForSpecies.clear();
            rangesForSpecies.addAll(ranges.get((Object)speciesId));
            int n = 0;
            for (Range range : rangesForSpecies) {
                if ((Integer)range.getMinimum() - sizeStep > n) {
                    throw new RuntimeException(context.getString(2131427446));
                }
                n = (Integer)range.getMaximum();
            }
            if (n >= Integer.MAX_VALUE) continue;
            throw new RuntimeException(context.getString(2131427446));
        }
        WloSqlOpenHelper soh = new WloSqlOpenHelper(context);
        soh.saveData(data);
        soh.close();
        int result = data.size();
        return result;
    }

    public static int exportCalcifiedPartTakings(Context context, String path) throws Exception {
        Preconditions.checkNotNull((Object)path);
        CalcifiedPartTakingRowModel calcifiedPartTakingRowModel = new CalcifiedPartTakingRowModel(';', DataCache.getAllScientificSpecies(context));
        WloSqlOpenHelper wloSqlOpenHelper = new WloSqlOpenHelper(context);
        int result = ImportExportUtil.exportData(context, calcifiedPartTakingRowModel, WloSqlOpenHelper.transformCursorIntoCollection(wloSqlOpenHelper.getAllCalcifiedPartTakings(), new Function<Cursor, CalcifiedPartTaking>(){

            public CalcifiedPartTaking apply(Cursor input) {
                return new CalcifiedPartTaking(input);
            }
        }), path, 2131427443);
        wloSqlOpenHelper.close();
        return result;
    }

    public static Collection<QualitativeValueModel> importQualitativeValues(CategoryModel categoryModel, String path) {
        try {
            return ImportExportUtil.importQualitativeValues(categoryModel, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return null;
        }
    }

    public static Collection<QualitativeValueModel> importQualitativeValues(CategoryModel categoryModel, InputStream inputStream) {
        QualitativeValueRowModel qualitativeValueRowModel = new QualitativeValueRowModel(';', categoryModel);
        Collection<QualitativeValueModel> result = ImportExportUtil.importData(qualitativeValueRowModel, inputStream);
        return result;
    }

    protected static <M extends BaseModel> int importData(Context context, ImportModel<M> importModel, InputStream inputStream) {
        Collection<M> models = ImportExportUtil.importData(importModel, inputStream);
        if (CollectionUtils.isNotEmpty(models)) {
            WloSqlOpenHelper soh = new WloSqlOpenHelper(context);
            soh.saveData(models);
            soh.close();
        }
        return models.size();
    }

    protected static <M extends BaseModel> Collection<M> importData(ImportModel<M> importModel, InputStream inputStream) {
        ArrayList models = null;
        try (Import importer = null;){
            importer = Import.newImport(importModel, (InputStream)inputStream);
            models = Lists.newArrayList((Iterator)importer.iterator());
        }
        return models;
    }

    protected static <M extends BaseModel> int exportData(Context context, ExportModel<M> exportModel, Collection<M> data, String path, int defaultFileName) throws Exception {
        int result = 0;
        File targetFile = new File(path);
        if (targetFile.isDirectory()) {
            String fileName = context.getString(defaultFileName) + String.format("-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", new Date()) + ".csv";
            targetFile = new File(targetFile, fileName);
        }
        try {
            Export.exportToFile(exportModel, data, (File)targetFile);
            result = data.size();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"error during import", (Throwable)e);
            throw e;
        }
        return result;
    }
}

