/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.storage;

import android.content.Context;
import android.database.Cursor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.CategoryWeightModel;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ContextModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.CommercialSpecies;
import fr.ifremer.wlo.models.referentials.Location;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.models.referentials.Metier;
import fr.ifremer.wlo.models.referentials.Presentation;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import fr.ifremer.wlo.models.referentials.State;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonExporter {
    protected static Map<String, QualitativeValueModel> qualitativeValuesById;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exportData(Context context) throws JSONException {
        JSONArray root = new JSONArray();
        try (WloSqlOpenHelper soh = new WloSqlOpenHelper(context);){
            Cursor qualitativeValuesCursor = soh.getAllQualitativeValues();
            List<QualitativeValueModel> qualitativeValues = WloSqlOpenHelper.transformCursorIntoCollection(qualitativeValuesCursor, new Function<Cursor, QualitativeValueModel>(){

                public QualitativeValueModel apply(Cursor input) {
                    return new QualitativeValueModel(input);
                }
            });
            qualitativeValuesById = Maps.uniqueIndex(qualitativeValues, BaseModel.GET_ID_FUNCTION);
            Cursor cursor = soh.getAllContexts();
            List<ContextModel> contexts = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, ContextModel>(){

                public ContextModel apply(Cursor input) {
                    return new ContextModel(input);
                }
            });
            for (ContextModel contextModel : contexts) {
                JSONObject jsonContext = JsonExporter.createJSONContextModel(contextModel, context, soh);
                root.put((Object)jsonContext);
            }
        }
        return root.toString(2);
    }

    public static JSONObject createJSONContextModel(ContextModel model, final Context context, WloSqlOpenHelper soh) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)((Object)soh));
        JSONObject jsonContext = new JSONObject();
        jsonContext.put("contexte", (Object)model.getName());
        jsonContext.put("commentaire", (Object)model.getComment());
        Cursor cursor = soh.getAllLocations(model.getId());
        List<LocationModel> locations = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, LocationModel>(){

            public LocationModel apply(Cursor input) {
                return new LocationModel(context, input);
            }
        });
        JSONArray jsonLocations = new JSONArray();
        for (LocationModel location : locations) {
            JSONObject jsonLocation = JsonExporter.createJSONLocationModel(location, context, soh);
            jsonLocations.put((Object)jsonLocation);
        }
        jsonContext.put("lieux", (Object)jsonLocations);
        cursor.close();
        return jsonContext;
    }

    public static JSONObject createJSONLocationModel(LocationModel model, final Context context, WloSqlOpenHelper soh) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)((Object)soh));
        JSONObject jsonLocation = new JSONObject();
        jsonLocation.put("lieu", (Object)JsonExporter.createJSONLocation(model.getLocation()));
        if (model.getStartDate() != null) {
            jsonLocation.put("date-d\u00e9but", (Object)UIUtils.UTC_DATE_FORMAT.format(model.getStartDate().getTime()));
        }
        if (model.getEndDate() != null) {
            jsonLocation.put("date-fin", (Object)UIUtils.UTC_DATE_FORMAT.format(model.getEndDate().getTime()));
        }
        jsonLocation.put("observateur", (Object)model.getOperator());
        jsonLocation.put("commentaire", (Object)model.getComment());
        Cursor cursor = soh.getAllVessels(model.getId());
        List<VesselModel> vessels = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, VesselModel>(){

            public VesselModel apply(Cursor input) {
                return new VesselModel(context, input);
            }
        });
        JSONArray jsonVessels = new JSONArray();
        for (VesselModel vessel : vessels) {
            JSONObject jsonVessel = JsonExporter.createJSONVesselModel(vessel, context, soh);
            jsonVessels.put((Object)jsonVessel);
        }
        jsonLocation.put("navires", (Object)jsonVessels);
        cursor.close();
        return jsonLocation;
    }

    public static JSONObject createJSONVesselModel(VesselModel model, final Context context, WloSqlOpenHelper soh) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)((Object)soh));
        JSONObject jsonVessel = new JSONObject();
        jsonVessel.put("immatriculation", (Object)model.getRegistrationNumber());
        jsonVessel.put("nom", (Object)model.getRegistrationNumber());
        if (model.getLandingDate() != null) {
            jsonVessel.put("date-d\u00e9barquement", (Object)UIUtils.UTC_DATE_FORMAT.format(model.getLandingDate().getTime()));
        }
        jsonVessel.put("lieu-d\u00e9barquement", (Object)JsonExporter.createJSONLocation(model.getLandingLocation()));
        jsonVessel.put("commentaire", (Object)model.getComment());
        Cursor cursor = soh.getAllMetiers(model.getId());
        List<MetierModel> metiers = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, MetierModel>(){

            public MetierModel apply(Cursor input) {
                return new MetierModel(context, input);
            }
        });
        JSONArray jsonMetiers = new JSONArray();
        for (MetierModel metier : metiers) {
            JSONObject jsonMetier = JsonExporter.createJSONMetierModel(metier, context, soh);
            jsonMetiers.put((Object)jsonMetier);
        }
        jsonVessel.put("m\u00e9tiers", (Object)jsonMetiers);
        cursor.close();
        return jsonVessel;
    }

    public static JSONObject createJSONMetierModel(MetierModel model, final Context context, WloSqlOpenHelper soh) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)((Object)soh));
        JSONObject jsonMetier = new JSONObject();
        jsonMetier.put("engin-esp\u00e8ce", (Object)JsonExporter.createJSONMetier(model.getGearSpecies()));
        jsonMetier.put("secteur", (Object)model.getZone());
        jsonMetier.put("r\u00e9f\u00e9rence-plan", (Object)model.getSampleRowCode());
        jsonMetier.put("commentaire", (Object)model.getComment());
        Cursor cursor = soh.getAllCommercialSpecies(model.getId());
        List<CommercialSpeciesModel> commercialSpecies = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, CommercialSpeciesModel>(){

            public CommercialSpeciesModel apply(Cursor input) {
                return new CommercialSpeciesModel(context, input);
            }
        });
        JSONArray jsonCommercialSpeciesArray = new JSONArray();
        for (CommercialSpeciesModel commercialSpeciesModel : commercialSpecies) {
            JSONObject jsonCommercialSpecies = JsonExporter.createJSONComercialSpeciesModel(commercialSpeciesModel, context, soh);
            jsonCommercialSpeciesArray.put((Object)jsonCommercialSpecies);
        }
        jsonMetier.put("esp\u00e8ces-fao", (Object)jsonCommercialSpeciesArray);
        cursor.close();
        return jsonMetier;
    }

    public static JSONObject createJSONComercialSpeciesModel(CommercialSpeciesModel model, final Context context, WloSqlOpenHelper soh) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)((Object)soh));
        JSONObject jsonCommercialSpecies = new JSONObject();
        jsonCommercialSpecies.put("esp\u00e8ce-fao", (Object)JsonExporter.createJSONCommercialSpecies(model.getFaoCode()));
        jsonCommercialSpecies.put("m\u00e9thode-mensuration", (Object)JsonExporter.createJSONMensuration(model.getMeasurementMethod()));
        jsonCommercialSpecies.put("\u00e9tat", (Object)JsonExporter.createJSONState(model.getState()));
        jsonCommercialSpecies.put("pr\u00e9sentation", (Object)JsonExporter.createJSONPresentation(model.getPresentation()));
        jsonCommercialSpecies.put("pr\u00e9cision", model.getPrecision().getValue());
        jsonCommercialSpecies.put("m\u00e9lange-esp\u00e8ces", model.isSpeciesMix());
        jsonCommercialSpecies.put("cat\u00e9gorie-tri", (Object)model.getSortCategory());
        jsonCommercialSpecies.put("poids-total-d\u00e9charg\u00e9", (Object)model.getTotalUnloadedWeight());
        jsonCommercialSpecies.put("commentaire", (Object)model.getComment());
        Cursor cursor = soh.getAllScientificSpecies(model.getId());
        List<ScientificSpeciesModel> scientificSpecies = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, ScientificSpeciesModel>(){

            public ScientificSpeciesModel apply(Cursor input) {
                return new ScientificSpeciesModel(context, input);
            }
        });
        JSONArray jsonScientificSpeciesArray = new JSONArray();
        for (ScientificSpeciesModel scientificSpeciesModel : scientificSpecies) {
            scientificSpeciesModel.setParent(model);
            JSONObject jsonScientificSpecies = JsonExporter.createJSONScientificSpeciesModel(scientificSpeciesModel, context, soh);
            jsonScientificSpeciesArray.put((Object)jsonScientificSpecies);
        }
        jsonCommercialSpecies.put("esp\u00e8ces-scientifiques", (Object)jsonScientificSpeciesArray);
        cursor.close();
        return jsonCommercialSpecies;
    }

    public static JSONObject createJSONScientificSpeciesModel(ScientificSpeciesModel model, Context context, WloSqlOpenHelper soh) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)((Object)soh));
        JSONObject jsonScientificSpeciesModel = new JSONObject();
        jsonScientificSpeciesModel.put("esp\u00e8ce-scientifique", (Object)JsonExporter.createJSONScientificSpecies(model.getName()));
        jsonScientificSpeciesModel.put("pr\u00e9l\u00e8vement-pi\u00e8ces-calcifi\u00e9es", model.isTakingActivation());
        jsonScientificSpeciesModel.put("commentaire", (Object)model.getComment());
        jsonScientificSpeciesModel.put("poids-tri\u00e9", (Object)model.getSortedWeight());
        jsonScientificSpeciesModel.put("poids-\u00e9chantillon", (Object)model.getSampleWeight());
        Cursor cursor = soh.getAllMeasurements(model.getId());
        List<MeasurementModel> measurements = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, MeasurementModel>(){

            public MeasurementModel apply(Cursor input) {
                return new MeasurementModel(input);
            }
        });
        ArrayList<String> categories = new ArrayList<String>();
        CommercialSpeciesModel parent = (CommercialSpeciesModel)model.getParent();
        CategoryModel cat1 = parent.getCategory1();
        categories.add(cat1 != null ? cat1.getLabel() : null);
        CategoryModel cat2 = parent.getCategory2();
        categories.add(cat2 != null ? cat2.getLabel() : null);
        CategoryModel cat3 = parent.getCategory3();
        categories.add(cat3 != null ? cat3.getLabel() : null);
        JSONArray jsonMeasurements = new JSONArray();
        for (MeasurementModel measurement : measurements) {
            JSONObject jsonMeasurement = JsonExporter.createJSONMeasurementModel(measurement, categories);
            jsonMeasurements.put((Object)jsonMeasurement);
        }
        jsonScientificSpeciesModel.put("observations", (Object)jsonMeasurements);
        cursor.close();
        cursor = soh.getAllCategoryWeigths(model.getId());
        List<CategoryWeightModel> categoryWeights = WloSqlOpenHelper.transformCursorIntoCollection(cursor, new Function<Cursor, CategoryWeightModel>(){

            public CategoryWeightModel apply(Cursor input) {
                return new CategoryWeightModel(input);
            }
        });
        JSONArray jsonCategoryWeightModels = new JSONArray();
        for (CategoryWeightModel categoryWeight : categoryWeights) {
            JSONObject jsonCategoryWeightModel = JsonExporter.createJSONCategoryWeightModel(categoryWeight, categories);
            jsonCategoryWeightModels.put((Object)jsonCategoryWeightModel);
        }
        jsonScientificSpeciesModel.put("poids-par-categorie", (Object)jsonCategoryWeightModels);
        cursor.close();
        return jsonScientificSpeciesModel;
    }

    public static JSONObject createJSONMeasurementModel(MeasurementModel model, List<String> categories) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        JSONObject jsonMeasurementModel = new JSONObject();
        for (int i = 0; i < categories.size(); ++i) {
            String categoryLabel = categories.get(i);
            if (categoryLabel == null) continue;
            String measurementCategory = null;
            switch (i) {
                case 0: {
                    measurementCategory = model.getCategory1();
                    break;
                }
                case 1: {
                    measurementCategory = model.getCategory2();
                    break;
                }
                case 2: {
                    measurementCategory = model.getCategory3();
                }
            }
            if (measurementCategory == null) continue;
            QualitativeValueModel value = qualitativeValuesById.get(measurementCategory);
            if (value == null) {
                jsonMeasurementModel.put(categoryLabel, (Object)measurementCategory);
                continue;
            }
            JSONObject jsonCategory = new JSONObject();
            jsonCategory.put("code", (Object)value.getValue());
            jsonCategory.put("libell\u00e9", (Object)value.getLabel());
            jsonMeasurementModel.put(categoryLabel, (Object)jsonCategory);
        }
        jsonMeasurementModel.put("taille", (Object)model.getSize());
        jsonMeasurementModel.put("date", (Object)UIUtils.UTC_DATE_FORMAT.format(model.getDate().getTime()));
        return jsonMeasurementModel;
    }

    public static JSONObject createJSONCategoryWeightModel(CategoryWeightModel model, List<String> categories) throws JSONException {
        Preconditions.checkNotNull((Object)model);
        JSONObject jsonCategoryWeightModel = new JSONObject();
        for (int i = 0; i < categories.size(); ++i) {
            String categoryLabel = categories.get(i);
            if (categoryLabel == null) continue;
            String measurementCategory = null;
            switch (i) {
                case 0: {
                    measurementCategory = model.getCategory1();
                    break;
                }
                case 1: {
                    measurementCategory = model.getCategory2();
                    break;
                }
                case 2: {
                    measurementCategory = model.getCategory3();
                }
            }
            if (measurementCategory == null) continue;
            QualitativeValueModel value = qualitativeValuesById.get(measurementCategory);
            if (value == null) {
                jsonCategoryWeightModel.put(categoryLabel, (Object)measurementCategory);
                continue;
            }
            JSONObject jsonCategory = new JSONObject();
            jsonCategory.put("code", (Object)value.getValue());
            jsonCategory.put("libell\u00e9", (Object)value.getLabel());
            jsonCategoryWeightModel.put(categoryLabel, (Object)jsonCategory);
        }
        jsonCategoryWeightModel.put("poids", (Object)model.getWeight());
        return jsonCategoryWeightModel;
    }

    public static JSONObject createJSONLocation(Location location) throws JSONException {
        if (location == null) {
            return null;
        }
        JSONObject jsonLocation = new JSONObject();
        jsonLocation.put("type", (Object)location.getTypeLabel());
        jsonLocation.put("code", (Object)location.getCode());
        jsonLocation.put("libell\u00e9", (Object)location.getLabel());
        return jsonLocation;
    }

    public static JSONObject createJSONMetier(Metier metier) throws JSONException {
        if (metier == null) {
            return null;
        }
        JSONObject jsonMetier = new JSONObject();
        jsonMetier.put("id", (Object)metier.getId());
        jsonMetier.put("code", (Object)metier.getCode());
        jsonMetier.put("libell\u00e9", (Object)metier.getLabel());
        jsonMetier.put("engin-code", (Object)metier.getGearCode());
        jsonMetier.put("engin-libell\u00e9", (Object)metier.getGearLabel());
        jsonMetier.put("espece-code", (Object)metier.getSpeciesCode());
        jsonMetier.put("espece-libell\u00e9", (Object)metier.getSpeciesLabel());
        jsonMetier.put("p\u00eache", metier.getFishing());
        jsonMetier.put("actif", metier.getActive());
        return jsonMetier;
    }

    public static JSONObject createJSONCommercialSpecies(CommercialSpecies commercialSpecies) throws JSONException {
        if (commercialSpecies == null) {
            return null;
        }
        JSONObject jsonCommercialSpecies = new JSONObject();
        jsonCommercialSpecies.put("code", (Object)commercialSpecies.getCode());
        jsonCommercialSpecies.put("isscap", (Object)commercialSpecies.getIsscap());
        jsonCommercialSpecies.put("code-taxon", (Object)commercialSpecies.getTaxonCode());
        jsonCommercialSpecies.put("libell\u00e9-scientifique", (Object)commercialSpecies.getScientificLabel());
        jsonCommercialSpecies.put("libell\u00e9-fran\u00e7ais", (Object)commercialSpecies.getFrenchLabel());
        jsonCommercialSpecies.put("famille", (Object)commercialSpecies.getFamily());
        jsonCommercialSpecies.put("ordre", (Object)commercialSpecies.getSpeciesOrder());
        jsonCommercialSpecies.put("actif", commercialSpecies.getActive());
        return jsonCommercialSpecies;
    }

    public static JSONObject createJSONMensuration(Mensuration mensuration) throws JSONException {
        if (mensuration == null) {
            return null;
        }
        JSONObject jsonMensuration = new JSONObject();
        jsonMensuration.put("code", (Object)mensuration.getCode());
        jsonMensuration.put("libell\u00e9", (Object)mensuration.getLabel());
        return jsonMensuration;
    }

    public static JSONObject createJSONState(State state) throws JSONException {
        if (state == null) {
            return null;
        }
        JSONObject jsonState = new JSONObject();
        jsonState.put("code", (Object)state.getCode());
        jsonState.put("libell\u00e9", (Object)state.getLabel());
        return jsonState;
    }

    public static JSONObject createJSONPresentation(Presentation presentation) throws JSONException {
        if (presentation == null) {
            return null;
        }
        JSONObject jsonPresentation = new JSONObject();
        jsonPresentation.put("code", (Object)presentation.getCode());
        jsonPresentation.put("libell\u00e9", (Object)presentation.getLabel());
        return jsonPresentation;
    }

    public static JSONObject createJSONScientificSpecies(ScientificSpecies scientificSpecies) throws JSONException {
        if (scientificSpecies == null) {
            return null;
        }
        JSONObject jsonScientificSpecies = new JSONObject();
        jsonScientificSpecies.put("code", (Object)scientificSpecies.getCode());
        jsonScientificSpecies.put("libell\u00e9", (Object)scientificSpecies.getLabel());
        jsonScientificSpecies.put("perm-code", (Object)scientificSpecies.getPermCode());
        return jsonScientificSpecies;
    }
}

