/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models.referentials;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.referentials.HasCode;
import fr.ifremer.wlo.utils.UIUtils;

public class Mensuration
extends BaseModel
implements HasCode {
    private static final String TAG = "Mensuration";
    public static final String TABLE_NAME = "ref_mensurations";
    public static final String COLUMN_CODE = "code";
    public static final String COLUMN_LABEL = "label";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "code", "label"};
    protected String code;
    protected String label;

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public Mensuration() {
    }

    public Mensuration(Cursor cursor) {
        super(cursor);
        this.code = cursor.getString(1);
        this.label = cursor.getString(2);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.label, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_CODE, this.code);
        this.putValue(value, COLUMN_LABEL, this.label);
        return value;
    }

    public static enum Precision {
        CM1(10, 10, "1 cm"),
        MM5(5, 10, "0.5 cm"),
        MM1(1, 1, "1 mm");

        private int value;
        private int unitDivider;
        private String label;

        private Precision(int value, int unitDivider, String label) {
            this.value = value;
            this.unitDivider = unitDivider;
            this.label = label;
        }

        public int getValue() {
            return this.value;
        }

        public int getUnitDivider() {
            return this.unitDivider;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        public boolean isDecimal() {
            return this.value % this.unitDivider > 0;
        }
    }
}

