/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;

public class ScientificSpeciesModel
extends HierarchicalModel<CommercialSpeciesModel> {
    private static final String TAG = "ScientificSpecies";
    public static final String TABLE_NAME = "scientific_species";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_TAKING_ACTIVATION = "takingActivation";
    public static final String COLUMN_COMMENT = "comment";
    public static final String COLUMN_SORTED_WEIGHT = "sortedWeight";
    public static final String COLUMN_SAMPLE_WEIGHT = "sampleWeight";
    public static final String COLUMN_COMMERCIAL_SPECIES_ID = "commercialSpeciesId";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "name", "takingActivation", "comment", "sortedWeight", "sampleWeight", "commercialSpeciesId"};
    protected ScientificSpecies name;
    protected boolean takingActivation;
    protected String comment;
    protected Integer sortedWeight;
    protected Integer sampleWeight;
    protected Map<Triple<String, String, String>, Integer> categoryWeights;

    public ScientificSpeciesModel() {
    }

    public ScientificSpeciesModel(Context context, Cursor cursor) {
        super(cursor);
        String nameId = cursor.getString(1);
        this.name = DataCache.getScientificSpeciesById(context, nameId);
        this.takingActivation = cursor.getShort(2) > 0;
        this.comment = cursor.getString(3);
        if (!cursor.isNull(4)) {
            this.sortedWeight = cursor.getInt(4);
        }
        if (!cursor.isNull(5)) {
            this.sampleWeight = cursor.getInt(5);
        }
    }

    public ScientificSpecies getName() {
        return this.name;
    }

    public void setName(ScientificSpecies name) {
        ScientificSpecies oldValue = this.name;
        this.name = name;
        this.firePropertyChange(COLUMN_NAME, oldValue, name);
    }

    public boolean isTakingActivation() {
        return this.takingActivation;
    }

    public void setTakingActivation(boolean takingActivation) {
        Boolean oldValue = this.takingActivation;
        this.takingActivation = takingActivation;
        this.firePropertyChange(COLUMN_TAKING_ACTIVATION, oldValue, takingActivation);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(COLUMN_COMMENT, oldValue, comment);
    }

    public Integer getSortedWeight() {
        return this.sortedWeight;
    }

    public void setSortedWeight(Integer sortedWeight) {
        Integer oldValue = this.sortedWeight;
        this.sortedWeight = sortedWeight;
        this.firePropertyChange(COLUMN_SORTED_WEIGHT, oldValue, sortedWeight);
    }

    public Integer getSampleWeight() {
        return this.sampleWeight;
    }

    public void setSampleWeight(Integer sampleWeight) {
        Integer oldValue = this.sampleWeight;
        this.sampleWeight = sampleWeight;
        this.firePropertyChange(COLUMN_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    public Map<Triple<String, String, String>, Integer> getCategoryWeights() {
        return this.categoryWeights;
    }

    public void setCategoryWeights(Map<Triple<String, String, String>, Integer> categoryWeights) {
        this.categoryWeights = categoryWeights;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.name, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_NAME, this.name != null ? this.name.getId() : null);
        this.putValue(value, COLUMN_TAKING_ACTIVATION, this.takingActivation ? 1 : 0);
        this.putValue(value, COLUMN_COMMENT, this.comment);
        this.putValue(value, COLUMN_SORTED_WEIGHT, this.sortedWeight);
        this.putValue(value, COLUMN_SAMPLE_WEIGHT, this.sampleWeight);
        this.putValue(value, COLUMN_COMMERCIAL_SPECIES_ID, this.getParentId());
        return value;
    }
}

