/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.models.referentials.Metier;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.UIUtils;

public class MetierModel
extends HierarchicalModel<VesselModel> {
    private static final String TAG = "Metier";
    public static final String TABLE_NAME = "metiers";
    public static final String COLUMN_GEAR_SPECIES = "gearSpecies";
    public static final String COLUMN_ZONE = "zone";
    public static final String COLUMN_SAMPLE_ROW_CODE = "sampleRowCode";
    public static final String COLUMN_COMMENT = "comment";
    public static final String COLUMN_VESSEL_ID = "vesselId";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "gearSpecies", "zone", "sampleRowCode", "comment", "vesselId"};
    protected Metier gearSpecies;
    protected String zone;
    protected String sampleRowCode;
    protected String comment;

    public MetierModel() {
    }

    public MetierModel(Context context, Cursor cursor) {
        super(cursor);
        String gearSpeciesId = cursor.getString(1);
        this.gearSpecies = DataCache.getMetierById(context, gearSpeciesId);
        this.zone = cursor.getString(2);
        this.sampleRowCode = cursor.getString(3);
        this.comment = cursor.getString(4);
    }

    public Metier getGearSpecies() {
        return this.gearSpecies;
    }

    public void setGearSpecies(Metier gearSpecies) {
        Metier oldValue = this.gearSpecies;
        this.gearSpecies = gearSpecies;
        this.firePropertyChange(COLUMN_GEAR_SPECIES, oldValue, gearSpecies);
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        String oldValue = this.zone;
        this.zone = zone;
        this.firePropertyChange(COLUMN_ZONE, oldValue, zone);
    }

    public String getSampleRowCode() {
        return this.sampleRowCode;
    }

    public void setSampleRowCode(String sampleRowCode) {
        String oldValue = this.sampleRowCode;
        this.sampleRowCode = sampleRowCode;
        this.firePropertyChange(COLUMN_SAMPLE_ROW_CODE, oldValue, sampleRowCode);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(COLUMN_COMMENT, oldValue, comment);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.gearSpecies, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_GEAR_SPECIES, this.gearSpecies != null ? this.gearSpecies.getId() : null);
        this.putValue(value, COLUMN_ZONE, this.zone);
        this.putValue(value, COLUMN_SAMPLE_ROW_CODE, this.sampleRowCode);
        this.putValue(value, COLUMN_COMMENT, this.comment);
        this.putValue(value, COLUMN_VESSEL_ID, this.getParentId());
        return value;
    }
}

