/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Calendar;

public class MeasurementModel
extends HierarchicalModel<ScientificSpeciesModel> {
    private static final String TAG = "MeasurementModel";
    public static final String TABLE_NAME = "measurements";
    public static final String COLUMN_SIZE = "size";
    public static final String COLUMN_DATE = "date";
    public static final String COLUMN_CATEGORY_1 = "category1";
    public static final String COLUMN_CATEGORY_2 = "category2";
    public static final String COLUMN_CATEGORY_3 = "category3";
    public static final String COLUMN_SCIENTIFIC_SPECIES_ID = "scientificSpeciesId";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "size", "date", "category1", "category2", "category3", "scientificSpeciesId"};
    protected Integer size;
    protected Calendar date;
    protected String category1;
    protected String category2;
    protected String category3;

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public MeasurementModel() {
    }

    public MeasurementModel(Cursor cursor) {
        super(cursor);
        this.size = cursor.getInt(1);
        this.date = UIUtils.getCalendarFromCursor(cursor, 2);
        this.category1 = cursor.getString(3);
        this.category2 = cursor.getString(4);
        this.category3 = cursor.getString(5);
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        Integer oldValue = this.size;
        this.size = size;
        this.firePropertyChange(COLUMN_SIZE, oldValue, size);
    }

    public void incSize(int inc) {
        if (this.size != null) {
            this.setSize(this.size + inc);
        }
    }

    public void decSize(int dec) {
        if (this.size != null) {
            this.setSize(this.size - dec);
        }
    }

    public void roundSize(Mensuration.Precision precision) {
        if (this.size == null) {
            return;
        }
        int precisionValue = precision.getValue();
        int roundedSize = this.size / precisionValue * precisionValue;
        this.setSize(roundedSize);
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setDate(Calendar date) {
        Calendar oldValue = this.date;
        this.date = date;
        this.firePropertyChange(COLUMN_DATE, oldValue, date);
    }

    public String getCategory1() {
        return this.category1;
    }

    public void setCategory1(String category1) {
        String oldValue = this.category1;
        this.category1 = category1;
        this.firePropertyChange(COLUMN_CATEGORY_1, oldValue, category1);
    }

    public String getCategory2() {
        return this.category2;
    }

    public void setCategory2(String category2) {
        String oldValue = this.category2;
        this.category2 = category2;
        this.firePropertyChange(COLUMN_CATEGORY_2, oldValue, category2);
    }

    public String getCategory3() {
        return this.category3;
    }

    public void setCategory3(String category3) {
        String oldValue = this.category3;
        this.category3 = category3;
        this.firePropertyChange(COLUMN_CATEGORY_3, oldValue, category3);
    }

    public String toString(Context context, Mensuration.Precision precision) {
        String dateFormat = UIUtils.getDateFormat(context) + " " + context.getString(2131427375);
        String result = String.format(dateFormat, this.date);
        result = result + " - " + UIUtils.getFormattedSize(this.size, precision);
        return result;
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_SIZE, this.size);
        this.putValue(value, COLUMN_DATE, this.date != null ? Long.valueOf(this.date.getTimeInMillis()) : null);
        this.putValue(value, COLUMN_CATEGORY_1, this.category1);
        this.putValue(value, COLUMN_CATEGORY_2, this.category2);
        this.putValue(value, COLUMN_CATEGORY_3, this.category3);
        this.putValue(value, COLUMN_SCIENTIFIC_SPECIES_ID, this.getParentId());
        return value;
    }
}

