/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.ContextModel;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.referentials.Location;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Calendar;
import java.util.Set;

public class LocationModel
extends HierarchicalModel<ContextModel> {
    private static final String TAG = "Location";
    public static final String TABLE_NAME = "locations";
    public static final String COLUMN_OPERATOR = "operator";
    public static final String COLUMN_START_DATE = "startDate";
    public static final String COLUMN_END_DATE = "endDate";
    public static final String COLUMN_LOCATION = "location";
    public static final String COLUMN_COMMENT = "comment";
    public static final String COLUMN_CONTEXT_ID = "contextId";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "operator", "startDate", "endDate", "location", "comment", "contextId"};
    protected String operator;
    protected Calendar startDate;
    protected Calendar endDate;
    protected Location location;
    protected String comment;

    public LocationModel() {
    }

    public LocationModel(Context context, Cursor cursor) {
        super(cursor);
        this.operator = cursor.getString(1);
        this.startDate = UIUtils.getCalendarFromCursor(cursor, 2);
        this.endDate = UIUtils.getCalendarFromCursor(cursor, 3);
        String locationId = cursor.getString(4);
        this.location = DataCache.getLocationById(context, locationId);
        this.comment = cursor.getString(5);
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        String oldValue = this.operator;
        this.operator = operator;
        this.firePropertyChange(COLUMN_OPERATOR, oldValue, operator);
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        Calendar oldValue = this.startDate;
        this.startDate = startDate;
        this.firePropertyChange(COLUMN_START_DATE, oldValue, startDate);
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        Calendar oldValue = this.endDate;
        this.endDate = endDate;
        this.firePropertyChange(COLUMN_END_DATE, oldValue, endDate);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        Location oldValue = this.location;
        this.location = location;
        this.firePropertyChange(COLUMN_LOCATION, oldValue, location);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(COLUMN_COMMENT, oldValue, comment);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.location, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_OPERATOR, this.operator);
        this.putValue(value, COLUMN_START_DATE, this.startDate != null ? Long.valueOf(this.startDate.getTimeInMillis()) : null);
        this.putValue(value, COLUMN_END_DATE, this.endDate != null ? Long.valueOf(this.endDate.getTimeInMillis()) : null);
        this.putValue(value, COLUMN_LOCATION, this.location != null ? this.location.getId() : null);
        this.putValue(value, COLUMN_COMMENT, this.comment);
        this.putValue(value, COLUMN_CONTEXT_ID, this.getParentId());
        return value;
    }

    @Override
    public Set<String> getRequiredFields() {
        Set<String> result = super.getRequiredFields();
        result.add(COLUMN_LOCATION);
        return result;
    }
}

