/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.referentials.CommercialSpecies;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.models.referentials.Presentation;
import fr.ifremer.wlo.models.referentials.State;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.Set;

public class CommercialSpeciesModel
extends HierarchicalModel<MetierModel> {
    private static final String TAG = "CommercialSpecies";
    public static final String TABLE_NAME = "commercial_species";
    public static final String COLUMN_FAO_CODE = "faoCode";
    public static final String COLUMN_MEASUREMENT_METHOD = "measurementMethod";
    public static final String COLUMN_PRECISION = "precision";
    public static final String COLUMN_SPECIES_MIX = "speciesMix";
    public static final String COLUMN_SORT_CATEGORY = "sortCategory";
    public static final String COLUMN_STATE = "state";
    public static final String COLUMN_PRESENTATION = "presentation";
    public static final String COLUMN_CATEGORY1 = "category1";
    public static final String COLUMN_CATEGORY2 = "category2";
    public static final String COLUMN_CATEGORY3 = "category3";
    public static final String COLUMN_COMMENT = "comment";
    public static final String COLUMN_TOTAL_UNLOADED_WEIGHT = "totalUnloadedWeight";
    public static final String COLUMN_METIER_ID = "metierId";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "faoCode", "measurementMethod", "precision", "speciesMix", "sortCategory", "state", "presentation", "category1", "category2", "category3", "comment", "totalUnloadedWeight", "metierId"};
    protected CommercialSpecies faoCode;
    protected Mensuration measurementMethod;
    protected Mensuration.Precision precision = Mensuration.Precision.CM1;
    protected boolean speciesMix;
    protected String sortCategory;
    protected State state;
    protected Presentation presentation;
    protected CategoryModel category1;
    protected CategoryModel category2;
    protected CategoryModel category3;
    protected String comment;
    protected Integer totalUnloadedWeight;

    public CommercialSpeciesModel() {
    }

    public CommercialSpeciesModel(Context context, Cursor cursor) {
        super(cursor);
        String faoCodeId = cursor.getString(1);
        this.faoCode = DataCache.getCommercialSpeciesById(context, faoCodeId);
        String measurementMethodId = cursor.getString(2);
        this.measurementMethod = DataCache.getMensurationById(context, measurementMethodId);
        this.precision = Mensuration.Precision.valueOf(cursor.getString(3));
        this.speciesMix = cursor.getShort(4) > 0;
        this.sortCategory = cursor.getString(5);
        String stateId = cursor.getString(6);
        this.state = DataCache.getStateById(context, stateId);
        String presentationId = cursor.getString(7);
        this.presentation = DataCache.getPresentationById(context, presentationId);
        String category1Id = cursor.getString(8);
        this.category1 = DataCache.getCategoryById(context, category1Id);
        String category2Id = cursor.getString(9);
        this.category2 = DataCache.getCategoryById(context, category2Id);
        String category3Id = cursor.getString(10);
        this.category3 = DataCache.getCategoryById(context, category3Id);
        this.comment = cursor.getString(11);
        if (!cursor.isNull(12)) {
            this.totalUnloadedWeight = cursor.getInt(12);
        }
    }

    public CommercialSpecies getFaoCode() {
        return this.faoCode;
    }

    public void setFaoCode(CommercialSpecies faoCode) {
        CommercialSpecies oldValue = this.faoCode;
        this.faoCode = faoCode;
        this.firePropertyChange(COLUMN_FAO_CODE, oldValue, faoCode);
    }

    public Mensuration getMeasurementMethod() {
        return this.measurementMethod;
    }

    public void setMeasurementMethod(Mensuration measurementMethod) {
        Mensuration oldValue = this.measurementMethod;
        this.measurementMethod = measurementMethod;
        this.firePropertyChange(COLUMN_MEASUREMENT_METHOD, oldValue, measurementMethod);
    }

    public Mensuration.Precision getPrecision() {
        return this.precision;
    }

    public void setPrecision(Mensuration.Precision precision) {
        Mensuration.Precision oldValue = this.precision;
        this.precision = precision;
        this.firePropertyChange(COLUMN_PRECISION, (Object)oldValue, (Object)precision);
    }

    public boolean isSpeciesMix() {
        return this.speciesMix;
    }

    public void setSpeciesMix(boolean speciesMix) {
        boolean oldValue = this.speciesMix;
        this.speciesMix = speciesMix;
        this.firePropertyChange(COLUMN_SPECIES_MIX, oldValue, speciesMix);
    }

    public String getSortCategory() {
        return this.sortCategory;
    }

    public void setSortCategory(String sortCategory) {
        String oldValue = this.sortCategory;
        this.sortCategory = sortCategory;
        this.firePropertyChange(COLUMN_SORT_CATEGORY, oldValue, sortCategory);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        State oldValue = this.state;
        this.state = state;
        this.firePropertyChange(COLUMN_STATE, oldValue, state);
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public void setPresentation(Presentation presentation) {
        String oldValue = this.id;
        this.presentation = presentation;
        this.firePropertyChange("_id", oldValue, this.id);
    }

    public CategoryModel getCategory1() {
        return this.category1;
    }

    public void setCategory1(CategoryModel category1) {
        this.category1 = category1;
    }

    public CategoryModel getCategory2() {
        return this.category2;
    }

    public void setCategory2(CategoryModel category2) {
        this.category2 = category2;
    }

    public CategoryModel getCategory3() {
        return this.category3;
    }

    public void setCategory3(CategoryModel category3) {
        this.category3 = category3;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(COLUMN_COMMENT, oldValue, comment);
    }

    public Integer getTotalUnloadedWeight() {
        return this.totalUnloadedWeight;
    }

    public void setTotalUnloadedWeight(Integer totalUnloadedWeight) {
        Integer oldValue = this.totalUnloadedWeight;
        this.totalUnloadedWeight = totalUnloadedWeight;
        this.firePropertyChange(COLUMN_TOTAL_UNLOADED_WEIGHT, oldValue, totalUnloadedWeight);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.faoCode, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_FAO_CODE, this.faoCode != null ? this.faoCode.getId() : null);
        this.putValue(value, COLUMN_MEASUREMENT_METHOD, this.measurementMethod != null ? this.measurementMethod.getId() : null);
        this.putValue(value, COLUMN_PRECISION, this.precision.name());
        this.putValue(value, COLUMN_SPECIES_MIX, this.speciesMix ? 1 : 0);
        this.putValue(value, COLUMN_SORT_CATEGORY, this.sortCategory);
        this.putValue(value, COLUMN_STATE, this.state != null ? this.state.getId() : null);
        this.putValue(value, COLUMN_PRESENTATION, this.presentation != null ? this.presentation.getId() : null);
        this.putValue(value, COLUMN_CATEGORY1, this.category1 != null ? this.category1.getId() : null);
        this.putValue(value, COLUMN_CATEGORY2, this.category2 != null ? this.category2.getId() : null);
        this.putValue(value, COLUMN_CATEGORY3, this.category3 != null ? this.category3.getId() : null);
        this.putValue(value, COLUMN_COMMENT, this.comment);
        this.putValue(value, COLUMN_TOTAL_UNLOADED_WEIGHT, this.totalUnloadedWeight);
        this.putValue(value, COLUMN_METIER_ID, this.getParentId());
        return value;
    }

    @Override
    public Set<String> getRequiredFields() {
        Set<String> result = super.getRequiredFields();
        result.add(COLUMN_FAO_CODE);
        result.add(COLUMN_MEASUREMENT_METHOD);
        result.add(COLUMN_PRECISION);
        return result;
    }
}

