/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.measurement;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.TreeMap;

public class TableAdapter
extends BaseAdapter {
    private static final String TAG = "TableAdapter";
    protected TreeMap<Integer, Integer> data = new TreeMap();
    protected Context context;
    protected Mensuration.Precision precision;

    public TableAdapter(Context context, Mensuration.Precision precision) {
        this.context = context;
        this.precision = precision;
    }

    public int getCount() {
        return this.data.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.data.size()) {
            return null;
        }
        return this.data.keySet().toArray()[position];
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(2130903083, null);
            viewHolder = new ViewHolder();
            viewHolder.sizeText = (TextView)convertView.findViewById(2131099787);
            viewHolder.nbText = (TextView)convertView.findViewById(2131099788);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        Integer size = (Integer)this.getItem(position);
        viewHolder.sizeText.setText((CharSequence)UIUtils.getFormattedSize(size, this.precision));
        viewHolder.nbText.setText((CharSequence)String.valueOf(this.data.get(size)));
        int color2 = position % 2 == 0 ? 2131230723 : 17170444;
        convertView.setBackgroundResource(color2);
        return convertView;
    }

    public void set(int size, int nb) {
        if (nb == 0) {
            this.data.remove(size);
        } else {
            this.data.put(size, nb);
        }
        this.notifyDataSetChanged();
    }

    static class ViewHolder {
        TextView sizeText;
        TextView nbText;

        ViewHolder() {
        }
    }
}

