/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.imports;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.imports.WloAbstractImportExportModel;
import fr.ifremer.wlo.models.referentials.CalcifiedPartTaking;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import java.util.Collection;
import java.util.Map;
import org.nuiton.csv.ValueGetterSetter;

public class CalcifiedPartTakingRowModel
extends WloAbstractImportExportModel<CalcifiedPartTaking> {
    private static final String TAG = "CalcifiedPartTakingRowModel";

    public CalcifiedPartTakingRowModel(char separator, Collection<ScientificSpecies> scientificSpecies) {
        super(separator);
        ImmutableMap scientificSpeciesByCode = Maps.uniqueIndex(scientificSpecies, (Function)new Function<ScientificSpecies, String>(){

            public String apply(ScientificSpecies input) {
                return input.getCode();
            }
        });
        this.newColumnForImportExport("Espece_scientifique", (ValueGetterSetter)new ValueGetterSetter<CalcifiedPartTaking, String>((Map)scientificSpeciesByCode){
            final /* synthetic */ Map val$scientificSpeciesByCode;
            {
                this.val$scientificSpeciesByCode = map;
            }

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                ScientificSpecies species = (ScientificSpecies)this.val$scientificSpeciesByCode.get(value);
                object.setParent(species);
            }

            public String get(CalcifiedPartTaking object) throws Exception {
                return object.getParentId();
            }
        });
        this.newColumnForImportExport("Classe_debut", (ValueGetterSetter)new ValueGetterSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                object.setStartSize(size);
            }

            public String get(CalcifiedPartTaking object) throws Exception {
                return String.valueOf(object.getStartSize());
            }
        });
        this.newColumnForImportExport("Classe_fin", (ValueGetterSetter)new ValueGetterSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                object.setEndSize(size);
            }

            public String get(CalcifiedPartTaking object) throws Exception {
                return String.valueOf(object.getEndSize());
            }
        });
        this.newColumnForImportExport("Pas_de_classe", (ValueGetterSetter)new ValueGetterSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                object.setSizeStep(size);
            }

            public String get(CalcifiedPartTaking object) throws Exception {
                return String.valueOf(object.getSizeStep());
            }
        });
        this.newColumnForImportExport("Pas", (ValueGetterSetter)new ValueGetterSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size = Integer.parseInt(value);
                object.setStep(size);
            }

            public String get(CalcifiedPartTaking object) throws Exception {
                return String.valueOf(object.getStep());
            }
        });
        this.newColumnForImportExport("Arret", (ValueGetterSetter)new ValueGetterSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                object.setStop(size);
            }

            public String get(CalcifiedPartTaking object) throws Exception {
                return String.valueOf(object.getStop());
            }
        });
    }

    public CalcifiedPartTaking newEmptyInstance() {
        return new CalcifiedPartTaking();
    }
}

