/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import fr.ifremer.wlo.BigFinCommunicationService;

public abstract class WloBaseActivity
extends ActionBarActivity
implements ServiceConnection {
    private static final String TAG = "WloBaseActivity";
    protected Messenger mServiceMessenger = null;
    protected Messenger mMessenger = null;
    protected DownloadManager downloadManager;
    protected static Long downloadingApkId = null;
    protected final BroadcastReceiver downloadReceiver = new BroadcastReceiver(){

        public void onReceive(Context arg0, Intent arg1) {
            DownloadManager.Query query = new DownloadManager.Query();
            query.setFilterById(new long[]{downloadingApkId});
            Cursor cursor = WloBaseActivity.this.downloadManager.query(query);
            if (cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex("status");
                int status = cursor.getInt(columnIndex);
                int columnReason = cursor.getColumnIndex("reason");
                int reason = cursor.getInt(columnReason);
                if (status == 8) {
                    Uri uri = WloBaseActivity.this.downloadManager.getUriForDownloadedFile(downloadingApkId.longValue());
                    Intent promptInstall = new Intent("android.intent.action.VIEW").setDataAndType(uri, "application/vnd.android.package-archive");
                    WloBaseActivity.this.startActivity(promptInstall);
                } else if (status == 16) {
                    Toast.makeText((Context)WloBaseActivity.this, (int)2131427525, (int)1).show();
                }
                downloadingApkId = null;
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.downloadManager = (DownloadManager)this.getSystemService("download");
        Integer viewId = this.getContentView();
        if (viewId != null) {
            this.setContentView(viewId);
        }
        ActionBar actionBar = this.getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(this.getUpActivity() != null);
    }

    protected void onStart() {
        super.onStart();
        this.bindService(new Intent((Context)this, BigFinCommunicationService.class), this, 1);
    }

    protected void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE");
        this.registerReceiver(this.downloadReceiver, intentFilter);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.downloadReceiver);
    }

    protected void onStop() {
        super.onStop();
        this.doUnbindService();
    }

    protected void doUnbindService() {
        if (this.mServiceMessenger != null && this.mMessenger != null) {
            try {
                Message msg = Message.obtain(null, (int)2);
                msg.replyTo = this.mMessenger;
                this.mServiceMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error while sending data to the service");
            }
        }
        this.unbindService(this);
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.mServiceMessenger = new Messenger(service);
        if (this.mMessenger != null) {
            try {
                Message msg = Message.obtain(null, (int)1);
                msg.replyTo = this.mMessenger;
                this.mServiceMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error while sending data to the service");
            }
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.mServiceMessenger = null;
    }

    public void cancel(View view) {
        this.setResult(0);
        this.finish();
    }

    protected abstract Integer getContentView();

    protected abstract Class<? extends WloBaseActivity> getUpActivity();

    public Intent getSupportParentActivityIntent() {
        Class<? extends WloBaseActivity> upClass = this.getUpActivity();
        if (upClass == null) {
            return super.getSupportParentActivityIntent();
        }
        Intent intent = new Intent((Context)this, upClass);
        return intent;
    }

    public static Long getDownloadingApkId() {
        return downloadingApkId;
    }

    public static void setDownloadingApkId(Long downloadingApkId) {
        WloBaseActivity.downloadingApkId = downloadingApkId;
    }
}

