/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.DeviceListActivity;
import fr.ifremer.wlo.utils.BigFinFeedReaderRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;

public class BigFinCommunicationService
extends Service {
    private static final String TAG = "BigFinCommunicationService";
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
    private static final int NOIFICATION_ID = 42;
    public static final int STATE_NONE = 0;
    public static final int STATE_LISTEN = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_CONNECTION_LOST = 5;
    public static final int MESSAGE_CONNECTION_FAILED = 6;
    public static final int MESSAGE_REGISTER_CLIENT = 1;
    public static final int MESSAGE_UNREGISTER_CLIENT = 2;
    public static final int MESSAGE_CONNECT_DEVICE = 3;
    public static final int MESSAGE_SEND_DATA = 4;
    public static final int MESSAGE_DISCONNECT_DEVICE = 5;
    public static final int MESSAGE_CONNECTION_STATE = 7;
    public static final String DEVICE_NAME = "device_name";
    public static final String TOAST = "toast";
    public static final String DEVICE_ADDRESS = "device_address";
    public static final String DATA_TO_SEND = "dataToSend";
    public static final String EXTRA_DISCONNECT = "disconnect";
    protected BluetoothAdapter mAdapter;
    protected AcceptThread mAcceptThread;
    protected ConnectThread mConnectThread;
    protected ConnectedThread mConnectedThread;
    protected int mState;
    protected List<Messenger> mClients = Lists.newArrayList();
    protected final Messenger mMessenger = new Messenger((Handler)new IncomingHandler());
    protected NotificationCompat.Builder notificationBuilder;

    public void onCreate() {
        super.onCreate();
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.notificationBuilder = new NotificationCompat.Builder((Context)this);
        this.setState(0);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.notify(42, this.notificationBuilder.build());
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent.getBooleanExtra(EXTRA_DISCONNECT, false)) {
            if (this.mClients.isEmpty()) {
                this.stopSelf();
            } else {
                this.stop();
            }
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.stop();
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.cancel(42);
    }

    public IBinder onBind(Intent intent) {
        this.startService(intent);
        return this.mMessenger.getBinder();
    }

    public boolean onUnbind(Intent intent) {
        if (this.mState != 3) {
            this.stopSelf();
        }
        return true;
    }

    protected void updateNotification(boolean connected) {
        PendingIntent pendingIntent;
        int icon;
        int text;
        int title;
        if (connected) {
            title = 2131427352;
            text = 2131427353;
            icon = 2130837603;
            Intent intent = new Intent((Context)this, BigFinCommunicationService.class);
            intent.putExtra(EXTRA_DISCONNECT, true);
            pendingIntent = PendingIntent.getService((Context)this, (int)-1, (Intent)intent, (int)0x10000000);
        } else {
            title = 2131427350;
            text = 2131427351;
            icon = 2130837602;
            Intent intent = new Intent((Context)this, DeviceListActivity.class);
            pendingIntent = PendingIntent.getActivity((Context)this, (int)-1, (Intent)intent, (int)0x10000000);
        }
        this.notificationBuilder.setContentTitle(this.getText(title)).setSmallIcon(icon).setContentText(this.getText(text)).setContentIntent(pendingIntent);
        this.startForeground(42, this.notificationBuilder.build());
    }

    protected void sendMessage(int what, int arg1) {
        this.sendMessage(what, arg1, -1, null);
    }

    protected void sendMessage(int what, int arg1, int arg2) {
        this.sendMessage(what, arg1, arg2, null);
    }

    protected void sendMessage(int what, Object obj) {
        this.sendMessage(what, -1, -1, obj);
    }

    protected void sendMessage(int what, int arg1, int arg2, Object obj) {
        for (Messenger messenger : this.mClients) {
            try {
                Message message = Message.obtain(null, (int)what, (int)arg1, (int)arg2, (Object)obj);
                messenger.send(message);
            }
            catch (RemoteException e) {
                this.mClients.remove(messenger);
            }
        }
    }

    protected void sendMessage(int what, String key, String value) {
        for (Messenger messenger : this.mClients) {
            try {
                Message message = Message.obtain(null, (int)what);
                Bundle bundle = new Bundle();
                bundle.putString(key, value);
                message.setData(bundle);
                messenger.send(message);
            }
            catch (RemoteException e) {
                this.mClients.remove(messenger);
            }
        }
    }

    protected synchronized void setState(int state) {
        this.updateNotification(state == 3);
        this.mState = state;
        this.sendMessage(1, state);
    }

    protected synchronized void stop() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
        this.setState(0);
    }

    protected synchronized void reset() {
        this.stop();
        this.setState(1);
        this.mAcceptThread = new AcceptThread();
        this.mAcceptThread.start();
    }

    protected synchronized void connect(BluetoothDevice device) {
        if (this.mState == 2 && this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.setState(2);
        this.setState(3);
    }

    protected synchronized void connected(BluetoothSocket socket, BluetoothDevice device) {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.sendMessage(4, DEVICE_NAME, device.getName());
        this.setState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] out) {
        ConnectedThread r;
        BigFinCommunicationService bigFinCommunicationService = this;
        synchronized (bigFinCommunicationService) {
            if (this.mState != 3) {
                return;
            }
            r = this.mConnectedThread;
        }
        r.write(out);
    }

    protected void connectionFailed() {
        this.sendMessage(6, TOAST, "Unable to connect device");
        this.reset();
    }

    protected void connectionLost() {
        this.sendMessage(5, TOAST, "Device connection was lost");
        this.reset();
    }

    protected class IncomingHandler
    extends Handler {
        protected IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BigFinCommunicationService.this.mClients.add(msg.replyTo);
                    break;
                }
                case 2: {
                    BigFinCommunicationService.this.mClients.remove(msg.replyTo);
                    break;
                }
                case 3: {
                    BigFinCommunicationService.this.reset();
                    String deviceAddress = msg.getData().getString(BigFinCommunicationService.DEVICE_ADDRESS);
                    BluetoothDevice device = BigFinCommunicationService.this.mAdapter.getRemoteDevice(deviceAddress);
                    BigFinCommunicationService.this.connect(device);
                    break;
                }
                case 4: {
                    String dataToSend = msg.getData().getString(BigFinCommunicationService.DATA_TO_SEND);
                    BigFinCommunicationService.this.write(dataToSend.getBytes());
                    break;
                }
                case 5: {
                    BigFinCommunicationService.this.stop();
                    break;
                }
                case 7: {
                    BigFinCommunicationService.this.sendMessage(7, BigFinCommunicationService.this.mState);
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    protected class ConnectedThread
    extends Thread {
        protected final BluetoothSocket mmSocket;
        protected final InputStream mmInStream;
        protected final OutputStream mmOutStream;
        protected boolean stop;

        public ConnectedThread(BluetoothSocket socket) {
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
            this.stop = false;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (!this.stop) {
                try {
                    String result = "";
                    boolean complete = false;
                    while (!complete) {
                        while (this.mmInStream.available() > 0) {
                            int c = this.mmInStream.read();
                            if (c == 64) {
                                complete = true;
                                continue;
                            }
                            result = result + (char)c;
                        }
                    }
                    int lastComma = result.lastIndexOf(44);
                    result = result.substring(0, lastComma);
                    lastComma = result.lastIndexOf(44) + 1;
                    String record = result.substring(0, lastComma);
                    String crc = result.substring(lastComma);
                    BigFinFeedReaderRecord readerRecord = new BigFinFeedReaderRecord(record, crc);
                    BigFinCommunicationService.this.sendMessage(2, readerRecord);
                }
                catch (IOException e) {
                    Log.e((String)BigFinCommunicationService.TAG, (String)"disconnected");
                    BigFinCommunicationService.this.connectionLost();
                }
            }
        }

        public void write(byte[] buffer) {
            try {
                this.mmOutStream.write(buffer);
                BigFinCommunicationService.this.sendMessage(3, buffer);
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"Exception during write", (Throwable)e);
            }
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
            this.stop = true;
        }
    }

    protected class ConnectThread
    extends Thread {
        protected final BluetoothSocket mmSocket;
        protected final BluetoothDevice mmDevice;

        public ConnectThread(BluetoothDevice device) {
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(MY_UUID);
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"Socket create() failed", (Throwable)e);
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("ConnectThread");
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"Error while connecting", (Throwable)e);
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    Log.e((String)BigFinCommunicationService.TAG, (String)"unable to close() socket during connection failure", (Throwable)e2);
                }
                BigFinCommunicationService.this.connectionFailed();
                return;
            }
            BigFinCommunicationService bigFinCommunicationService = BigFinCommunicationService.this;
            synchronized (bigFinCommunicationService) {
                BigFinCommunicationService.this.mConnectThread = null;
            }
            BigFinCommunicationService.this.connected(this.mmSocket, this.mmDevice);
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }

    protected class AcceptThread
    extends Thread {
        private BluetoothServerSocket mmServerSocket;

        public AcceptThread() {
            BluetoothServerSocket tmp = null;
            try {
                tmp = BigFinCommunicationService.this.mAdapter.listenUsingRfcommWithServiceRecord("BigFinBtSocket", MY_UUID);
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"Socket listen() failed", (Throwable)e);
            }
            this.mmServerSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("AcceptThread");
            BluetoothSocket socket = null;
            while (BigFinCommunicationService.this.mState != 3 && this.mmServerSocket != null) {
                try {
                    socket = this.mmServerSocket.accept();
                }
                catch (IOException e) {
                    Log.e((String)BigFinCommunicationService.TAG, (String)"Socket accept() failed");
                    break;
                }
                if (socket == null) continue;
                BigFinCommunicationService bigFinCommunicationService = BigFinCommunicationService.this;
                synchronized (bigFinCommunicationService) {
                    switch (BigFinCommunicationService.this.mState) {
                        case 1: 
                        case 2: {
                            BigFinCommunicationService.this.connected(socket, socket.getRemoteDevice());
                            break;
                        }
                        case 0: 
                        case 3: {
                            try {
                                socket.close();
                                break;
                            }
                            catch (IOException e) {
                                Log.e((String)BigFinCommunicationService.TAG, (String)"Could not close unwanted socket", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }

        public void cancel() {
            try {
                this.mmServerSocket.close();
                this.mmServerSocket = null;
            }
            catch (IOException e) {
                Log.e((String)BigFinCommunicationService.TAG, (String)"Socket close() of server failed", (Throwable)e);
            }
        }
    }
}

