/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils.filechooser;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class FileDialog
extends ListActivity {
    private static final String ITEM_KEY = "key";
    private static final String ITEM_IMAGE = "image";
    private static final String ROOT = "/";
    public static final String START_PATH = "START_PATH";
    public static final String FORMAT_FILTER = "FORMAT_FILTER";
    public static final String RESULT_PATH = "RESULT_PATH";
    public static final String SELECTION_MODE = "SELECTION_MODE";
    public static final String CAN_SELECT_DIR = "CAN_SELECT_DIR";
    private List<String> path = null;
    private TextView myPath;
    private EditText mFileName;
    private ArrayList<HashMap<String, Object>> mList;
    private Button selectButton;
    private LinearLayout layoutSelect;
    private LinearLayout layoutCreate;
    private InputMethodManager inputManager;
    private String parentPath;
    private String currentPath = "/";
    private int selectionMode = 0;
    private String[] formatFilter = null;
    private boolean canSelectDir = false;
    private File selectedFile;
    private HashMap<String, Integer> lastPositions = new HashMap();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setResult(0, this.getIntent());
        this.setContentView(2130903071);
        this.myPath = (TextView)this.findViewById(2131099738);
        this.mFileName = (EditText)this.findViewById(2131099735);
        this.inputManager = (InputMethodManager)this.getSystemService("input_method");
        this.selectButton = (Button)this.findViewById(2131099732);
        this.selectButton.setEnabled(false);
        this.selectButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FileDialog.this.selectedFile != null) {
                    FileDialog.this.getIntent().putExtra(FileDialog.RESULT_PATH, FileDialog.this.selectedFile.getPath());
                    FileDialog.this.setResult(-1, FileDialog.this.getIntent());
                    FileDialog.this.finish();
                }
            }
        });
        Button newButton = (Button)this.findViewById(2131099731);
        newButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileDialog.this.setCreateVisible(v);
                FileDialog.this.mFileName.setText((CharSequence)"");
                FileDialog.this.mFileName.requestFocus();
            }
        });
        this.selectionMode = this.getIntent().getIntExtra(SELECTION_MODE, 0);
        this.formatFilter = this.getIntent().getStringArrayExtra(FORMAT_FILTER);
        this.canSelectDir = this.getIntent().getBooleanExtra(CAN_SELECT_DIR, false);
        if (this.selectionMode == 1) {
            newButton.setVisibility(8);
        }
        this.layoutSelect = (LinearLayout)this.findViewById(2131099730);
        this.layoutCreate = (LinearLayout)this.findViewById(2131099733);
        this.layoutCreate.setVisibility(8);
        Button cancelButton = (Button)this.findViewById(2131099736);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileDialog.this.setSelectVisible(v);
            }
        });
        Button createButton = (Button)this.findViewById(2131099737);
        createButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FileDialog.this.mFileName.getText().length() > 0) {
                    FileDialog.this.getIntent().putExtra(FileDialog.RESULT_PATH, FileDialog.this.currentPath + FileDialog.ROOT + FileDialog.this.mFileName.getText());
                    FileDialog.this.setResult(-1, FileDialog.this.getIntent());
                    FileDialog.this.finish();
                }
            }
        });
        String startPath = this.getIntent().getStringExtra(START_PATH);
        String string2 = startPath = startPath != null ? startPath : ROOT;
        if (this.canSelectDir) {
            File file;
            this.selectedFile = file = new File(startPath);
            this.selectButton.setEnabled(true);
        }
        this.getDir(startPath);
    }

    private void getDir(String dirPath) {
        boolean useAutoSelection = dirPath.length() < this.currentPath.length();
        Integer position = this.lastPositions.get(this.parentPath);
        this.getDirImpl(dirPath);
        if (position != null && useAutoSelection) {
            this.getListView().setSelection(position.intValue());
        }
    }

    private void getDirImpl(String dirPath) {
        this.currentPath = dirPath;
        ArrayList<String> item = new ArrayList<String>();
        this.path = new ArrayList<String>();
        this.mList = new ArrayList();
        File f = new File(this.currentPath);
        File[] files = f.listFiles();
        if (files == null) {
            this.currentPath = ROOT;
            f = new File(this.currentPath);
            files = f.listFiles();
        }
        this.myPath.setText((CharSequence)(this.getText(2131427479) + ": " + this.currentPath));
        if (!this.currentPath.equals(ROOT)) {
            item.add(ROOT);
            this.addItem(ROOT, 2130837596);
            this.path.add(ROOT);
            item.add("../");
            this.addItem("../", 2130837596);
            this.path.add(f.getParent());
            this.parentPath = f.getParent();
        }
        TreeMap<String, String> dirsMap = new TreeMap<String, String>();
        TreeMap<String, String> dirsPathMap = new TreeMap<String, String>();
        TreeMap<String, String> filesMap = new TreeMap<String, String>();
        TreeMap<String, String> filesPathMap = new TreeMap<String, String>();
        for (File file : files) {
            if (file.isDirectory()) {
                String dirName = file.getName();
                dirsMap.put(dirName, dirName);
                dirsPathMap.put(dirName, file.getPath());
                continue;
            }
            String fileName = file.getName();
            String fileNameLwr = fileName.toLowerCase();
            if (this.formatFilter != null) {
                boolean contains = false;
                for (int i = 0; i < this.formatFilter.length; ++i) {
                    String formatLwr = this.formatFilter[i].toLowerCase();
                    if (!fileNameLwr.endsWith(formatLwr)) continue;
                    contains = true;
                    break;
                }
                if (!contains) continue;
                filesMap.put(fileName, fileName);
                filesPathMap.put(fileName, file.getPath());
                continue;
            }
            filesMap.put(fileName, fileName);
            filesPathMap.put(fileName, file.getPath());
        }
        item.addAll(dirsMap.tailMap("").values());
        item.addAll(filesMap.tailMap("").values());
        this.path.addAll(dirsPathMap.tailMap("").values());
        this.path.addAll(filesPathMap.tailMap("").values());
        SimpleAdapter fileList = new SimpleAdapter((Context)this, this.mList, 2130903072, new String[]{ITEM_KEY, ITEM_IMAGE}, new int[]{2131099740, 2131099739});
        for (String dir : dirsMap.tailMap("").values()) {
            this.addItem(dir, 2130837596);
        }
        for (String file : filesMap.tailMap("").values()) {
            this.addItem(file, 2130837595);
        }
        fileList.notifyDataSetChanged();
        this.setListAdapter((ListAdapter)fileList);
    }

    private void addItem(String fileName, int imageId) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(ITEM_KEY, fileName);
        item.put(ITEM_IMAGE, imageId);
        this.mList.add(item);
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        File file = new File(this.path.get(position));
        this.setSelectVisible(v);
        if (file.isDirectory()) {
            this.selectButton.setEnabled(false);
            if (file.canRead()) {
                this.lastPositions.put(this.currentPath, position);
                this.getDir(this.path.get(position));
                if (this.canSelectDir) {
                    this.selectedFile = file;
                    v.setSelected(true);
                    this.selectButton.setEnabled(true);
                }
            } else {
                new AlertDialog.Builder((Context)this).setIcon(2130837598).setTitle((CharSequence)("[" + file.getName() + "] " + this.getText(2131427480))).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
            }
        } else {
            this.selectedFile = file;
            v.setSelected(true);
            this.selectButton.setEnabled(true);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.selectButton.setEnabled(false);
            if (this.layoutCreate.getVisibility() != 0) {
                return super.onKeyDown(keyCode, event);
            }
            this.layoutCreate.setVisibility(8);
            this.layoutSelect.setVisibility(0);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void setCreateVisible(View v) {
        this.layoutCreate.setVisibility(0);
        this.layoutSelect.setVisibility(8);
        this.inputManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
        this.selectButton.setEnabled(false);
    }

    private void setSelectVisible(View v) {
        this.layoutCreate.setVisibility(8);
        this.layoutSelect.setVisibility(0);
        this.inputManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
        this.selectButton.setEnabled(false);
    }
}

