/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ToggleButton;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.utils.WloAutoCompleteTextView;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class WloAutoCompleteTextViewWithFavorites
extends FrameLayout {
    private static final String TAG = "WloAutoCompleteTextViewWithFavorites";
    protected WloAutoCompleteTextView autoCompleteTextView;
    protected ToggleButton toggleButton;

    public WloAutoCompleteTextViewWithFavorites(Context context) {
        super(context);
        this.init(context);
    }

    public WloAutoCompleteTextViewWithFavorites(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WloAutoCompleteTextViewWithFavorites(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    protected void init(Context context) {
        WloAutoCompleteTextViewWithFavorites.inflate((Context)context, (int)2130903063, (ViewGroup)this);
        this.autoCompleteTextView = (WloAutoCompleteTextView)this.findViewById(2131099708);
        this.toggleButton = (ToggleButton)this.findViewById(2131099709);
        this.toggleButton.setChecked(false);
        this.toggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                Log.d((String)WloAutoCompleteTextViewWithFavorites.TAG, (String)("onCheckedChanged " + isChecked));
                String s = WloAutoCompleteTextViewWithFavorites.this.autoCompleteTextView.getText().toString();
                WloAutoCompleteTextViewWithFavorites.this.autoCompleteTextView.setText(null);
                ListAdapter adapter = WloAutoCompleteTextViewWithFavorites.this.autoCompleteTextView.getAdapter();
                if (FavoriteAdapter.class.isAssignableFrom(adapter.getClass())) {
                    FavoriteAdapter favoriteAdapter = (FavoriteAdapter)WloAutoCompleteTextViewWithFavorites.this.autoCompleteTextView.getAdapter();
                    favoriteAdapter.useFavorites(isChecked);
                }
                WloAutoCompleteTextViewWithFavorites.this.autoCompleteTextView.setText(s);
            }
        });
    }

    public WloAutoCompleteTextView getAutoCompleteTextView() {
        return this.autoCompleteTextView;
    }

    public void useFavorites(boolean useFavorites) {
        this.toggleButton.setChecked(useFavorites);
    }

    public static class FavoriteAdapter<M>
    extends ArrayAdapter<M> {
        protected Collection<M> allData;
        protected Collection<M> favoriteData;

        public FavoriteAdapter(Context context, Collection<M> allData, Collection<M> favoriteData) {
            super(context, 17367050, (List)Lists.newArrayList(allData));
            this.allData = Lists.newArrayList(allData);
            if (favoriteData != null) {
                this.favoriteData = Lists.newArrayList(favoriteData);
            }
        }

        protected void useFavorites(boolean favorites) {
            if (CollectionUtils.isNotEmpty(this.favoriteData)) {
                Log.d((String)WloAutoCompleteTextViewWithFavorites.TAG, (String)("useFavorites " + favorites));
                this.clear();
                if (favorites) {
                    this.addAll(this.favoriteData);
                } else {
                    this.addAll(this.allData);
                }
                this.notifyDataSetInvalidated();
            }
        }
    }
}

