/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;

public class WloAutoCompleteTextView
extends AutoCompleteTextView {
    private static final String TAG = "WloAutoCompleteTextView";
    protected int myThreshold;
    protected boolean popupShown;

    public WloAutoCompleteTextView(Context context) {
        super(context);
        this.init();
    }

    public WloAutoCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public WloAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void init() {
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    WloAutoCompleteTextView.this.popupShown = false;
                }
            }
        });
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.d((String)WloAutoCompleteTextView.TAG, (String)("onClick " + WloAutoCompleteTextView.this.isPopupShowing()));
                if (WloAutoCompleteTextView.this.getAdapter() != null && !WloAutoCompleteTextView.this.getAdapter().isEmpty() && !WloAutoCompleteTextView.this.popupShown) {
                    WloAutoCompleteTextView.this.showDropDown();
                    WloAutoCompleteTextView.this.popupShown = true;
                } else {
                    WloAutoCompleteTextView.this.dismissDropDown();
                    WloAutoCompleteTextView.this.popupShown = false;
                }
            }
        });
        this.setImeOptions(0x10000000);
    }

    public void setOnItemClickListener(final AdapterView.OnItemClickListener l) {
        AdapterView.OnItemClickListener listener = new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                l.onItemClick(parent, view, position, id2);
                WloAutoCompleteTextView.this.popupShown = false;
            }
        };
        super.setOnItemClickListener(listener);
    }

    public void setThreshold(int threshold) {
        if (threshold < 0) {
            threshold = 0;
        }
        this.myThreshold = threshold;
    }

    public boolean enoughToFilter() {
        return this.getText().length() >= this.myThreshold;
    }

    public int getThreshold() {
        return this.myThreshold;
    }
}

