/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import android.widget.Toast;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.utils.UIUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class UpdateCheckTask
extends AsyncTask<String, Integer, String> {
    private static final String TAG = "UpdateCheckTask";
    public static final String UPDATE_URL = "http://appup.nuiton.org/wlo/wlo-update.properties";
    public static final String VERSION_PROP = "application.version";
    public static final String URL_PROP = "application.url";
    protected Context context;
    protected boolean showLoading;
    protected ProgressDialog loadingDialog;

    public UpdateCheckTask(Context context) {
        this(context, false);
    }

    public UpdateCheckTask(Context context, boolean showLoading) {
        this.context = context;
        this.showLoading = showLoading;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.showLoading) {
            this.loadingDialog = new ProgressDialog(this.context);
            this.loadingDialog.setIndeterminate(true);
            this.loadingDialog.setMessage((CharSequence)this.context.getString(2131427493));
            this.loadingDialog.show();
        }
    }

    protected String doInBackground(String ... params) {
        String result;
        if (WloBaseActivity.getDownloadingApkId() != null) {
            result = null;
        } else {
            try {
                URL url = new URL(UPDATE_URL);
                Properties props = new Properties();
                props.load(url.openStream());
                String version = props.getProperty(VERSION_PROP);
                String currentVersion = this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
                Version newVersion = new Version(version);
                if (!newVersion.isSnapshot() && VersionUtil.greaterThan((String)version, (String)currentVersion)) {
                    result = props.getProperty(URL_PROP);
                } else {
                    Log.d((String)TAG, (String)"The application is up to date");
                    result = null;
                }
            }
            catch (PackageManager.NameNotFoundException | IOException e) {
                Log.e((String)TAG, (String)"error while getting the version");
                this.cancel(true);
                result = null;
            }
        }
        return result;
    }

    protected void onPostExecute(final String result) {
        super.onPostExecute((Object)result);
        if (this.showLoading) {
            this.loadingDialog.dismiss();
        }
        if (result != null && WloBaseActivity.getDownloadingApkId() == null) {
            new AlertDialog.Builder(this.context).setTitle(2131427495).setMessage(2131427496).setNegativeButton(2131427343, UIUtils.getCancelClickListener()).setPositiveButton(2131427342, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DownloadManager downloadManager = (DownloadManager)UpdateCheckTask.this.context.getSystemService("download");
                    Uri toDownload = Uri.parse((String)result);
                    DownloadManager.Request request = new DownloadManager.Request(toDownload);
                    request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, toDownload.getLastPathSegment());
                    long enqueue = downloadManager.enqueue(request);
                    WloBaseActivity.setDownloadingApkId(enqueue);
                }
            }).create().show();
        } else if (this.showLoading) {
            Toast.makeText((Context)this.context, (int)2131427497, (int)1).show();
        }
    }

    protected void onCancelled(String s) {
        super.onCancelled((Object)s);
        if (this.showLoading) {
            this.loadingDialog.dismiss();
            Toast.makeText((Context)this.context, (int)2131427498, (int)1).show();
        }
    }
}

