/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.util.Log;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.imports.CalcifiedPartTakingRowModel;
import fr.ifremer.wlo.imports.CommercialSpeciesRowModel;
import fr.ifremer.wlo.imports.LocationRowModel;
import fr.ifremer.wlo.imports.MensurationRowModel;
import fr.ifremer.wlo.imports.MetierRowModel;
import fr.ifremer.wlo.imports.PresentationRowModel;
import fr.ifremer.wlo.imports.QualitativeValueRowModel;
import fr.ifremer.wlo.imports.ScientificSpeciesRowModel;
import fr.ifremer.wlo.imports.StateRowModel;
import fr.ifremer.wlo.imports.VesselRowModel;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.HasCode;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;

public class ImportUtil {
    private static final String TAG = "ImportUtil";
    public static final char CSV_SEPARATOR = ';';

    public static int importCommercialSpecies(Context context, String path) {
        try {
            return ImportUtil.importCommercialSpecies(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importCommercialSpecies(Context context, InputStream inputStream) {
        CommercialSpeciesRowModel commercialSpeciesRowModel = new CommercialSpeciesRowModel(';');
        int result = ImportUtil.importData(context, commercialSpeciesRowModel, inputStream, DataCache.getAllCommercialSpecies(context));
        DataCache.invalidateCommercialSpecies();
        return result;
    }

    public static int importLocations(Context context, String path) {
        try {
            return ImportUtil.importLocations(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importLocations(Context context, InputStream inputStream) {
        LocationRowModel locationRowModel = new LocationRowModel(';');
        int result = ImportUtil.importData(context, locationRowModel, inputStream, DataCache.getAllLocations(context));
        DataCache.invalidateLocations();
        return result;
    }

    public static int importMensurations(Context context, String path) {
        try {
            return ImportUtil.importMensurations(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importMensurations(Context context, InputStream inputStream) {
        MensurationRowModel mensurationRowModel = new MensurationRowModel(';');
        int result = ImportUtil.importData(context, mensurationRowModel, inputStream, DataCache.getAllMensurations(context));
        DataCache.invalidateMensurations();
        return result;
    }

    public static int importMetiers(Context context, String path) {
        try {
            return ImportUtil.importMetiers(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importMetiers(Context context, InputStream inputStream) {
        MetierRowModel metierRowModel = new MetierRowModel(';');
        int result = ImportUtil.importData(context, metierRowModel, inputStream, DataCache.getAllMetiers(context));
        DataCache.invalidateMetiers();
        return result;
    }

    public static int importPresentations(Context context, String path) {
        try {
            return ImportUtil.importPresentations(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importPresentations(Context context, InputStream inputStream) {
        PresentationRowModel presentationRowModel = new PresentationRowModel(';');
        int result = ImportUtil.importData(context, presentationRowModel, inputStream, DataCache.getAllPresentations(context));
        DataCache.invalidatePresentations();
        return result;
    }

    public static int importScientificSpecies(Context context, String path) {
        try {
            return ImportUtil.importScientificSpecies(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importScientificSpecies(Context context, InputStream inputStream) {
        ScientificSpeciesRowModel scientificSpeciesRowModel = new ScientificSpeciesRowModel(';');
        int result = ImportUtil.importData(context, scientificSpeciesRowModel, inputStream, DataCache.getAllScientificSpecies(context));
        DataCache.invalidateScientificSpecies();
        return result;
    }

    public static int importStates(Context context, String path) {
        try {
            return ImportUtil.importStates(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importStates(Context context, InputStream inputStream) {
        StateRowModel stateRowModel = new StateRowModel(';');
        int result = ImportUtil.importData(context, stateRowModel, inputStream, DataCache.getAllStates(context));
        DataCache.invalidateStates();
        return result;
    }

    public static int importVessels(Context context, String path) {
        try {
            return ImportUtil.importVessels(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importVessels(Context context, InputStream inputStream) {
        VesselRowModel vesselRowModel = new VesselRowModel(';');
        int result = ImportUtil.importData(context, vesselRowModel, inputStream, DataCache.getAllVessels(context));
        DataCache.invalidateVessels();
        return result;
    }

    public static int importCalcifiedPartTakings(Context context, String path) {
        try {
            return ImportUtil.importCalcifiedPartTakings(context, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return 0;
        }
    }

    public static int importCalcifiedPartTakings(Context context, InputStream inputStream) {
        CalcifiedPartTakingRowModel calcifiedPartTakingRowModel = new CalcifiedPartTakingRowModel(';', DataCache.getAllScientificSpecies(context));
        int result = ImportUtil.importData(context, calcifiedPartTakingRowModel, inputStream, new ArrayList());
        return result;
    }

    public static Collection<QualitativeValueModel> importQualitativeValues(CategoryModel categoryModel, String path) {
        try {
            return ImportUtil.importQualitativeValues(categoryModel, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File " + path + " not found"), (Throwable)e);
            return null;
        }
    }

    public static Collection<QualitativeValueModel> importQualitativeValues(CategoryModel categoryModel, InputStream inputStream) {
        QualitativeValueRowModel qualitativeValueRowModel = new QualitativeValueRowModel(';', categoryModel);
        Collection<QualitativeValueModel> result = ImportUtil.importData(qualitativeValueRowModel, inputStream, new ArrayList());
        return result;
    }

    protected static <M extends BaseModel> int importData(Context context, ImportModel<M> importModel, InputStream inputStream, final Collection<M> actualReferential) {
        Collection models = ImportUtil.importData(importModel, inputStream, actualReferential);
        if (CollectionUtils.isNotEmpty(models)) {
            Object filter;
            BaseModel first = (BaseModel)models.iterator().next();
            if (HasCode.class.isAssignableFrom(first.getClass())) {
                Collection hasCodes = Collections2.transform(actualReferential, (Function)new Function<M, HasCode>(){

                    public HasCode apply(M m) {
                        return (HasCode)m;
                    }
                });
                final Collection codes = Collections2.transform((Collection)hasCodes, HasCode.GET_CODE_FUNCTION);
                filter = new Predicate<M>(){

                    public boolean apply(M model) {
                        HasCode hasCode = (HasCode)model;
                        return !codes.contains(hasCode.getCode());
                    }
                };
            } else {
                filter = new Predicate<M>(){

                    public boolean apply(M m) {
                        return !actualReferential.contains(m);
                    }
                };
            }
            models = Collections2.filter(models, (Predicate)filter);
            WloSqlOpenHelper soh = new WloSqlOpenHelper(context);
            soh.saveData(models);
            soh.close();
        }
        return models.size();
    }

    protected static <M extends BaseModel> Collection<M> importData(ImportModel<M> importModel, InputStream inputStream, Collection<M> actualReferential) {
        Preconditions.checkNotNull(actualReferential);
        ArrayList models = null;
        try (Import importer = null;){
            importer = Import.newImport(importModel, (InputStream)inputStream);
            models = Lists.newArrayList((Iterator)importer.iterator());
        }
        return models;
    }
}

