/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.utils;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.google.common.base.Function;
import fr.ifremer.wlo.models.BaseModel;
import java.util.List;

public class BaseModelArrayAdapter<M extends BaseModel>
extends ArrayAdapter<M> {
    protected int mResource;
    protected int mFieldId = 0;
    protected LayoutInflater mInflater;
    protected Function<M, String> toStringFunction;

    public BaseModelArrayAdapter(Context context, int textViewResourceId, Function<M, String> toStringFunction) {
        super(context, textViewResourceId);
        this.init(textViewResourceId, 0, toStringFunction);
    }

    public BaseModelArrayAdapter(Context context, int textViewResourceId) {
        super(context, textViewResourceId);
        this.init(textViewResourceId, 0, null);
    }

    public BaseModelArrayAdapter(Context context, int resource, int textViewResourceId, Function<M, String> toStringFunction) {
        super(context, resource, textViewResourceId);
        this.init(resource, textViewResourceId, toStringFunction);
    }

    public BaseModelArrayAdapter(Context context, int resource, int textViewResourceId) {
        super(context, resource, textViewResourceId);
        this.init(resource, textViewResourceId, null);
    }

    public BaseModelArrayAdapter(Context context, int textViewResourceId, M[] objects, Function<M, String> toStringFunction) {
        super(context, textViewResourceId, (Object[])objects);
        this.init(textViewResourceId, 0, toStringFunction);
    }

    public BaseModelArrayAdapter(Context context, int textViewResourceId, M[] objects) {
        super(context, textViewResourceId, (Object[])objects);
        this.init(textViewResourceId, 0, null);
    }

    public BaseModelArrayAdapter(Context context, int resource, int textViewResourceId, M[] objects, Function<M, String> toStringFunction) {
        super(context, resource, textViewResourceId, (Object[])objects);
        this.init(resource, textViewResourceId, toStringFunction);
    }

    public BaseModelArrayAdapter(Context context, int resource, int textViewResourceId, M[] objects) {
        super(context, resource, textViewResourceId, (Object[])objects);
        this.init(resource, textViewResourceId, null);
    }

    public BaseModelArrayAdapter(Context context, int textViewResourceId, List<M> objects, Function<M, String> toStringFunction) {
        super(context, textViewResourceId, objects);
        this.init(textViewResourceId, 0, toStringFunction);
    }

    public BaseModelArrayAdapter(Context context, int textViewResourceId, List<M> objects) {
        super(context, textViewResourceId, objects);
        this.init(textViewResourceId, 0, null);
    }

    public BaseModelArrayAdapter(Context context, int resource, int textViewResourceId, List<M> objects, Function<M, String> toStringFunction) {
        super(context, resource, textViewResourceId, objects);
        this.init(resource, textViewResourceId, toStringFunction);
    }

    public BaseModelArrayAdapter(Context context, int resource, int textViewResourceId, List<M> objects) {
        super(context, resource, textViewResourceId, objects);
        this.init(resource, textViewResourceId, null);
    }

    protected void init(int resource, int textViewResourceId, Function<M, String> toStringFunction) {
        this.mInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        this.mResource = resource;
        this.mFieldId = textViewResourceId;
        this.toStringFunction = toStringFunction;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(position, convertView, parent, this.mResource);
    }

    private View createViewFromResource(int position, View convertView, ViewGroup parent, int resource) {
        TextView text;
        View view = convertView == null ? this.mInflater.inflate(resource, null) : convertView;
        try {
            text = this.mFieldId == 0 ? (TextView)view : (TextView)view.findViewById(this.mFieldId);
        }
        catch (ClassCastException e) {
            Log.e((String)"BaseModelArrayAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("BaseModelArrayAdapter requires the resource ID to be a TextView", e);
        }
        BaseModel item = (BaseModel)this.getItem(position);
        String s = item == null ? "" : (this.toStringFunction != null ? (String)this.toStringFunction.apply((Object)item) : item.toString(this.getContext()));
        text.setText((CharSequence)s);
        return view;
    }
}

