/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.CategoryWeightModel;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ContextModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.CalcifiedPartTaking;
import fr.ifremer.wlo.models.referentials.CommercialSpecies;
import fr.ifremer.wlo.models.referentials.Location;
import fr.ifremer.wlo.models.referentials.Mensuration;
import fr.ifremer.wlo.models.referentials.Metier;
import fr.ifremer.wlo.models.referentials.Presentation;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import fr.ifremer.wlo.models.referentials.State;
import fr.ifremer.wlo.models.referentials.Vessel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class WloSqlOpenHelper
extends SQLiteOpenHelper {
    private static final String TAG = "WloOpenHelper";
    public static final String DATABASE_NAME = "wlo.db";
    public static final int DATABASE_VERSION = 19;
    public static final String TEXT_TYPE = " TEXT";
    public static final String INTEGER_TYPE = " INTEGER";
    public static final String NUMERIC_TYPE = " NUMERIC";
    public static final String REAL_TYPE = " REAL";
    public static final String COMMA_SEP = ",";
    public static final String NOT_NULL = " NOT NULL";
    protected static final String SQL_CREATE_CONTEXTS = "CREATE TABLE contexts (_id TEXT PRIMARY KEY,name TEXT NOT NULL,comment TEXT )";
    protected static final String SQL_DELETE_CONTEXTS = "DROP TABLE IF EXISTS contexts";
    protected static final String SQL_CREATE_LOCATIONS = "CREATE TABLE locations (_id TEXT PRIMARY KEY,operator TEXT,startDate INTEGER,endDate INTEGER,location TEXT NOT NULL,comment TEXT,contextId TEXT NOT NULL,FOREIGN KEY(contextId) REFERENCES contexts(_id) ON DELETE CASCADE,FOREIGN KEY(location) REFERENCES ref_location(_id) )";
    protected static final String SQL_DELETE_LOCATIONS = "DROP TABLE IF EXISTS locations";
    protected static final String SQL_CREATE_VESSELS = "CREATE TABLE vessels (_id TEXT PRIMARY KEY,registrationNumber TEXT,name TEXT,landingDate INTEGER,landingLocation TEXT,comment TEXT,location_id TEXT NOT NULL,FOREIGN KEY(location_id) REFERENCES locations(_id) ON DELETE CASCADE,FOREIGN KEY(landingLocation) REFERENCES ref_location(_id) )";
    protected static final String SQL_DELETE_VESSELS = "DROP TABLE IF EXISTS vessels";
    protected static final String SQL_CREATE_METIERS = "CREATE TABLE metiers (_id TEXT PRIMARY KEY,gearSpecies TEXT,zone TEXT,sampleRowCode TEXT,comment TEXT,vesselId TEXT NOT NULL,FOREIGN KEY(vesselId) REFERENCES vessels(_id) ON DELETE CASCADE,FOREIGN KEY(gearSpecies) REFERENCES ref_metiers(_id) )";
    protected static final String SQL_DELETE_METIERS = "DROP TABLE IF EXISTS metiers";
    protected static final String SQL_CREATE_COMMERCIAL_SPECIES = "CREATE TABLE commercial_species (_id TEXT PRIMARY KEY,faoCode TEXT,measurementMethod TEXT,precision TEXT,speciesMix NUMERIC,sortCategory TEXT,state TEXT,presentation TEXT,category1 TEXT,category2 TEXT,category3 TEXT,comment TEXT,totalUnloadedWeight INTEGER,metierId TEXT NOT NULL,FOREIGN KEY(metierId) REFERENCES metiers(_id) ON DELETE CASCADE,FOREIGN KEY(faoCode) REFERENCES ref_commercial_species(_id),FOREIGN KEY(measurementMethod) REFERENCES ref_mensurations(_id),FOREIGN KEY(state) REFERENCES ref_states(_id),FOREIGN KEY(presentation) REFERENCES ref_presentations(_id),FOREIGN KEY(category1) REFERENCES categories(_id),FOREIGN KEY(category2) REFERENCES categories(_id),FOREIGN KEY(category3) REFERENCES categories(_id) )";
    protected static final String SQL_DELETE_COMMERCIAL_SPECIES = "DROP TABLE IF EXISTS commercial_species";
    protected static final String SQL_CREATE_SCIENTIFIC_SPECIES = "CREATE TABLE scientific_species (_id TEXT PRIMARY KEY,name TEXT,takingActivation NUMERIC,comment TEXT,sortedWeight INTEGER,sampleWeight INTEGER,commercialSpeciesId TEXT NOT NULL,FOREIGN KEY(commercialSpeciesId) REFERENCES commercial_species(_id) ON DELETE CASCADE,FOREIGN KEY(name) REFERENCES ref_scientific_species(_id) )";
    protected static final String SQL_DELETE_SCIENTIFIC_SPECIES = "DROP TABLE IF EXISTS scientific_species";
    protected static final String SQL_CREATE_MEASUREMENTS = "CREATE TABLE measurements (_id TEXT PRIMARY KEY,size INTEGER,date INTEGER,category1 TEXT,category2 TEXT,category3 TEXT,scientificSpeciesId TEXT NOT NULL,FOREIGN KEY(scientificSpeciesId) REFERENCES scientific_species(_id) ON DELETE CASCADE )";
    protected static final String SQL_DELETE_MEASUREMENTS = "DROP TABLE IF EXISTS measurements";
    protected static final String SQL_CREATE_CATEGORY_WEIGHTS = "CREATE TABLE category_weights (_id TEXT PRIMARY KEY,category1 TEXT,category2 TEXT,category3 TEXT,weight INTEGER,scientificSpeciesId TEXT NOT NULL,FOREIGN KEY(scientificSpeciesId) REFERENCES scientific_species(_id) ON DELETE CASCADE )";
    protected static final String SQL_DELETE_CATEGORY_WEIGHTS = "DROP TABLE IF EXISTS category_weights";
    protected static final String SQL_CREATE_CALCIFIED_PART_TAKINGS = "CREATE TABLE calcifiedPartTaking (_id TEXT PRIMARY KEY,startSize INTEGER,endSize INTEGER,sizeStep INTEGER,step INTEGER,stop INTEGER,scientificSpeciesId TEXT NOT NULL,FOREIGN KEY(scientificSpeciesId) REFERENCES ref_scientific_species(_id) ON DELETE CASCADE )";
    protected static final String SQL_DELETE_CALCIFIED_PART_TAKINGS = "DROP TABLE IF EXISTS calcifiedPartTaking";
    protected static final String SQL_CREATE_CATEGORIES = "CREATE TABLE categories (_id TEXT PRIMARY KEY,label TEXT NOT NULL )";
    protected static final String SQL_DELETE_CATEGORIES = "DROP TABLE IF EXISTS categories";
    protected static final String SQL_CREATE_QUALITATIVE_VALUES = "CREATE TABLE qualitativeValues (_id TEXT PRIMARY KEY,value TEXT NOT NULL,label TEXT,categoryId TEXT NOT NULL,FOREIGN KEY(categoryId) REFERENCES categories(_id) ON DELETE CASCADE )";
    protected static final String SQL_DELETE_QUALITATIVE_VALUES = "DROP TABLE IF EXISTS qualitativeValues";
    protected static final String SQL_CREATE_REF_COMMERCIAL_SPECIES = "CREATE TABLE ref_commercial_species (_id TEXT PRIMARY KEY,code TEXT NOT NULL,isscap TEXT,taxonCode TEXT,scientificLabel TEXT,frenchLabel TEXT,family TEXT,speciesOrder TEXT,active NUMERIC )";
    protected static final String SQL_DELETE_REF_COMMERCIAL_SPECIES = "DROP TABLE IF EXISTS ref_commercial_species";
    protected static final String SQL_CREATE_REF_LOCATIONS = "CREATE TABLE ref_location (_id TEXT PRIMARY KEY,typeLabel TEXT,code TEXT NOT NULL,label TEXT )";
    protected static final String SQL_DELETE_REF_LOCATIONS = "DROP TABLE IF EXISTS ref_location";
    protected static final String SQL_CREATE_REF_MENSURATIONS = "CREATE TABLE ref_mensurations (_id TEXT PRIMARY KEY,code TEXT NOT NULL,label TEXT )";
    protected static final String SQL_DELETE_REF_MENSURATIONS = "DROP TABLE IF EXISTS ref_mensurations";
    protected static final String SQL_CREATE_REF_METIERS = "CREATE TABLE ref_metiers (_id TEXT PRIMARY KEY,metierId TEXT,code TEXT NOT NULL,label TEXT,gearCode TEXT,gearLabel TEXT,speciesCode TEXT,speciesLabel TEXT,fishing NUMERIC,active NUMERIC )";
    protected static final String SQL_DELETE_REF_METIERS = "DROP TABLE IF EXISTS ref_metiers";
    protected static final String SQL_CREATE_REF_PRESENTATIONS = "CREATE TABLE ref_presentations (_id TEXT PRIMARY KEY,code TEXT NOT NULL,label TEXT )";
    protected static final String SQL_DELETE_REF_PRESENTATIONS = "DROP TABLE IF EXISTS ref_presentations";
    protected static final String SQL_CREATE_REF_SCIENTIFIC_SPECIES = "CREATE TABLE ref_scientific_species (_id TEXT PRIMARY KEY,permCode TEXT NOT NULL,code TEXT,label TEXT )";
    protected static final String SQL_DELETE_REF_SCIENTIFIC_SPECIES = "DROP TABLE IF EXISTS ref_scientific_species";
    protected static final String SQL_CREATE_REF_STATES = "CREATE TABLE ref_states (_id TEXT PRIMARY KEY,code TEXT NOT NULL,label TEXT )";
    protected static final String SQL_DELETE_REF_STATES = "DROP TABLE IF EXISTS ref_states";
    protected static final String SQL_CREATE_REF_VESSELS = "CREATE TABLE ref_vessel (_id TEXT PRIMARY KEY,code TEXT NOT NULL,name TEXT,quarterCode TEXT )";
    protected static final String SQL_DELETE_REF_VESSELS = "DROP TABLE IF EXISTS ref_vessel";

    public WloSqlOpenHelper(Context context) {
        super(context, DATABASE_NAME, null, 19);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SQL_CREATE_REF_COMMERCIAL_SPECIES);
        db.execSQL(SQL_CREATE_REF_LOCATIONS);
        db.execSQL(SQL_CREATE_REF_MENSURATIONS);
        db.execSQL(SQL_CREATE_REF_METIERS);
        db.execSQL(SQL_CREATE_REF_PRESENTATIONS);
        db.execSQL(SQL_CREATE_REF_SCIENTIFIC_SPECIES);
        db.execSQL(SQL_CREATE_REF_STATES);
        db.execSQL(SQL_CREATE_REF_VESSELS);
        db.execSQL(SQL_CREATE_CATEGORIES);
        db.execSQL(SQL_CREATE_QUALITATIVE_VALUES);
        db.execSQL(SQL_CREATE_CONTEXTS);
        db.execSQL(SQL_CREATE_LOCATIONS);
        db.execSQL(SQL_CREATE_VESSELS);
        db.execSQL(SQL_CREATE_METIERS);
        db.execSQL(SQL_CREATE_COMMERCIAL_SPECIES);
        db.execSQL(SQL_CREATE_SCIENTIFIC_SPECIES);
        db.execSQL(SQL_CREATE_MEASUREMENTS);
        db.execSQL(SQL_CREATE_CATEGORY_WEIGHTS);
        db.execSQL(SQL_CREATE_CALCIFIED_PART_TAKINGS);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(SQL_DELETE_CALCIFIED_PART_TAKINGS);
        db.execSQL(SQL_DELETE_CATEGORY_WEIGHTS);
        db.execSQL(SQL_DELETE_MEASUREMENTS);
        db.execSQL(SQL_DELETE_SCIENTIFIC_SPECIES);
        db.execSQL(SQL_DELETE_COMMERCIAL_SPECIES);
        db.execSQL(SQL_DELETE_METIERS);
        db.execSQL(SQL_DELETE_VESSELS);
        db.execSQL(SQL_DELETE_LOCATIONS);
        db.execSQL(SQL_DELETE_CONTEXTS);
        db.execSQL(SQL_DELETE_CATEGORIES);
        db.execSQL(SQL_DELETE_QUALITATIVE_VALUES);
        db.execSQL(SQL_DELETE_REF_COMMERCIAL_SPECIES);
        db.execSQL(SQL_DELETE_REF_LOCATIONS);
        db.execSQL(SQL_DELETE_REF_MENSURATIONS);
        db.execSQL(SQL_DELETE_REF_METIERS);
        db.execSQL(SQL_DELETE_REF_PRESENTATIONS);
        db.execSQL(SQL_DELETE_REF_SCIENTIFIC_SPECIES);
        db.execSQL(SQL_DELETE_REF_STATES);
        db.execSQL(SQL_DELETE_REF_VESSELS);
        this.onCreate(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (!db.isReadOnly()) {
            db.execSQL("PRAGMA foreign_keys=ON;");
        }
    }

    public synchronized void close() {
        super.close();
        this.getReadableDatabase().close();
        this.getWritableDatabase().close();
    }

    public Cursor getAllContexts() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("contexts", ContextModel.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllLocations(String contextId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("locations", LocationModel.ALL_COLUMNS, "contextId = ?", new String[]{contextId}, null, null, null);
        return cursor;
    }

    public Cursor getAllVessels(String locationId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("vessels", VesselModel.ALL_COLUMNS, "location_id = ?", new String[]{locationId}, null, null, null);
        return cursor;
    }

    public Cursor getAllMetiers(String vesselId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("metiers", MetierModel.ALL_COLUMNS, "vesselId = ?", new String[]{vesselId}, null, null, null);
        return cursor;
    }

    public Cursor getAllCommercialSpecies(String metierId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("commercial_species", CommercialSpeciesModel.ALL_COLUMNS, "metierId = ?", new String[]{metierId}, null, null, null);
        return cursor;
    }

    public Cursor getAllSortCategories() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("commercial_species", new String[]{"sortCategory"}, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllScientificSpecies(String commercialSpeciesId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("scientific_species", ScientificSpeciesModel.ALL_COLUMNS, "commercialSpeciesId = ?", new String[]{commercialSpeciesId}, null, null, null);
        return cursor;
    }

    public Cursor getAllMeasurements(String scientificSpeciesId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("measurements", MeasurementModel.ALL_COLUMNS, "scientificSpeciesId = ?", new String[]{scientificSpeciesId}, null, null, "date ASC");
        return cursor;
    }

    public void deleteMeasurement(MeasurementModel measurement) {
        if (!measurement.isNew()) {
            SQLiteDatabase db = this.getWritableDatabase();
            db.delete("measurements", "_id = ?", new String[]{measurement.getId()});
        }
    }

    public Cursor getAllCategoryWeigths(String scientificSpeciesId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("category_weights", CategoryWeightModel.ALL_COLUMNS, "scientificSpeciesId = ?", new String[]{scientificSpeciesId}, null, null, null);
        return cursor;
    }

    public Cursor getCategoryWeight(String scientificSpeciesId, String category1Id, String category2Id, String category3Id) {
        SQLiteDatabase db = this.getReadableDatabase();
        String cat1Condition = category1Id == null ? " IS NULL" : " = '" + category1Id + "'";
        String cat2Condition = category2Id == null ? " IS NULL" : " = '" + category2Id + "'";
        String cat3Condition = category3Id == null ? " IS NULL" : " = '" + category3Id + "'";
        Cursor cursor = db.query("category_weights", CategoryWeightModel.ALL_COLUMNS, "scientificSpeciesId = ? AND category1" + cat1Condition + " AND " + "category2" + cat2Condition + " AND " + "category3" + cat3Condition, new String[]{scientificSpeciesId}, null, null, null);
        return cursor;
    }

    public Cursor getAllCalcifiedPartTakings(String scientificSpeciesId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("calcifiedPartTaking", CalcifiedPartTaking.ALL_COLUMNS, "scientificSpeciesId = ?", new String[]{scientificSpeciesId}, null, null, "startSize ASC");
        return cursor;
    }

    public void clearCalcifiedPartTakings() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete("calcifiedPartTaking", null, null);
    }

    public Cursor getAllCategories() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("categories", CategoryModel.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllQualitativeValues() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("qualitativeValues", QualitativeValueModel.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllQualitativeValues(String categoryId) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("qualitativeValues", QualitativeValueModel.ALL_COLUMNS, "categoryId = ?", new String[]{categoryId}, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefCommercialSpecies() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_commercial_species", CommercialSpecies.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefLocations() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_location", Location.ALL_COLUMNS, null, null, null, null, "code");
        return cursor;
    }

    public Cursor getAllRefMensurations() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_mensurations", Mensuration.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefMetiers() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_metiers", Metier.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefPresentations() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_presentations", Presentation.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefScientificSpecies() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_scientific_species", ScientificSpecies.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefStates() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_states", State.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public Cursor getAllRefVessels() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("ref_vessel", Vessel.ALL_COLUMNS, null, null, null, null, null);
        return cursor;
    }

    public <M extends BaseModel> void saveData(M model) {
        this.saveData(Lists.newArrayList((Object[])new BaseModel[]{model}));
    }

    public <M extends BaseModel> void saveData(Collection<M> models) {
        Preconditions.checkNotNull(models);
        SQLiteDatabase db = this.getWritableDatabase();
        db.beginTransaction();
        for (BaseModel model : models) {
            String tableName = model.getTableName();
            boolean newSession = model.isNew();
            if (newSession) {
                String id2 = UUID.randomUUID().toString();
                model.setId(id2);
            }
            ContentValues values = model.convertIntoContentValues();
            if (newSession) {
                db.insert(tableName, null, values);
            } else {
                db.update(tableName, values, "_id = ?", new String[]{model.getId()});
            }
            model.setModified(false);
        }
        db.setTransactionSuccessful();
        db.endTransaction();
    }

    public <M extends BaseModel> void deleteData(M model) {
        Preconditions.checkNotNull(model);
        if (model.isNew()) {
            return;
        }
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete(model.getTableName(), "_id = ?", new String[]{model.getId()});
    }

    public static <E> List<E> transformCursorIntoCollection(Cursor cursor, Function<Cursor, E> function) {
        ArrayList result = Lists.newArrayList();
        boolean cont = cursor.moveToFirst();
        while (cont) {
            Object e = function.apply((Object)cursor);
            result.add(e);
            cont = cursor.moveToNext();
        }
        return result;
    }
}

