/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.preferences;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.util.Log;
import android.widget.Toast;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.MainActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.referentials.CommercialSpecies;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import fr.ifremer.wlo.preferences.CategoryCreationAcivity;
import fr.ifremer.wlo.preferences.ListItemPreference;
import fr.ifremer.wlo.preferences.MultiSelectItemPreference;
import fr.ifremer.wlo.preferences.MultiSelectionActivity;
import fr.ifremer.wlo.preferences.StringPreference;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.StorageUtils;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.ImportUtil;
import fr.ifremer.wlo.utils.UIUtils;
import fr.ifremer.wlo.utils.UpdateCheckTask;
import fr.ifremer.wlo.utils.filechooser.FileDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;

public class SettingsActivity
extends WloBaseActivity {
    private static final String TAG = "SettingsActivity";
    protected static final int REQUEST_IMPORT_COMMERCIAL_SPECIES = 0;
    protected static final int REQUEST_IMPORT_LOCATIONS = 1;
    protected static final int REQUEST_IMPORT_MENSURATIONS = 2;
    protected static final int REQUEST_IMPORT_METIERS = 3;
    protected static final int REQUEST_IMPORT_PRESENTATIONS = 4;
    protected static final int REQUEST_IMPORT_SCIENTIFIC_SPECIES = 5;
    protected static final int REQUEST_IMPORT_STATES = 6;
    protected static final int REQUEST_IMPORT_VESSELS = 7;
    protected static final int REQUEST_IMPORT_CALCIFIED_PARTS_TAKINGS = 8;
    protected static final int REQUEST_CREATE_CATEGORY = 9;
    protected static final int REQUEST_FAVORITES_COMMERCIAL_SPECIES = 10;
    protected static final int REQUEST_FAVORITES_SCIENTIFIC_SPECIES = 11;

    @Override
    protected Integer getContentView() {
        return null;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return MainActivity.class;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getFragmentManager().beginTransaction().replace(0x1020002, (Fragment)new SettingsFragment()).commit();
    }

    public static class SettingsFragment
    extends PreferenceFragment
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        protected BiMap<String, Integer> requestCodeByPrefKey = HashBiMap.create();

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.addPreferencesFromResource(2131034112);
            this.requestCodeByPrefKey.put((Object)"import_commercial_species", (Object)0);
            this.requestCodeByPrefKey.put((Object)"import_locations", (Object)1);
            this.requestCodeByPrefKey.put((Object)"import_mensurations", (Object)2);
            this.requestCodeByPrefKey.put((Object)"import_metiers", (Object)3);
            this.requestCodeByPrefKey.put((Object)"import_presentations", (Object)4);
            this.requestCodeByPrefKey.put((Object)"import_scientific_species", (Object)5);
            this.requestCodeByPrefKey.put((Object)"import_states", (Object)6);
            this.requestCodeByPrefKey.put((Object)"import_vessels", (Object)7);
            this.requestCodeByPrefKey.put((Object)"import_calcified_parts_takings", (Object)8);
            HashMap nbElementsByPrefKey = Maps.newHashMap();
            Activity context = this.getActivity();
            nbElementsByPrefKey.put("import_commercial_species", DataCache.getAllCommercialSpecies((Context)context).size());
            nbElementsByPrefKey.put("import_locations", DataCache.getAllLocations((Context)context).size());
            nbElementsByPrefKey.put("import_mensurations", DataCache.getAllMensurations((Context)context).size());
            nbElementsByPrefKey.put("import_metiers", DataCache.getAllMetiers((Context)context).size());
            nbElementsByPrefKey.put("import_presentations", DataCache.getAllPresentations((Context)context).size());
            nbElementsByPrefKey.put("import_scientific_species", DataCache.getAllScientificSpecies((Context)context).size());
            nbElementsByPrefKey.put("import_states", DataCache.getAllStates((Context)context).size());
            nbElementsByPrefKey.put("import_vessels", DataCache.getAllVessels((Context)context).size());
            for (String key : this.requestCodeByPrefKey.keySet()) {
                final Integer requestCode = (Integer)this.requestCodeByPrefKey.get((Object)key);
                Preference filePicker = this.findPreference(key);
                Integer nb = (Integer)nbElementsByPrefKey.get(key);
                if (nb != null) {
                    filePicker.setSummary((CharSequence)this.getString(2131427393, new Object[]{nb}));
                }
                filePicker.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                    public boolean onPreferenceClick(Preference preference) {
                        Intent intent = new Intent((Context)SettingsFragment.this.getActivity(), FileDialog.class);
                        intent.putExtra("START_PATH", "/sdcard");
                        intent.putExtra("CAN_SELECT_DIR", false);
                        intent.putExtra("SELECTION_MODE", 1);
                        intent.putExtra("FORMAT_FILTER", new String[]{"csv"});
                        SettingsFragment.this.startActivityForResult(intent, requestCode);
                        return true;
                    }
                });
            }
            Preference categoryPref = this.findPreference("import_categories");
            int nb = DataCache.getAllCategories((Context)context).size();
            categoryPref.setSummary((CharSequence)this.getString(2131427393, new Object[]{nb}));
            categoryPref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    Intent intent = new Intent((Context)SettingsFragment.this.getActivity(), CategoryCreationAcivity.class);
                    SettingsFragment.this.startActivityForResult(intent, 9);
                    return true;
                }
            });
            this.initMultiSelectListPreference(MultiSelectItemPreference.COMMERCIAL_SPECIES_FAVORITES.getKey(), CommercialSpecies.class, 10);
            this.initMultiSelectListPreference(MultiSelectItemPreference.SCIENTIFIC_SPECIES_FAVORITES.getKey(), ScientificSpecies.class, 11);
            Preference updatePref = this.findPreference("preferences_check_update");
            try {
                String currentVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                updatePref.setSummary((CharSequence)this.getString(2131427425, new Object[]{currentVersion}));
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)SettingsActivity.TAG, (String)"error while getting the version");
            }
            updatePref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    new UpdateCheckTask((Context)SettingsFragment.this.getActivity(), true).execute(new String[0]);
                    return true;
                }
            });
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            Log.d((String)SettingsActivity.TAG, (String)("onSharedPreferenceChanged " + key));
            Preference preference = this.findPreference(key);
            String summary = null;
            ListItemPreference pref = ListItemPreference.getListItemPreference(key);
            if (pref != null) {
                String entry = sharedPreferences.getString(key, "");
                summary = pref.getEntryForValue((Context)this.getActivity(), entry);
            } else {
                try {
                    summary = sharedPreferences.getString(key, "");
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            preference.setSummary((CharSequence)summary);
        }

        public void onResume() {
            Preference preference;
            String key;
            super.onResume();
            SharedPreferences sharedPreferences = this.getPreferenceScreen().getSharedPreferences();
            for (StringPreference stringPreference : StringPreference.values()) {
                key = stringPreference.getKey();
                preference = this.findPreference(key);
                preference.setSummary((CharSequence)sharedPreferences.getString(key, ""));
            }
            for (Enum enum_ : ListItemPreference.values()) {
                key = ((ListItemPreference)enum_).getKey();
                preference = this.findPreference(key);
                String entry = sharedPreferences.getString(key, "");
                String summary = ((ListItemPreference)enum_).getEntryForValue((Context)this.getActivity(), entry);
                preference.setSummary((CharSequence)summary);
            }
            Log.d((String)SettingsActivity.TAG, (String)"registerOnSharedPreferenceChangeListener");
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }

        public void onPause() {
            super.onPause();
            Log.d((String)SettingsActivity.TAG, (String)"unregisterOnSharedPreferenceChangeListener");
            this.getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }

        public void onActivityResult(final int requestCode, int resultCode, final Intent data) {
            Activity context = this.getActivity();
            if (resultCode == -1) {
                if (requestCode >= 0 && requestCode <= 8) {
                    if (!StorageUtils.isExternalStorageWritable()) {
                        AlertDialog dialog = new AlertDialog.Builder((Context)context).setTitle(2131427406).setMessage(2131427407).setCancelable(false).setNegativeButton(2131427343, UIUtils.getCancelClickListener()).setPositiveButton(2131427342, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                SettingsFragment.this.importData(requestCode, data, false);
                            }
                        }).create();
                        dialog.show();
                    } else {
                        this.importData(requestCode, data, true);
                    }
                } else if (requestCode == 9) {
                    int nb = DataCache.getAllCategories((Context)context).size();
                    Preference categoryPref = this.findPreference("import_categories");
                    categoryPref.setSummary((CharSequence)this.getString(2131427393, new Object[]{nb}));
                } else if (requestCode == 11) {
                    this.saveMultiSelectListPreference(data, MultiSelectItemPreference.SCIENTIFIC_SPECIES_FAVORITES.getKey());
                } else if (requestCode == 10) {
                    this.saveMultiSelectListPreference(data, MultiSelectItemPreference.COMMERCIAL_SPECIES_FAVORITES.getKey());
                }
            } else {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }

        protected void importData(int requestCode, Intent data, boolean backupFile) {
            Activity context = this.getActivity();
            String path = data.getStringExtra("RESULT_PATH");
            new ImportAsyncTask().execute(new Object[]{path, requestCode, backupFile});
        }

        protected <M extends BaseModel> void initMultiSelectListPreference(String prefKey, final Class clazz, final int requestCode) {
            Log.d((String)SettingsActivity.TAG, (String)("initMultiSelectListPreference " + prefKey));
            Preference preference = this.findPreference(prefKey);
            SharedPreferences sharedPreferences = this.getPreferenceScreen().getSharedPreferences();
            final ArrayList data = new ArrayList(sharedPreferences.getStringSet(prefKey, new HashSet()));
            preference.setSummary((CharSequence)this.getString(2131427413, new Object[]{data.size()}));
            preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    Intent intent = new Intent((Context)SettingsFragment.this.getActivity(), MultiSelectionActivity.class);
                    intent.putExtra("universeClass", (Serializable)clazz);
                    intent.putExtra("favoriteList", (Serializable)data);
                    SettingsFragment.this.startActivityForResult(intent, requestCode);
                    return true;
                }
            });
        }

        protected void saveMultiSelectListPreference(Intent data, String key) {
            Preference pref = this.findPreference(key);
            HashSet favoriteIds = new HashSet(data.getStringArrayListExtra("favoriteList"));
            SharedPreferences.Editor editor = this.getPreferenceManager().getSharedPreferences().edit();
            editor.putStringSet(key, favoriteIds);
            try {
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
            pref.setSummary((CharSequence)this.getString(2131427413, new Object[]{favoriteIds.size()}));
        }

        protected class ImportAsyncTask
        extends AsyncTask<Object, Integer, Integer[]> {
            protected ProgressDialog dialog;

            protected ImportAsyncTask() {
            }

            protected void onPreExecute() {
                super.onPreExecute();
                this.dialog = new ProgressDialog((Context)SettingsFragment.this.getActivity());
                this.dialog.setCancelable(false);
                this.dialog.setMessage((CharSequence)SettingsFragment.this.getString(2131427408));
                this.dialog.show();
            }

            protected Integer[] doInBackground(Object ... params) {
                if (params.length != 3) {
                    return null;
                }
                Activity context = SettingsFragment.this.getActivity();
                String path = (String)params[0];
                Integer requestCode = (Integer)params[1];
                Boolean backupFile = (Boolean)params[2];
                Log.d((String)SettingsActivity.TAG, (String)path);
                Integer[] result = new Integer[3];
                result[2] = requestCode;
                try {
                    switch (requestCode) {
                        case 0: {
                            result[0] = ImportUtil.importCommercialSpecies((Context)context, path);
                            result[1] = DataCache.getAllCommercialSpecies((Context)context).size();
                            break;
                        }
                        case 1: {
                            result[0] = ImportUtil.importLocations((Context)context, path);
                            result[1] = DataCache.getAllLocations((Context)context).size();
                            break;
                        }
                        case 2: {
                            result[0] = ImportUtil.importMensurations((Context)context, path);
                            result[1] = DataCache.getAllMensurations((Context)context).size();
                            break;
                        }
                        case 3: {
                            result[0] = ImportUtil.importMetiers((Context)context, path);
                            result[1] = DataCache.getAllMetiers((Context)context).size();
                            break;
                        }
                        case 4: {
                            result[0] = ImportUtil.importPresentations((Context)context, path);
                            result[1] = DataCache.getAllPresentations((Context)context).size();
                            break;
                        }
                        case 5: {
                            result[0] = ImportUtil.importScientificSpecies((Context)context, path);
                            result[1] = DataCache.getAllScientificSpecies((Context)context).size();
                            break;
                        }
                        case 6: {
                            result[0] = ImportUtil.importStates((Context)context, path);
                            result[1] = DataCache.getAllStates((Context)context).size();
                            break;
                        }
                        case 7: {
                            result[0] = ImportUtil.importVessels((Context)context, path);
                            result[1] = DataCache.getAllVessels((Context)context).size();
                            break;
                        }
                        case 8: {
                            WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)context);
                            soh.clearCalcifiedPartTakings();
                            soh.close();
                            result[0] = ImportUtil.importCalcifiedPartTakings((Context)context, path);
                            result[1] = null;
                            break;
                        }
                        default: {
                            result[0] = null;
                            result[1] = null;
                        }
                    }
                    if (backupFile.booleanValue()) {
                        File importedFile = new File(path);
                        String copyFileName = String.format("%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS-", new Date()) + importedFile.getName();
                        File dir = Environment.getExternalStoragePublicDirectory((String)".wlo");
                        File file = new File(dir, copyFileName);
                        try {
                            FileUtils.copyInputStreamToFile((InputStream)new FileInputStream(path), (File)file);
                        }
                        catch (IOException e) {
                            Log.e((String)SettingsActivity.TAG, (String)"Error while copying the file", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)SettingsActivity.TAG, (String)"error during import", (Throwable)e);
                    result = null;
                    this.cancel(true);
                }
                return result;
            }

            protected void onPostExecute(Integer[] result) {
                super.onPostExecute((Object)result);
                this.dialog.dismiss();
                if (result != null) {
                    if (result[1] != null) {
                        String key = (String)SettingsFragment.this.requestCodeByPrefKey.inverse().get((Object)result[2]);
                        Preference filePicker = SettingsFragment.this.findPreference(key);
                        filePicker.setSummary((CharSequence)SettingsFragment.this.getString(2131427393, new Object[]{result[1]}));
                    }
                    Toast.makeText((Context)SettingsFragment.this.getActivity(), (CharSequence)SettingsFragment.this.getString(2131427414, new Object[]{result[0]}), (int)1).show();
                }
            }

            protected void onCancelled(Integer[] integer2) {
                super.onCancelled((Object)integer2);
                this.dialog.dismiss();
                new AlertDialog.Builder((Context)SettingsFragment.this.getActivity()).setMessage(2131427415).setNeutralButton(17039370, UIUtils.getCancelClickListener()).create().show();
            }
        }
    }
}

