/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models.referentials;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.referentials.HasCode;
import fr.ifremer.wlo.utils.UIUtils;

public class Vessel
extends BaseModel
implements HasCode {
    private static final String TAG = "Vessel";
    public static final String TABLE_NAME = "ref_vessel";
    public static final String COLUMN_CODE = "code";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_QUARTER_CODE = "quarterCode";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "code", "name", "quarterCode"};
    protected String code;
    protected String name;
    protected String quarterCode;

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public Vessel() {
    }

    public Vessel(Cursor cursor) {
        super(cursor);
        this.code = cursor.getString(1);
        this.name = cursor.getString(2);
        this.quarterCode = cursor.getString(3);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQuarterCode() {
        return this.quarterCode;
    }

    public void setQuarterCode(String quarterCode) {
        this.quarterCode = quarterCode;
    }

    public String toString() {
        return this.code + " - " + this.name;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.code, context) + " - " + UIUtils.getStringOrUndefined(this.name, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_CODE, this.code);
        this.putValue(value, COLUMN_NAME, this.name);
        this.putValue(value, COLUMN_QUARTER_CODE, this.quarterCode);
        return value;
    }
}

