/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models.referentials;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.referentials.HasCode;
import fr.ifremer.wlo.utils.UIUtils;

public class CommercialSpecies
extends BaseModel
implements HasCode {
    private static final String TAG = "CommercialSpecies";
    public static final String TABLE_NAME = "ref_commercial_species";
    public static final String COLUMN_CODE = "code";
    public static final String COLUMN_ISSCAP = "isscap";
    public static final String COLUMN_TAXON_CODE = "taxonCode";
    public static final String COLUMN_SCIENTIFIC_LABEL = "scientificLabel";
    public static final String COLUMN_FRENCH_LABEL = "frenchLabel";
    public static final String COLUMN_FAMILY = "family";
    public static final String COLUMN_SPECIES_ORDER = "speciesOrder";
    public static final String COLUMN_ACTIVE = "active";
    public static final String[] ALL_COLUMNS = new String[]{"_id", "code", "isscap", "taxonCode", "scientificLabel", "frenchLabel", "family", "speciesOrder", "active"};
    protected String code;
    protected String isscap;
    protected String taxonCode;
    protected String scientificLabel;
    protected String frenchLabel;
    protected String family;
    protected String speciesOrder;
    protected int active;

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public CommercialSpecies() {
    }

    public CommercialSpecies(Cursor cursor) {
        super(cursor);
        this.code = cursor.getString(1);
        this.isscap = cursor.getString(2);
        this.taxonCode = cursor.getString(3);
        this.scientificLabel = cursor.getString(4);
        this.frenchLabel = cursor.getString(5);
        this.family = cursor.getString(6);
        this.speciesOrder = cursor.getString(7);
        this.active = cursor.getInt(8);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getIsscap() {
        return this.isscap;
    }

    public void setIsscap(String isscap) {
        this.isscap = isscap;
    }

    public String getTaxonCode() {
        return this.taxonCode;
    }

    public void setTaxonCode(String taxonCode) {
        this.taxonCode = taxonCode;
    }

    public String getScientificLabel() {
        return this.scientificLabel;
    }

    public void setScientificLabel(String scientificLabel) {
        this.scientificLabel = scientificLabel;
    }

    public String getFrenchLabel() {
        return this.frenchLabel;
    }

    public void setFrenchLabel(String frenchLabel) {
        this.frenchLabel = frenchLabel;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getSpeciesOrder() {
        return this.speciesOrder;
    }

    public void setSpeciesOrder(String speciesOrder) {
        this.speciesOrder = speciesOrder;
    }

    public int getActive() {
        return this.active;
    }

    public void setActive(int active) {
        this.active = active;
    }

    public String toString() {
        return this.code + " - " + this.frenchLabel;
    }

    @Override
    public String toString(Context context) {
        return UIUtils.getStringOrUndefined(this.code, context) + " - " + UIUtils.getStringOrUndefined(this.frenchLabel, context);
    }

    @Override
    public ContentValues convertIntoContentValues() {
        ContentValues value = super.convertIntoContentValues();
        this.putValue(value, COLUMN_CODE, this.code);
        this.putValue(value, COLUMN_ISSCAP, this.isscap);
        this.putValue(value, COLUMN_TAXON_CODE, this.taxonCode);
        this.putValue(value, COLUMN_SCIENTIFIC_LABEL, this.scientificLabel);
        this.putValue(value, COLUMN_FRENCH_LABEL, this.frenchLabel);
        this.putValue(value, COLUMN_FAMILY, this.family);
        this.putValue(value, COLUMN_SPECIES_ORDER, this.speciesOrder);
        this.putValue(value, COLUMN_ACTIVE, this.active);
        return value;
    }
}

