/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.models;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.categorization.QualitativeValueModel;
import fr.ifremer.wlo.models.referentials.CalcifiedPartTaking;
import fr.ifremer.wlo.models.referentials.Mensuration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MeasurementsModel
implements Serializable {
    private static final String TAG = "Measurements";
    protected ScientificSpeciesModel scientificSpecies;
    protected Mensuration.Precision precision;
    protected Multimap<Integer, MeasurementModel> measurements = HashMultimap.create();
    protected List<CalcifiedPartTaking> calcifiedPartTakings;
    protected Map<String, QualitativeValueModel> categoryValuesById = new HashMap<String, QualitativeValueModel>();
    protected transient List<MeasurementsListener> listeners = new ArrayList<MeasurementsListener>();

    public ScientificSpeciesModel getScientificSpecies() {
        return this.scientificSpecies;
    }

    public void setScientificSpecies(ScientificSpeciesModel scientificSpecies) {
        this.scientificSpecies = scientificSpecies;
    }

    public Mensuration.Precision getPrecision() {
        return this.precision;
    }

    public void setPrecision(Mensuration.Precision precision) {
        this.precision = precision;
    }

    public Multimap<Integer, MeasurementModel> getMeasurements() {
        return this.measurements;
    }

    public List<MeasurementModel> getMeasurements(int size) {
        return Lists.newArrayList((Iterable)this.measurements.get((Object)size));
    }

    public int getMeasurementNb(int size) {
        return this.measurements.get((Object)size).size();
    }

    public boolean addMeasurement(MeasurementModel fishMeasurement) {
        int size = fishMeasurement.getSize();
        this.measurements.put((Object)size, (Object)fishMeasurement);
        this.fireMeasurementAdded(fishMeasurement);
        boolean result = false;
        if (this.calcifiedPartTakings != null) {
            CalcifiedPartTaking calcifiedPartTaking = null;
            for (CalcifiedPartTaking cpt : this.calcifiedPartTakings) {
                Integer startSize = cpt.getStartSize();
                Integer endSize = cpt.getEndSize();
                if (startSize != null && startSize > size || endSize != null && endSize < size) continue;
                calcifiedPartTaking = cpt;
                break;
            }
            if (calcifiedPartTaking != null) {
                int nb = this.measurements.get((Object)size).size();
                int step = calcifiedPartTaking.getStep();
                Integer stop = calcifiedPartTaking.getStop();
                boolean stepOk = (nb - 1) % step == 0;
                boolean stopOk = stop == null || (nb - 1) / step < stop;
                result = nb == 1 || stepOk && stopOk;
            }
        }
        return result;
    }

    public void removeMeasurement(MeasurementModel fishMeasurement) {
        int size = fishMeasurement.getSize();
        this.measurements.remove((Object)size, (Object)fishMeasurement);
        this.fireMeasurementRemoved(fishMeasurement);
    }

    public List<CalcifiedPartTaking> getCalcifiedPartTakings() {
        return this.calcifiedPartTakings;
    }

    public void setCalcifiedPartTakings(List<CalcifiedPartTaking> calcifiedPartTakings) {
        this.calcifiedPartTakings = calcifiedPartTakings;
    }

    public QualitativeValueModel getCategoryValuesById(String id2) {
        return this.categoryValuesById.get(id2);
    }

    public void addCategoryValues(Collection<QualitativeValueModel> categoryValues) {
        if (categoryValues != null) {
            this.categoryValuesById.putAll((Map<String, QualitativeValueModel>)Maps.uniqueIndex(categoryValues, BaseModel.GET_ID_FUNCTION));
        }
    }

    public void addMeasurementsListener(MeasurementsListener listener) {
        this.ensureListeners();
        this.listeners.add(listener);
    }

    public void removeMeasurementsListener(MeasurementsListener listener) {
        this.ensureListeners();
        this.listeners.remove(listener);
    }

    protected void fireMeasurementAdded(MeasurementModel measurement) {
        for (MeasurementsListener listener : this.listeners) {
            listener.onMeasurementAdded(this, measurement);
        }
    }

    protected void ensureListeners() {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
    }

    protected void fireMeasurementRemoved(MeasurementModel measurement) {
        for (MeasurementsListener listener : this.listeners) {
            listener.onMeasurementRemoved(this, measurement);
        }
    }

    public static interface MeasurementsListener {
        public void onMeasurementAdded(MeasurementsModel var1, MeasurementModel var2);

        public void onMeasurementRemoved(MeasurementsModel var1, MeasurementModel var2);
    }
}

