/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.measurement;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.measurement.MeasurementsDisplayerFragment;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MeasurementsModel;
import fr.ifremer.wlo.utils.BaseModelArrayAdapter;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class LogsFragment
extends MeasurementsDisplayerFragment {
    private static final String TAG = "LogsFragment";
    protected ArrayAdapter<MeasurementModel> adapter;
    protected AlertDialog.Builder dialogBuilder;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(2130903079, container, false);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Activity activity = this.getActivity();
        this.adapter = new BaseModelArrayAdapter<MeasurementModel>((Context)activity, 17367043, (Function)new Function<MeasurementModel, String>(){

            public String apply(MeasurementModel measurement) {
                String category3;
                String category2;
                Activity context = LogsFragment.this.getActivity();
                String result = measurement.toString((Context)context, LogsFragment.this.measurements.getPrecision()) + "\n";
                ArrayList cats = Lists.newArrayList();
                String category1 = measurement.getCategory1();
                if (category1 != null) {
                    Object category1Value = LogsFragment.this.measurements.getCategoryValuesById(category1);
                    if (category1Value == null) {
                        category1Value = category1;
                    }
                    cats.add(category1Value);
                }
                if ((category2 = measurement.getCategory2()) != null) {
                    Object category2Value = LogsFragment.this.measurements.getCategoryValuesById(category2);
                    if (category2Value == null) {
                        category2Value = category2;
                    }
                    cats.add(category2Value);
                }
                if ((category3 = measurement.getCategory3()) != null) {
                    Object category3Value = LogsFragment.this.measurements.getCategoryValuesById(category3);
                    if (category3Value == null) {
                        category3Value = category3;
                    }
                    cats.add(category3Value);
                }
                result = result + StringUtils.join((Iterable)cats, (String)" - ");
                return result;
            }
        }){

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                View result = super.getView(position, convertView, parent);
                int color2 = position % 2 == 0 ? 2131230724 : 17170444;
                result.setBackgroundResource(color2);
                return result;
            }
        };
        this.dialogBuilder = new AlertDialog.Builder((Context)activity).setTitle(2131427369).setNegativeButton(0x1040000, UIUtils.getCancelClickListener());
        ListView logsList = (ListView)activity.findViewById(2131099776);
        logsList.setAdapter(this.adapter);
        logsList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                final MeasurementModel measurement = (MeasurementModel)parent.getItemAtPosition(position);
                LogsFragment.this.dialogBuilder.setMessage((CharSequence)LogsFragment.this.getString(2131427370, new Object[]{measurement.toString((Context)LogsFragment.this.getActivity(), LogsFragment.this.measurements.getPrecision())})).setPositiveButton(2131427346, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        LogsFragment.this.measurements.removeMeasurement(measurement);
                    }
                }).create().show();
                return true;
            }
        });
        for (MeasurementModel measurement : this.measurements.getMeasurements().values()) {
            this.onMeasurementAdded(this.measurements, measurement);
        }
        this.adapter.sort((Comparator)new Comparator<MeasurementModel>(){

            @Override
            public int compare(MeasurementModel lhs, MeasurementModel rhs) {
                return ObjectUtils.compare((Comparable)rhs.getDate(), (Comparable)lhs.getDate());
            }
        });
    }

    @Override
    public void onMeasurementAdded(MeasurementsModel source, MeasurementModel measurement) {
        this.adapter.insert((Object)measurement, 0);
    }

    @Override
    public void onMeasurementRemoved(MeasurementsModel source, MeasurementModel measurement) {
        this.adapter.remove((Object)measurement);
    }
}

