/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.measurement;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import fr.ifremer.wlo.measurement.GraphActivity;
import fr.ifremer.wlo.measurement.MeasurementsDisplayerFragment;
import fr.ifremer.wlo.models.MeasurementModel;
import fr.ifremer.wlo.models.MeasurementsModel;
import fr.ifremer.wlo.models.referentials.Mensuration;
import java.io.Serializable;
import java.text.NumberFormat;
import org.achartengine.ChartFactory;
import org.achartengine.GraphicalView;
import org.achartengine.chart.BarChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class GraphFragment
extends MeasurementsDisplayerFragment {
    private static final String TAG = "GraphFragment";
    protected GraphicalView mChartView;
    protected XYSeries mCurrentSeries;
    protected XYMultipleSeriesRenderer mRenderer;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(2130903078, container, false);
        return v;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        LinearLayout root = (LinearLayout)this.getView();
        this.mCurrentSeries = new XYSeries(this.getString(2131427367));
        XYMultipleSeriesDataset mDataset = new XYMultipleSeriesDataset();
        mDataset.addSeries(this.mCurrentSeries);
        XYSeriesRenderer mCurrentRenderer = new XYSeriesRenderer();
        mCurrentRenderer.setChartValuesFormat(NumberFormat.getIntegerInstance());
        mCurrentRenderer.setColor(this.getResources().getColor(17170450));
        mCurrentRenderer.setDisplayBoundingPoints(true);
        mCurrentRenderer.setDisplayChartValues(true);
        this.mRenderer = new XYMultipleSeriesRenderer();
        this.mRenderer.addSeriesRenderer((SimpleSeriesRenderer)mCurrentRenderer);
        this.mRenderer.setZoomEnabled(false, false);
        this.mRenderer.setPanEnabled(false, false);
        this.mRenderer.setYAxisMin(0.0);
        this.mChartView = ChartFactory.getBarChartView((Context)this.getActivity(), (XYMultipleSeriesDataset)mDataset, (XYMultipleSeriesRenderer)this.mRenderer, (BarChart.Type)BarChart.Type.DEFAULT);
        this.mChartView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                Intent i = new Intent((Context)GraphFragment.this.getActivity(), GraphActivity.class);
                i.putExtra("data", (Serializable)GraphFragment.this.mCurrentSeries);
                i.putExtra("measurements", (Serializable)GraphFragment.this.measurements);
                GraphFragment.this.startActivity(i);
                return true;
            }
        });
        for (MeasurementModel measurement : this.measurements.getMeasurements().values()) {
            this.addMeasurement(measurement);
        }
        root.addView((View)this.mChartView);
    }

    @Override
    public void onMeasurementAdded(MeasurementsModel source, MeasurementModel measurement) {
        this.addMeasurement(measurement);
        this.mChartView.repaint();
    }

    @Override
    public void onMeasurementRemoved(MeasurementsModel source, MeasurementModel measurement) {
        int size = measurement.getSize();
        int nb = this.measurements.getMeasurementNb(size);
        Mensuration.Precision precision = this.measurements.getPrecision();
        double dSize = (double)size / (double)precision.getUnitDivider();
        int index = this.mCurrentSeries.getIndexForKey(dSize);
        this.mCurrentSeries.remove(index);
        this.mCurrentSeries.add(index, dSize, (double)nb);
        this.mChartView.repaint();
    }

    protected void addMeasurement(MeasurementModel measurement) {
        int size = measurement.getSize();
        int nb = this.measurements.getMeasurementNb(size);
        Mensuration.Precision precision = this.measurements.getPrecision();
        double dSize = (double)size / (double)precision.getUnitDivider();
        double step = (double)precision.getValue() / (double)precision.getUnitDivider();
        double count = this.mCurrentSeries.getItemCount();
        if (precision.isDecimal()) {
            count = count * (double)precision.getValue() / (double)precision.getUnitDivider();
        }
        if (dSize >= count) {
            for (double i = count; i < dSize; i += step) {
                this.mCurrentSeries.add(i, 0.0);
            }
            this.mCurrentSeries.add(dSize, (double)nb);
        } else {
            int index = this.mCurrentSeries.getIndexForKey(dSize);
            this.mCurrentSeries.remove(index);
            this.mCurrentSeries.add(index, dSize, (double)nb);
        }
        this.updateAxis(dSize, nb);
    }

    protected void updateAxis(double size, int nb) {
        this.mRenderer.setXAxisMin(Math.min(this.mRenderer.getXAxisMin(), size - 1.0));
        this.mRenderer.setXAxisMax(Math.max(this.mRenderer.getXAxisMax(), size + 1.0));
        this.mRenderer.setYAxisMax(Math.max(this.mRenderer.getYAxisMax(), (double)(nb + 1)));
    }
}

