/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.measurement;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.measurement.MeasurementActivity;
import fr.ifremer.wlo.models.MeasurementsModel;
import java.io.Serializable;
import java.text.NumberFormat;
import org.achartengine.ChartFactory;
import org.achartengine.GraphicalView;
import org.achartengine.chart.BarChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class GraphActivity
extends WloBaseActivity {
    private static final String TAG = "GraphActivity";
    public static final String INTENT_EXTRA_DATA = "data";
    public static final String INTENT_EXTRA_MEASUREMENTS = "measurements";
    protected MeasurementsModel measurements;
    protected GraphicalView mChartView;
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;

    @Override
    protected Integer getContentView() {
        return 2130903077;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return MeasurementActivity.class;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LinearLayout root = (LinearLayout)this.findViewById(2131099774);
        this.mDataset = new XYMultipleSeriesDataset();
        this.mRenderer = new XYMultipleSeriesRenderer();
        this.mChartView = ChartFactory.getBarChartView((Context)this, (XYMultipleSeriesDataset)this.mDataset, (XYMultipleSeriesRenderer)this.mRenderer, (BarChart.Type)BarChart.Type.DEFAULT);
        root.addView((View)this.mChartView);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.measurements = (MeasurementsModel)this.getIntent().getSerializableExtra(INTENT_EXTRA_MEASUREMENTS);
        XYSeries mCurrentSeries = (XYSeries)this.getIntent().getSerializableExtra(INTENT_EXTRA_DATA);
        XYSeriesRenderer mCurrentRenderer = new XYSeriesRenderer();
        mCurrentRenderer.setChartValuesFormat(NumberFormat.getIntegerInstance());
        mCurrentRenderer.setColor(this.getResources().getColor(17170450));
        mCurrentRenderer.setDisplayBoundingPoints(true);
        mCurrentRenderer.setChartValuesFormat(NumberFormat.getIntegerInstance());
        mCurrentRenderer.setDisplayChartValues(true);
        this.mRenderer.removeAllRenderers();
        this.mDataset.clear();
        this.mRenderer.addSeriesRenderer((SimpleSeriesRenderer)mCurrentRenderer);
        this.mDataset.addSeries(mCurrentSeries);
        this.mChartView.repaint();
    }

    @Override
    public Intent getSupportParentActivityIntent() {
        Intent intent = super.getSupportParentActivityIntent();
        if (intent != null) {
            intent.putExtra(INTENT_EXTRA_MEASUREMENTS, (Serializable)this.measurements);
        }
        return intent;
    }
}

