/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo.imports;

import android.util.Log;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.models.referentials.CalcifiedPartTaking;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import java.util.Collection;
import java.util.Map;
import org.nuiton.csv.ValueSetter;
import org.nuiton.csv.ext.AbstractImportExportModel;

public class CalcifiedPartTakingRowModel
extends AbstractImportExportModel<CalcifiedPartTaking> {
    private static final String TAG = "CalcifiedPartTakingRowModel";

    public CalcifiedPartTakingRowModel(char separator, Collection<ScientificSpecies> scientificSpecies) {
        super(separator);
        ImmutableMap scientificSpeciesByCode = Maps.uniqueIndex(scientificSpecies, (Function)new Function<ScientificSpecies, String>(){

            public String apply(ScientificSpecies input) {
                return input.getCode();
            }
        });
        this.newMandatoryColumn("Espece_scientifique", (ValueSetter)new ValueSetter<CalcifiedPartTaking, String>((Map)scientificSpeciesByCode){
            final /* synthetic */ Map val$scientificSpeciesByCode;
            {
                this.val$scientificSpeciesByCode = map;
            }

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                if (value == null) {
                    throw new NullPointerException("L'espece scientifique ne peut etre nulle");
                }
                ScientificSpecies species = (ScientificSpecies)this.val$scientificSpeciesByCode.get(value);
                object.setParent(species);
            }
        });
        this.newMandatoryColumn("Classe_debut", (ValueSetter)new ValueSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                Log.d((String)CalcifiedPartTakingRowModel.TAG, (String)(object + "setStartSize " + size));
                object.setStartSize(size);
            }
        });
        this.newMandatoryColumn("Classe_fin", (ValueSetter)new ValueSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                Log.d((String)CalcifiedPartTakingRowModel.TAG, (String)(object + "setEndSize " + size));
                object.setEndSize(size);
            }
        });
        this.newMandatoryColumn("Pas_de_classe", (ValueSetter)new ValueSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size = Integer.parseInt(value);
                Log.d((String)CalcifiedPartTakingRowModel.TAG, (String)(object + "setSizeStep " + size));
                object.setSizeStep(size);
            }
        });
        this.newMandatoryColumn("Pas", (ValueSetter)new ValueSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size = Integer.parseInt(value);
                Log.d((String)CalcifiedPartTakingRowModel.TAG, (String)(object + "setStep " + size));
                object.setStep(size);
            }
        });
        this.newMandatoryColumn("Arret", (ValueSetter)new ValueSetter<CalcifiedPartTaking, String>(){

            public void set(CalcifiedPartTaking object, String value) throws Exception {
                Integer size;
                try {
                    size = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    size = null;
                }
                Log.d((String)CalcifiedPartTakingRowModel.TAG, (String)(object + "setStop " + size));
                object.setStop(size);
            }
        });
    }

    public CalcifiedPartTaking newEmptyInstance() {
        return new CalcifiedPartTaking();
    }
}

